/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.internal.IgniteDiagnosticAware;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearOptimisticTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.TxDeadlock;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.transactions.TransactionDeadlockException;
import org.apache.ignite.transactions.TransactionState;
import org.apache.ignite.transactions.TransactionTimeoutException;
import org.jetbrains.annotations.Nullable;

public class GridNearOptimisticTxPrepareFuture
extends GridNearOptimisticTxPrepareFutureAdapter
implements IgniteDiagnosticAware {
    private int miniId;
    private GridDhtTxMapping txMapping;

    public GridNearOptimisticTxPrepareFuture(GridCacheSharedContext cctx, GridNearTxLocal tx) {
        super(cctx, tx);
        assert (tx.optimistic() && !tx.serializable()) : tx;
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        if (log.isDebugEnabled()) {
            log.debug("Transaction future received owner changed callback: " + entry);
        }
        if (this.tx.remainingTime() == -1L) {
            return false;
        }
        if ((entry.context().isNear() || entry.context().isLocal()) && owner != null && this.tx.hasWriteKey(entry.txKey())) {
            if (this.keyLockFut != null) {
                this.keyLockFut.onKeyLocked(entry.txKey());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            ClusterTopologyCheckedException e = new ClusterTopologyCheckedException("Remote node left grid: " + nodeId);
            e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
            f.onNodeLeft(e, true);
            found = true;
        }
        return found;
    }

    private void onError(Throwable e, boolean discoThread) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.span);){
            if (e instanceof IgniteTxTimeoutCheckedException) {
                this.onTimeout();
                return;
            }
            if ((X.hasCause(e, ClusterTopologyCheckedException.class) || X.hasCause(e, ClusterTopologyException.class)) && this.tx.onePhaseCommit()) {
                this.tx.markForBackupCheck();
                this.onComplete();
                return;
            }
            if (ERR_UPD.compareAndSet(this, null, e)) {
                this.onComplete();
            }
        }
    }

    @Override
    public void onResult(UUID nodeId, GridNearTxPrepareResponse res) {
        if (!this.isDone()) {
            MiniFuture mini = this.miniFuture(res.miniId());
            if (mini != null) {
                assert (mini.node().id().equals(nodeId));
                mini.onResult(res);
            } else if (msgLog.isDebugEnabled()) {
                msgLog.debug("Near optimistic prepare fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near optimistic prepare fut, response for finished future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IgniteTxKey> requestedKeys() {
        this.compoundsReadLock();
        try {
            int size = this.futuresCountNoLock();
            for (int i = 0; i < size; ++i) {
                IgniteInternalFuture fut = this.future(i);
                if (!this.isMini(fut) || fut.isDone()) continue;
                MiniFuture miniFut = (MiniFuture)fut;
                Collection<IgniteTxEntry> entries = miniFut.mapping().entries();
                HashSet keys = U.newHashSet(entries.size());
                for (IgniteTxEntry entry : entries) {
                    keys.add(entry.txKey());
                }
                HashSet hashSet = keys;
                return hashSet;
            }
        }
        finally {
            this.compoundsReadUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(int miniId) {
        this.compoundsReadLock();
        try {
            int size = this.futuresCountNoLock();
            for (int i = size - 1; i >= 0; --i) {
                MiniFuture mini;
                IgniteInternalFuture fut = this.future(i);
                if (!this.isMini(fut) || (mini = (MiniFuture)fut).futureId() != miniId) continue;
                if (!mini.isDone()) {
                    MiniFuture miniFuture = mini;
                    return miniFuture;
                }
                MiniFuture miniFuture = null;
                return miniFuture;
            }
        }
        finally {
            this.compoundsReadUnlock();
        }
        return null;
    }

    @Override
    public boolean onDone(IgniteInternalTx t, Throwable err) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.span);){
            if (this.isDone()) {
                boolean bl = false;
                return bl;
            }
            ERR_UPD.compareAndSet(this, null, err);
            boolean bl = this.onComplete();
            return bl;
        }
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    private boolean onComplete() {
        Throwable err0 = this.err;
        if (!(this.tx.onePhaseCommit() && this.tx.mappings().get(this.cctx.localNodeId()) != null || err0 != null && !this.tx.needCheckBackup())) {
            this.tx.state(TransactionState.PREPARED);
        }
        if (super.onDone(this.tx, err0)) {
            GridCacheMvccManager mvcc = this.cctx.mvcc();
            if (mvcc != null) {
                mvcc.removeVersionedFuture(this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void prepare0(boolean remap, boolean topLocked) {
        try {
            boolean txStateCheck;
            boolean bl = remap ? this.tx.state() == TransactionState.PREPARING : (txStateCheck = this.tx.state(TransactionState.PREPARING));
            if (!txStateCheck) {
                if (this.tx.isRollbackOnly() || this.tx.setRollbackOnly()) {
                    if (this.tx.remainingTime() == -1L) {
                        this.onDone(this.tx.timeoutException());
                    } else {
                        this.onDone(this.tx.rollbackException());
                    }
                } else {
                    this.onDone(new IgniteCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.tx.state()) + ", tx=" + this + ']'));
                }
                return;
            }
            IgniteTxEntry singleWrite = this.tx.singleWrite();
            if (singleWrite != null) {
                this.prepareSingle(singleWrite, topLocked, remap);
            } else {
                this.prepare(this.tx.writeEntries(), topLocked, remap);
            }
            this.markInitialized();
        }
        catch (TransactionTimeoutException e) {
            this.onError(e, false);
        }
    }

    private void prepareSingle(IgniteTxEntry write, boolean topLocked, boolean remap) {
        write.clearEntryReadVersion();
        AffinityTopologyVersion topVer = this.tx.topologyVersion();
        assert (topVer.topologyVersion() > 0L);
        this.txMapping = new GridDhtTxMapping();
        GridDistributedTxMapping mapping = this.map(write, topVer, null, topLocked, remap);
        if (this.isDone()) {
            if (log.isDebugEnabled()) {
                log.debug("Abandoning (re)map because future is done: " + this);
            }
            return;
        }
        if (mapping.primary().isLocal()) {
            if (write.context().isNear()) {
                this.tx.nearLocallyMapped(true);
            } else if (write.context().isColocated()) {
                this.tx.colocatedLocallyMapped(true);
            }
        }
        if (this.keyLockFut != null) {
            this.keyLockFut.onAllKeysAdded();
        }
        this.tx.addSingleEntryMapping(mapping, write);
        this.recheckPendingLocks();
        mapping.last(true);
        this.tx.transactionNodes(this.txMapping.transactionNodes());
        if (!write.context().isNear()) {
            this.checkOnePhase(this.txMapping);
        }
        assert (!mapping.hasColocatedCacheEntries() || !mapping.hasNearCacheEntries()) : mapping;
        this.proceedPrepare(mapping, null);
    }

    private void prepare(Iterable<IgniteTxEntry> writes, boolean topLocked, boolean remap) {
        AffinityTopologyVersion topVer = this.tx.topologyVersion();
        assert (topVer.topologyVersion() > 0L);
        this.txMapping = new GridDhtTxMapping();
        HashMap<Object, GridDistributedTxMapping> map = new HashMap<Object, GridDistributedTxMapping>();
        GridDistributedTxMapping cur = null;
        ArrayDeque<GridDistributedTxMapping> mappings = new ArrayDeque<GridDistributedTxMapping>();
        boolean hasNearCache = false;
        for (IgniteTxEntry write : writes) {
            write.clearEntryReadVersion();
            GridDistributedTxMapping updated = this.map(write, topVer, cur, topLocked, remap);
            if (updated == null) break;
            if (write.context().isNear()) {
                hasNearCache = true;
            }
            if (cur == updated) continue;
            mappings.offer(updated);
            updated.last(true);
            ClusterNode primary = updated.primary();
            assert (!primary.isLocal() || !this.cctx.kernalContext().clientNode() || write.context().isLocal());
            Object key = this.cctx.kernalContext().clientNode() ? primary.id() : new MappingKey(primary.id(), primary.isLocal() && updated.hasNearCacheEntries());
            GridDistributedTxMapping prev = map.put(key, updated);
            if (prev != null) {
                prev.last(false);
            }
            if (updated.primary().isLocal()) {
                if (write.context().isNear()) {
                    this.tx.nearLocallyMapped(true);
                } else if (write.context().isColocated()) {
                    this.tx.colocatedLocallyMapped(true);
                }
            }
            cur = updated;
        }
        if (this.isDone()) {
            if (log.isDebugEnabled()) {
                log.debug("Abandoning (re)map because future is done: " + this);
            }
            return;
        }
        if (this.keyLockFut != null) {
            this.keyLockFut.onAllKeysAdded();
        }
        this.tx.addEntryMapping(mappings);
        this.recheckPendingLocks();
        this.tx.transactionNodes(this.txMapping.transactionNodes());
        if (!hasNearCache) {
            this.checkOnePhase(this.txMapping);
        }
        this.proceedPrepare(mappings);
    }

    private void proceedPrepare(Queue<GridDistributedTxMapping> mappings) {
        GridDistributedTxMapping m = mappings.poll();
        if (m == null) {
            return;
        }
        this.proceedPrepare(m, mappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedPrepare(GridDistributedTxMapping m, @Nullable Queue<GridDistributedTxMapping> mappings) {
        block20: {
            if (this.isDone()) {
                return;
            }
            boolean set = this.cctx.tm().setTxTopologyHint(this.tx.topologyVersionSnapshot());
            try {
                assert (!m.empty());
                ClusterNode n = m.primary();
                long timeout = this.tx.remainingTime();
                if (timeout != -1L) {
                    GridNearTxPrepareRequest req = new GridNearTxPrepareRequest(this.futId, this.tx.topologyVersion(), this.tx, timeout, null, m.writes(), m.hasNearCacheEntries(), this.txMapping.transactionNodes(), m.last(), this.tx.onePhaseCommit(), this.tx.needReturnValue() && this.tx.implicit(), this.tx.implicitSingle(), m.explicitLock(), this.tx.subjectId(), this.tx.taskNameHash(), m.clientFirst(), this.txMapping.transactionNodes().size() == 1, this.tx.activeCachesDeploymentEnabled(), this.tx.txState().recovery());
                    for (IgniteTxEntry txEntry : m.entries()) {
                        if (txEntry.op() != GridCacheOperation.TRANSFORM) continue;
                        req.addDhtVersion(txEntry.txKey(), null);
                    }
                    if (m.hasNearCacheEntries()) {
                        try {
                            this.cctx.tm().prepareTx(this.tx, m.nearCacheEntries());
                        }
                        catch (IgniteCheckedException e) {
                            this.onError(e, false);
                            if (set) {
                                this.cctx.tm().setTxTopologyHint(null);
                            }
                            return;
                        }
                    }
                    final MiniFuture fut = new MiniFuture(this, m, ++this.miniId, mappings);
                    req.miniId(fut.futureId());
                    this.add(fut);
                    if (n.isLocal()) {
                        assert (!m.hasColocatedCacheEntries() || !m.hasNearCacheEntries()) : m;
                        IgniteInternalFuture<GridNearTxPrepareResponse> prepFut = m.hasNearCacheEntries() ? this.cctx.tm().txHandler().prepareNearTxLocal(this.tx, req) : this.cctx.tm().txHandler().prepareColocatedTx(this.tx, req);
                        prepFut.listen((IgniteInClosure<IgniteInternalFuture<GridNearTxPrepareResponse>>)new CI1<IgniteInternalFuture<GridNearTxPrepareResponse>>(){

                            @Override
                            public void apply(IgniteInternalFuture<GridNearTxPrepareResponse> prepFut) {
                                try {
                                    fut.onResult(prepFut.get());
                                }
                                catch (IgniteCheckedException e) {
                                    fut.onResult(e);
                                }
                            }
                        });
                        break block20;
                    }
                    try {
                        this.cctx.io().send(n, (GridCacheMessage)req, this.tx.ioPolicy());
                        if (msgLog.isDebugEnabled()) {
                            msgLog.debug("Near optimistic prepare fut, sent request [txId=" + this.tx.nearXidVersion() + ", node=" + n.id() + ']');
                        }
                        break block20;
                    }
                    catch (ClusterTopologyCheckedException e) {
                        e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
                        fut.onNodeLeft(e, false);
                    }
                    catch (IgniteCheckedException e) {
                        if (msgLog.isDebugEnabled()) {
                            msgLog.debug("Near optimistic prepare fut, failed to sent request [txId=" + this.tx.nearXidVersion() + ", node=" + n.id() + ", err=" + e + ']');
                        }
                        fut.onResult(e);
                    }
                    break block20;
                }
                this.onTimeout();
            }
            finally {
                if (set) {
                    this.cctx.tm().setTxTopologyHint(null);
                }
            }
        }
    }

    private GridDistributedTxMapping map(IgniteTxEntry entry, AffinityTopologyVersion topVer, @Nullable GridDistributedTxMapping cur, boolean topLocked, boolean remap) {
        List<ClusterNode> nodes;
        GridCacheContext<?, ?> cacheCtx = entry.context();
        GridCacheEntryEx cached0 = entry.cached();
        if (cached0.isDht()) {
            nodes = cacheCtx.topology().nodes(cached0.partition(), topVer);
        } else {
            List<ClusterNode> list = nodes = cacheCtx.isLocal() ? cacheCtx.affinity().nodesByKey(entry.key(), topVer) : cacheCtx.topology().nodes(cacheCtx.affinity().partition(entry.key()), topVer);
        }
        if (F.isEmpty(nodes)) {
            ClusterTopologyServerNotFoundException e = new ClusterTopologyServerNotFoundException("Failed to map keys to nodes (partition is not mapped to any node) [key=" + entry.key() + ", partition=" + cacheCtx.affinity().partition(entry.key()) + ", topVer=" + topVer + ']');
            this.onDone(e);
            return null;
        }
        this.txMapping.addMapping(nodes);
        ClusterNode primary = F.first(nodes);
        assert (primary != null);
        if (log.isDebugEnabled()) {
            log.debug("Mapped key to primary node [key=" + entry.key() + ", part=" + cacheCtx.affinity().partition(entry.key()) + ", primary=" + U.toShortString(primary) + ", topVer=" + topVer + ']');
        }
        if (cacheCtx.isNear()) {
            entry.cached(cacheCtx.nearTx().entryExx(entry.key(), topVer));
        } else if (!cacheCtx.isLocal()) {
            entry.cached(cacheCtx.colocated().entryExx(entry.key(), topVer, true));
        } else {
            entry.cached(cacheCtx.local().entryEx(entry.key(), topVer));
        }
        if ((cacheCtx.isNear() || cacheCtx.isLocal()) && entry.explicitVersion() == null && !remap) {
            if (this.keyLockFut == null) {
                this.keyLockFut = new GridNearOptimisticTxPrepareFutureAdapter.KeyLockFuture();
                this.add(this.keyLockFut);
            }
            this.keyLockFut.addLockKey(entry.txKey());
        }
        if (cur == null || !cur.primary().id().equals(primary.id()) || primary.isLocal() && cur.hasNearCacheEntries() != cacheCtx.isNear()) {
            boolean clientFirst = cur == null && !topLocked && this.cctx.kernalContext().clientNode();
            cur = new GridDistributedTxMapping(primary);
            cur.clientFirst(clientFirst);
        }
        cur.add(entry);
        if (entry.explicitVersion() != null) {
            this.tx.markExplicit(primary.id());
            cur.markExplicitLock();
        }
        entry.nodeId(primary.id());
        if (cacheCtx.isNear()) {
            while (true) {
                try {
                    GridNearCacheEntry cached = (GridNearCacheEntry)entry.cached();
                    cached.dhtNodeId(this.tx.xidVersion(), primary.id());
                }
                catch (GridCacheEntryRemovedException ignore) {
                    entry.cached(cacheCtx.near().entryEx(entry.key(), topVer));
                    continue;
                }
                break;
            }
        }
        return cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTimeout() {
        block21: {
            try (MTC.TraceSurroundings ignored = MTC.support(this.span);){
                if (this.cctx.tm().deadlockDetectionEnabled()) {
                    HashSet<IgniteTxKey> keys = null;
                    if (this.keyLockFut != null) {
                        keys = new HashSet<IgniteTxKey>(this.keyLockFut.lockKeys);
                    } else {
                        this.compoundsReadLock();
                        try {
                            int size = this.futuresCountNoLock();
                            for (int i = 0; i < size; ++i) {
                                IgniteInternalFuture fut = this.future(i);
                                if (!this.isMini(fut) || fut.isDone()) continue;
                                MiniFuture miniFut = (MiniFuture)fut;
                                Collection<IgniteTxEntry> entries = miniFut.mapping().entries();
                                keys = U.newHashSet(entries.size());
                                for (IgniteTxEntry entry : entries) {
                                    keys.add(entry.txKey());
                                }
                                break;
                            }
                        }
                        finally {
                            this.compoundsReadUnlock();
                        }
                    }
                    this.add(new GridEmbeddedFuture<Object, TxDeadlock>(new IgniteBiClosure<TxDeadlock, Exception, Object>(){

                        @Override
                        public GridNearTxPrepareResponse apply(TxDeadlock deadlock, Exception e) {
                            if (e != null) {
                                U.warn(GridNearTxPrepareFutureAdapter.log, "Failed to detect deadlock.", e);
                            } else {
                                e = new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + GridNearOptimisticTxPrepareFuture.this.tx.timeout() + ", tx=" + CU.txString(GridNearOptimisticTxPrepareFuture.this.tx) + ']', deadlock != null ? new TransactionDeadlockException(deadlock.toString(GridNearOptimisticTxPrepareFuture.this.cctx)) : null);
                                if (!GridNearTxPrepareFutureAdapter.ERR_UPD.compareAndSet(GridNearOptimisticTxPrepareFuture.this, null, e) && GridNearOptimisticTxPrepareFuture.this.err instanceof IgniteTxTimeoutCheckedException) {
                                    GridNearOptimisticTxPrepareFuture.this.err = e;
                                }
                            }
                            GridNearOptimisticTxPrepareFuture.this.onDone(null, (Throwable)e);
                            return null;
                        }
                    }, this.cctx.tm().detectDeadlock(this.tx, keys)));
                    break block21;
                }
                ERR_UPD.compareAndSet(this, null, new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + this.tx.timeout() + ", tx=" + this.tx + ']'));
                this.onComplete();
            }
        }
    }

    @Override
    public void addDiagnosticRequest(IgniteDiagnosticPrepareContext ctx) {
        if (!this.isDone()) {
            for (IgniteInternalFuture fut : this.futures()) {
                if (fut.isDone()) continue;
                if (fut instanceof MiniFuture) {
                    MiniFuture miniFut = (MiniFuture)fut;
                    UUID nodeId = miniFut.node().id();
                    GridCacheVersion dhtVer = miniFut.m.dhtVersion();
                    GridCacheVersion nearVer = this.tx.nearXidVersion();
                    if (dhtVer != null) {
                        ctx.remoteTxInfo(nodeId, dhtVer, nearVer, "GridNearOptimisticTxPrepareFuture waiting for remote node response [nodeId=" + nodeId + ", topVer=" + this.tx.topologyVersion() + ", dhtVer=" + dhtVer + ", nearVer=" + nearVer + ", futId=" + this.futId + ", miniId=" + miniFut.futId + ", tx=" + this.tx + ']');
                        continue;
                    }
                    ctx.basicInfo(this.cctx.localNodeId(), "GridNearOptimisticTxPrepareFuture waiting for remote node response [nodeId=" + nodeId + ", topVer=" + this.tx.topologyVersion() + ", dhtVer=" + dhtVer + ", nearVer=" + nearVer + ", futId=" + this.futId + ", miniId=" + miniFut.futId + ", tx=" + this.tx + ']');
                    continue;
                }
                if (!(fut instanceof GridNearOptimisticTxPrepareFutureAdapter.KeyLockFuture)) continue;
                GridNearOptimisticTxPrepareFutureAdapter.KeyLockFuture keyFut = (GridNearOptimisticTxPrepareFutureAdapter.KeyLockFuture)fut;
                ctx.basicInfo(this.cctx.localNodeId(), "GridNearOptimisticTxPrepareFuture waiting for local keys lock [node=" + this.cctx.localNodeId() + ", topVer=" + this.tx.topologyVersion() + ", allKeysAdded=" + keyFut.allKeysAdded + ", keys=" + keyFut.lockKeys + ']');
            }
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                if (GridNearOptimisticTxPrepareFuture.this.isMini(f)) {
                    return "[node=" + ((MiniFuture)f).node().id() + ", loc=" + ((MiniFuture)f).node().isLocal() + ", done=" + f.isDone() + "]";
                }
                return f.toString();
            }
        }, new P1<IgniteInternalFuture<Object>>(){

            @Override
            public boolean apply(IgniteInternalFuture<Object> fut) {
                return GridNearOptimisticTxPrepareFuture.this.isMini(fut);
            }
        });
        return S.toString(GridNearOptimisticTxPrepareFuture.class, this, "innerFuts", futs, "tx", (Object)this.tx, "super", (Object)super.toString());
    }

    private static class MappingKey {
        private final UUID nodeId;
        private final boolean nearEntries;

        MappingKey(UUID nodeId, boolean nearEntries) {
            this.nodeId = nodeId;
            this.nearEntries = nearEntries;
        }

        public boolean equals(Object o) {
            MappingKey that = (MappingKey)o;
            return this.nearEntries == that.nearEntries && this.nodeId.equals(that.nodeId);
        }

        public int hashCode() {
            int res = this.nodeId.hashCode();
            res = 31 * res + (this.nearEntries ? 1 : 0);
            return res;
        }

        public String toString() {
            return S.toString(MappingKey.class, this);
        }
    }

    private static class MiniFuture
    extends GridFutureAdapter<GridNearTxPrepareResponse> {
        private static final AtomicIntegerFieldUpdater<MiniFuture> RCV_RES_UPD = AtomicIntegerFieldUpdater.newUpdater(MiniFuture.class, "rcvRes");
        private final GridNearOptimisticTxPrepareFuture parent;
        private final int futId;
        @GridToStringInclude
        private GridDistributedTxMapping m;
        private volatile int rcvRes;
        private Queue<GridDistributedTxMapping> mappings;

        MiniFuture(GridNearOptimisticTxPrepareFuture parent, GridDistributedTxMapping m, int futId, Queue<GridDistributedTxMapping> mappings) {
            this.parent = parent;
            this.m = m;
            this.futId = futId;
            this.mappings = mappings;
        }

        int futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.m.primary();
        }

        public GridDistributedTxMapping mapping() {
            return this.m;
        }

        void onResult(Throwable e) {
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                    GridNearTxPrepareFutureAdapter.log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
                }
                this.onDone(e);
            } else {
                U.warn(GridNearTxPrepareFutureAdapter.log, "Received error after another result has been processed [fut=" + this.parent + ", mini=" + this + ']', e);
            }
        }

        void onNodeLeft(ClusterTopologyCheckedException e, boolean discoThread) {
            if (GridNearTxPrepareFutureAdapter.msgLog.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.msgLog.debug("Near optimistic prepare fut, mini future node left [txId=" + this.parent.tx.nearXidVersion() + ", node=" + this.m.primary().id() + ']');
            }
            if (this.isDone()) {
                return;
            }
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                    GridNearTxPrepareFutureAdapter.log.debug("Remote node left grid while sending or waiting for reply (will not retry): " + this);
                }
                this.parent.onError(e, discoThread);
            }
        }

        void onResult(GridNearTxPrepareResponse res) {
            if (this.isDone()) {
                return;
            }
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                if (this.parent.tx.remainingTime() == -1L || res.error() instanceof IgniteTxTimeoutCheckedException) {
                    this.parent.onTimeout();
                    return;
                }
                if (res.error() != null) {
                    this.parent.onError(res.error(), false);
                } else if (res.clientRemapVersion() != null) {
                    assert (this.parent.cctx.kernalContext().clientNode());
                    assert (this.m.clientFirst());
                    IgniteInternalFuture<AffinityTopologyVersion> affFut = this.parent.cctx.exchange().affinityReadyFuture(res.clientRemapVersion());
                    this.parent.cctx.time().waitAsync(affFut, this.parent.tx.remainingTime(), (e, timedOut) -> {
                        if (this.parent.errorOrTimeoutOnTopologyVersion((IgniteCheckedException)e, (boolean)timedOut)) {
                            return;
                        }
                        this.remap();
                    });
                } else {
                    this.parent.onPrepareResponse(this.m, res, this.m.hasNearCacheEntries());
                    if (this.mappings != null) {
                        this.parent.proceedPrepare(this.mappings);
                    }
                    this.onDone((GridNearTxPrepareResponse)null);
                }
            }
        }

        private void remap() {
            if (this.parent.tx.isRollbackOnly()) {
                this.onDone(new IgniteTxRollbackCheckedException("Failed to prepare the transaction, due to the transaction is marked as rolled back [tx=" + CU.txString(this.parent.tx) + ']'));
                return;
            }
            this.parent.prepareOnTopology(true, new Runnable(){

                @Override
                public void run() {
                    this.onDone((GridNearTxPrepareResponse)null);
                }
            });
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", (Object)this.isCancelled(), "err", (Object)this.error());
        }
    }
}

