/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteServicesEx;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceCallContext;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.services.ServiceDescriptor;
import org.jetbrains.annotations.Nullable;

public class IgniteServicesImpl
extends AsyncSupportAdapter
implements IgniteServicesEx,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridKernalContext ctx;
    private ClusterGroupAdapter prj;

    public IgniteServicesImpl() {
    }

    public IgniteServicesImpl(GridKernalContext ctx, ClusterGroupAdapter prj, boolean async) {
        super(async);
        this.ctx = ctx;
        this.prj = prj;
    }

    @Override
    public ClusterGroup clusterGroup() {
        return this.prj;
    }

    @Override
    public void deployNodeSingleton(String name, Service svc) {
        A.notNull(name, "name");
        A.notNull(svc, "svc");
        this.guard();
        try {
            this.saveOrGet(this.ctx.service().deployNodeSingleton(this.prj, name, svc));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> deployNodeSingletonAsync(String name, Service svc) {
        A.notNull(name, "name");
        A.notNull(svc, "svc");
        this.guard();
        try {
            IgniteFutureImpl<Void> igniteFutureImpl = new IgniteFutureImpl<Void>(this.ctx.service().deployNodeSingleton(this.prj, name, svc));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void deployClusterSingleton(String name, Service svc) {
        A.notNull(name, "name");
        A.notNull(svc, "svc");
        this.guard();
        try {
            this.saveOrGet(this.ctx.service().deployClusterSingleton(this.prj, name, svc));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> deployClusterSingletonAsync(String name, Service svc) {
        A.notNull(name, "name");
        A.notNull(svc, "svc");
        this.guard();
        try {
            IgniteFutureImpl<Void> igniteFutureImpl = new IgniteFutureImpl<Void>(this.ctx.service().deployClusterSingleton(this.prj, name, svc));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void deployMultiple(String name, Service svc, int totalCnt, int maxPerNodeCnt) {
        A.notNull(name, "name");
        A.notNull(svc, "svc");
        this.guard();
        try {
            this.saveOrGet(this.ctx.service().deployMultiple(this.prj, name, svc, totalCnt, maxPerNodeCnt));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> deployMultipleAsync(String name, Service svc, int totalCnt, int maxPerNodeCnt) {
        A.notNull(name, "name");
        A.notNull(svc, "svc");
        this.guard();
        try {
            IgniteFutureImpl<Void> igniteFutureImpl = new IgniteFutureImpl<Void>(this.ctx.service().deployMultiple(this.prj, name, svc, totalCnt, maxPerNodeCnt));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void deployKeyAffinitySingleton(String name, Service svc, @Nullable String cacheName, Object affKey) {
        A.notNull(name, "name");
        A.notNull(svc, "svc");
        A.notNull(affKey, "affKey");
        this.guard();
        try {
            this.saveOrGet(this.ctx.service().deployKeyAffinitySingleton(name, svc, cacheName, affKey));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> deployKeyAffinitySingletonAsync(String name, Service svc, @Nullable String cacheName, Object affKey) {
        A.notNull(name, "name");
        A.notNull(svc, "svc");
        A.notNull(affKey, "affKey");
        this.guard();
        try {
            IgniteFutureImpl<Void> igniteFutureImpl = new IgniteFutureImpl<Void>(this.ctx.service().deployKeyAffinitySingleton(name, svc, cacheName, affKey));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void deploy(ServiceConfiguration cfg) {
        A.notNull(cfg, "cfg");
        this.deployAll(Collections.singleton(cfg));
    }

    @Override
    public IgniteFuture<Void> deployAsync(ServiceConfiguration cfg) {
        A.notNull(cfg, "cfg");
        return this.deployAllAsync(Collections.singleton(cfg));
    }

    @Override
    public void deployAll(Collection<ServiceConfiguration> cfgs) {
        A.notNull(cfgs, "cfgs");
        this.guard();
        try {
            this.saveOrGet(this.ctx.service().deployAll(this.prj, cfgs));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteFuture<Void> deployAllAsync(Collection<ServiceConfiguration> cfgs) {
        A.notNull(cfgs, "cfgs");
        this.guard();
        try {
            IgniteFutureImpl<Void> igniteFutureImpl = new IgniteFutureImpl<Void>(this.ctx.service().deployAll(this.prj, cfgs));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void cancel(String name) {
        A.notNull(name, "name");
        this.guard();
        try {
            this.saveOrGet(this.ctx.service().cancel(name));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteFuture<Void> cancelAsync(String name) {
        A.notNull(name, "name");
        this.guard();
        try {
            IgniteFutureImpl<Void> igniteFutureImpl = new IgniteFutureImpl<Void>(this.ctx.service().cancel(name));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void cancelAll(Collection<String> names) {
        this.guard();
        try {
            this.saveOrGet(this.ctx.service().cancelAll(names));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteFuture<Void> cancelAllAsync(Collection<String> names) {
        this.guard();
        try {
            IgniteFutureImpl<Void> igniteFutureImpl = new IgniteFutureImpl<Void>(this.ctx.service().cancelAll(names));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void cancelAll() {
        this.guard();
        try {
            this.saveOrGet(this.ctx.service().cancelAll());
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteFuture<Void> cancelAllAsync() {
        this.guard();
        try {
            IgniteFutureImpl<Void> igniteFutureImpl = new IgniteFutureImpl<Void>(this.ctx.service().cancelAll());
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<ServiceDescriptor> serviceDescriptors() {
        this.guard();
        try {
            Collection<ServiceDescriptor> collection = this.ctx.service().serviceDescriptors();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T> T service(String name) {
        this.guard();
        try {
            Object t = this.ctx.service().service(name);
            return t;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T> T serviceProxy(String name, Class<? super T> svcItf, boolean sticky) throws IgniteException {
        return this.serviceProxy(name, svcItf, sticky, 0L);
    }

    @Override
    public <T> T serviceProxy(String name, Class<? super T> svcItf, boolean sticky, long timeout) throws IgniteException {
        return this.serviceProxy(name, svcItf, sticky, (Supplier<ServiceCallContext>)null, timeout);
    }

    @Override
    public <T> T serviceProxy(String name, Class<? super T> svcItf, boolean sticky, @Nullable ServiceCallContext callCtx) throws IgniteException {
        return this.serviceProxy(name, svcItf, sticky, callCtx, 0L);
    }

    @Override
    public <T> T serviceProxy(String name, Class<? super T> svcItf, boolean sticky, @Nullable ServiceCallContext callCtx, long timeout) throws IgniteException {
        return this.serviceProxy(name, svcItf, sticky, callCtx != null ? () -> callCtx : null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T serviceProxy(String name, Class<? super T> svcItf, boolean sticky, @Nullable Supplier<ServiceCallContext> callCtxProvider, long timeout) throws IgniteException {
        A.notNull(name, "name");
        A.notNull(svcItf, "svcItf");
        A.ensure(svcItf.isInterface(), "Service class must be an interface: " + svcItf);
        A.ensure(timeout >= 0L, "Timeout cannot be negative: " + timeout);
        this.guard();
        try {
            T t = this.ctx.service().serviceProxy(this.prj, name, svcItf, sticky, callCtxProvider, timeout);
            return t;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T> Collection<T> services(String name) {
        this.guard();
        try {
            Collection collection = this.ctx.service().services(name);
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    private void guard() {
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        this.ctx.gateway().readUnlock();
    }

    @Override
    public IgniteServices withAsync() {
        if (this.isAsync()) {
            return this;
        }
        return new IgniteServicesImpl(this.ctx, this.prj, true);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.prj);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.prj = (ClusterGroupAdapter)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.prj.services();
    }
}

