/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet.convert;

import org.apache.parquet.example.data.Group;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;
import org.gridgain.bulkload.parquet.convert.ObjectPrimitiveConverter;

public class ObjectGroupConverter
extends GroupConverter {
    private final ObjectGroupConverter parent;
    private final int index;
    protected Group current;
    private final Converter[] converters;

    ObjectGroupConverter(ObjectGroupConverter parent, int index, GroupType schema) {
        this.parent = parent;
        this.index = index;
        this.converters = new Converter[schema.getFieldCount()];
        for (int i = 0; i < this.converters.length; ++i) {
            Type type = schema.getType(i);
            this.converters[i] = type.isPrimitive() ? new ObjectPrimitiveConverter(this, i) : new ObjectGroupConverter(this, i, type.asGroupType());
        }
    }

    public void start() {
        this.current = this.parent.getCurrentRecord().addGroup(this.index);
    }

    public void end() {
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public Group getCurrentRecord() {
        return this.current;
    }
}

