/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindMatchesParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindMatchesParameters> {
    private static final SdkField<String> PRIMARY_KEY_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryKeyColumnName").getter(FindMatchesParameters.getter(FindMatchesParameters::primaryKeyColumnName)).setter(FindMatchesParameters.setter(Builder::primaryKeyColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryKeyColumnName").build()}).build();
    private static final SdkField<Double> PRECISION_RECALL_TRADEOFF_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PrecisionRecallTradeoff").getter(FindMatchesParameters.getter(FindMatchesParameters::precisionRecallTradeoff)).setter(FindMatchesParameters.setter(Builder::precisionRecallTradeoff)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrecisionRecallTradeoff").build()}).build();
    private static final SdkField<Double> ACCURACY_COST_TRADEOFF_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AccuracyCostTradeoff").getter(FindMatchesParameters.getter(FindMatchesParameters::accuracyCostTradeoff)).setter(FindMatchesParameters.setter(Builder::accuracyCostTradeoff)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccuracyCostTradeoff").build()}).build();
    private static final SdkField<Boolean> ENFORCE_PROVIDED_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnforceProvidedLabels").getter(FindMatchesParameters.getter(FindMatchesParameters::enforceProvidedLabels)).setter(FindMatchesParameters.setter(Builder::enforceProvidedLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceProvidedLabels").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_KEY_COLUMN_NAME_FIELD, PRECISION_RECALL_TRADEOFF_FIELD, ACCURACY_COST_TRADEOFF_FIELD, ENFORCE_PROVIDED_LABELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PrimaryKeyColumnName", PRIMARY_KEY_COLUMN_NAME_FIELD);
            this.put("PrecisionRecallTradeoff", PRECISION_RECALL_TRADEOFF_FIELD);
            this.put("AccuracyCostTradeoff", ACCURACY_COST_TRADEOFF_FIELD);
            this.put("EnforceProvidedLabels", ENFORCE_PROVIDED_LABELS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String primaryKeyColumnName;
    private final Double precisionRecallTradeoff;
    private final Double accuracyCostTradeoff;
    private final Boolean enforceProvidedLabels;

    private FindMatchesParameters(BuilderImpl builder) {
        this.primaryKeyColumnName = builder.primaryKeyColumnName;
        this.precisionRecallTradeoff = builder.precisionRecallTradeoff;
        this.accuracyCostTradeoff = builder.accuracyCostTradeoff;
        this.enforceProvidedLabels = builder.enforceProvidedLabels;
    }

    public final String primaryKeyColumnName() {
        return this.primaryKeyColumnName;
    }

    public final Double precisionRecallTradeoff() {
        return this.precisionRecallTradeoff;
    }

    public final Double accuracyCostTradeoff() {
        return this.accuracyCostTradeoff;
    }

    public final Boolean enforceProvidedLabels() {
        return this.enforceProvidedLabels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryKeyColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.precisionRecallTradeoff());
        hashCode = 31 * hashCode + Objects.hashCode(this.accuracyCostTradeoff());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforceProvidedLabels());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindMatchesParameters)) {
            return false;
        }
        FindMatchesParameters other = (FindMatchesParameters)obj;
        return Objects.equals(this.primaryKeyColumnName(), other.primaryKeyColumnName()) && Objects.equals(this.precisionRecallTradeoff(), other.precisionRecallTradeoff()) && Objects.equals(this.accuracyCostTradeoff(), other.accuracyCostTradeoff()) && Objects.equals(this.enforceProvidedLabels(), other.enforceProvidedLabels());
    }

    public final String toString() {
        return ToString.builder((String)"FindMatchesParameters").add("PrimaryKeyColumnName", (Object)this.primaryKeyColumnName()).add("PrecisionRecallTradeoff", (Object)this.precisionRecallTradeoff()).add("AccuracyCostTradeoff", (Object)this.accuracyCostTradeoff()).add("EnforceProvidedLabels", (Object)this.enforceProvidedLabels()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryKeyColumnName": {
                return Optional.ofNullable(clazz.cast(this.primaryKeyColumnName()));
            }
            case "PrecisionRecallTradeoff": {
                return Optional.ofNullable(clazz.cast(this.precisionRecallTradeoff()));
            }
            case "AccuracyCostTradeoff": {
                return Optional.ofNullable(clazz.cast(this.accuracyCostTradeoff()));
            }
            case "EnforceProvidedLabels": {
                return Optional.ofNullable(clazz.cast(this.enforceProvidedLabels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FindMatchesParameters, T> g) {
        return obj -> g.apply((FindMatchesParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String primaryKeyColumnName;
        private Double precisionRecallTradeoff;
        private Double accuracyCostTradeoff;
        private Boolean enforceProvidedLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(FindMatchesParameters model) {
            this.primaryKeyColumnName(model.primaryKeyColumnName);
            this.precisionRecallTradeoff(model.precisionRecallTradeoff);
            this.accuracyCostTradeoff(model.accuracyCostTradeoff);
            this.enforceProvidedLabels(model.enforceProvidedLabels);
        }

        public final String getPrimaryKeyColumnName() {
            return this.primaryKeyColumnName;
        }

        public final void setPrimaryKeyColumnName(String primaryKeyColumnName) {
            this.primaryKeyColumnName = primaryKeyColumnName;
        }

        @Override
        public final Builder primaryKeyColumnName(String primaryKeyColumnName) {
            this.primaryKeyColumnName = primaryKeyColumnName;
            return this;
        }

        public final Double getPrecisionRecallTradeoff() {
            return this.precisionRecallTradeoff;
        }

        public final void setPrecisionRecallTradeoff(Double precisionRecallTradeoff) {
            this.precisionRecallTradeoff = precisionRecallTradeoff;
        }

        @Override
        public final Builder precisionRecallTradeoff(Double precisionRecallTradeoff) {
            this.precisionRecallTradeoff = precisionRecallTradeoff;
            return this;
        }

        public final Double getAccuracyCostTradeoff() {
            return this.accuracyCostTradeoff;
        }

        public final void setAccuracyCostTradeoff(Double accuracyCostTradeoff) {
            this.accuracyCostTradeoff = accuracyCostTradeoff;
        }

        @Override
        public final Builder accuracyCostTradeoff(Double accuracyCostTradeoff) {
            this.accuracyCostTradeoff = accuracyCostTradeoff;
            return this;
        }

        public final Boolean getEnforceProvidedLabels() {
            return this.enforceProvidedLabels;
        }

        public final void setEnforceProvidedLabels(Boolean enforceProvidedLabels) {
            this.enforceProvidedLabels = enforceProvidedLabels;
        }

        @Override
        public final Builder enforceProvidedLabels(Boolean enforceProvidedLabels) {
            this.enforceProvidedLabels = enforceProvidedLabels;
            return this;
        }

        public FindMatchesParameters build() {
            return new FindMatchesParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindMatchesParameters> {
        public Builder primaryKeyColumnName(String var1);

        public Builder precisionRecallTradeoff(Double var1);

        public Builder accuracyCostTradeoff(Double var1);

        public Builder enforceProvidedLabels(Boolean var1);
    }
}

