/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityMetricValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityMetricValues> {
    private static final SdkField<Double> ACTUAL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ActualValue").getter(DataQualityMetricValues.getter(DataQualityMetricValues::actualValue)).setter(DataQualityMetricValues.setter(Builder::actualValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualValue").build()}).build();
    private static final SdkField<Double> EXPECTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ExpectedValue").getter(DataQualityMetricValues.getter(DataQualityMetricValues::expectedValue)).setter(DataQualityMetricValues.setter(Builder::expectedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedValue").build()}).build();
    private static final SdkField<Double> LOWER_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LowerLimit").getter(DataQualityMetricValues.getter(DataQualityMetricValues::lowerLimit)).setter(DataQualityMetricValues.setter(Builder::lowerLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowerLimit").build()}).build();
    private static final SdkField<Double> UPPER_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UpperLimit").getter(DataQualityMetricValues.getter(DataQualityMetricValues::upperLimit)).setter(DataQualityMetricValues.setter(Builder::upperLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpperLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTUAL_VALUE_FIELD, EXPECTED_VALUE_FIELD, LOWER_LIMIT_FIELD, UPPER_LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ActualValue", ACTUAL_VALUE_FIELD);
            this.put("ExpectedValue", EXPECTED_VALUE_FIELD);
            this.put("LowerLimit", LOWER_LIMIT_FIELD);
            this.put("UpperLimit", UPPER_LIMIT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double actualValue;
    private final Double expectedValue;
    private final Double lowerLimit;
    private final Double upperLimit;

    private DataQualityMetricValues(BuilderImpl builder) {
        this.actualValue = builder.actualValue;
        this.expectedValue = builder.expectedValue;
        this.lowerLimit = builder.lowerLimit;
        this.upperLimit = builder.upperLimit;
    }

    public final Double actualValue() {
        return this.actualValue;
    }

    public final Double expectedValue() {
        return this.expectedValue;
    }

    public final Double lowerLimit() {
        return this.lowerLimit;
    }

    public final Double upperLimit() {
        return this.upperLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actualValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.lowerLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.upperLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityMetricValues)) {
            return false;
        }
        DataQualityMetricValues other = (DataQualityMetricValues)obj;
        return Objects.equals(this.actualValue(), other.actualValue()) && Objects.equals(this.expectedValue(), other.expectedValue()) && Objects.equals(this.lowerLimit(), other.lowerLimit()) && Objects.equals(this.upperLimit(), other.upperLimit());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityMetricValues").add("ActualValue", (Object)this.actualValue()).add("ExpectedValue", (Object)this.expectedValue()).add("LowerLimit", (Object)this.lowerLimit()).add("UpperLimit", (Object)this.upperLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActualValue": {
                return Optional.ofNullable(clazz.cast(this.actualValue()));
            }
            case "ExpectedValue": {
                return Optional.ofNullable(clazz.cast(this.expectedValue()));
            }
            case "LowerLimit": {
                return Optional.ofNullable(clazz.cast(this.lowerLimit()));
            }
            case "UpperLimit": {
                return Optional.ofNullable(clazz.cast(this.upperLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataQualityMetricValues, T> g) {
        return obj -> g.apply((DataQualityMetricValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double actualValue;
        private Double expectedValue;
        private Double lowerLimit;
        private Double upperLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityMetricValues model) {
            this.actualValue(model.actualValue);
            this.expectedValue(model.expectedValue);
            this.lowerLimit(model.lowerLimit);
            this.upperLimit(model.upperLimit);
        }

        public final Double getActualValue() {
            return this.actualValue;
        }

        public final void setActualValue(Double actualValue) {
            this.actualValue = actualValue;
        }

        @Override
        public final Builder actualValue(Double actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public final Double getExpectedValue() {
            return this.expectedValue;
        }

        public final void setExpectedValue(Double expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public final Builder expectedValue(Double expectedValue) {
            this.expectedValue = expectedValue;
            return this;
        }

        public final Double getLowerLimit() {
            return this.lowerLimit;
        }

        public final void setLowerLimit(Double lowerLimit) {
            this.lowerLimit = lowerLimit;
        }

        @Override
        public final Builder lowerLimit(Double lowerLimit) {
            this.lowerLimit = lowerLimit;
            return this;
        }

        public final Double getUpperLimit() {
            return this.upperLimit;
        }

        public final void setUpperLimit(Double upperLimit) {
            this.upperLimit = upperLimit;
        }

        @Override
        public final Builder upperLimit(Double upperLimit) {
            this.upperLimit = upperLimit;
            return this;
        }

        public DataQualityMetricValues build() {
            return new DataQualityMetricValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityMetricValues> {
        public Builder actualValue(Double var1);

        public Builder expectedValue(Double var1);

        public Builder lowerLimit(Double var1);

        public Builder upperLimit(Double var1);
    }
}

