/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.log4j2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class Log4jBridgeHandler
extends Handler {
    private static final String FQCN = Logger.class.getName();
    private static final String UNKNOWN_LOGGER_NAME = "unknown.jul.logger";
    private static final Formatter julFormatter = new SimpleFormatter();
    private static final Level FINEST = Level.forName((String)"FINEST", (int)(Level.TRACE.intLevel() + 100));
    private static final Level CONFIG = Level.forName((String)"CONFIG", (int)(Level.INFO.intLevel() + 50));
    private final ConcurrentMap<java.util.logging.Level, Level> julToLog4j = new ConcurrentHashMap<java.util.logging.Level, Level>(U.capacity((int)9));
    private final List<java.util.logging.Level> sortedJulLevels = new ArrayList<java.util.logging.Level>(9);

    public Log4jBridgeHandler() {
        this.julToLog4j.put(java.util.logging.Level.ALL, Level.ALL);
        this.julToLog4j.put(java.util.logging.Level.FINEST, FINEST);
        this.julToLog4j.put(java.util.logging.Level.FINER, Level.TRACE);
        this.julToLog4j.put(java.util.logging.Level.FINE, Level.DEBUG);
        this.julToLog4j.put(java.util.logging.Level.CONFIG, CONFIG);
        this.julToLog4j.put(java.util.logging.Level.INFO, Level.INFO);
        this.julToLog4j.put(java.util.logging.Level.WARNING, Level.WARN);
        this.julToLog4j.put(java.util.logging.Level.SEVERE, Level.ERROR);
        this.julToLog4j.put(java.util.logging.Level.OFF, Level.OFF);
        this.sortedJulLevels.addAll(this.julToLog4j.keySet());
        this.sortedJulLevels.sort(JulLevelComparator.INSTANCE);
    }

    public static void install() {
        if (Log4jBridgeHandler.isInstalled()) {
            return;
        }
        Logger rootLog = Log4jBridgeHandler.getJulRootLogger();
        for (Handler handler : rootLog.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            rootLog.removeHandler(handler);
        }
        rootLog.addHandler(new Log4jBridgeHandler());
    }

    public static boolean isInstalled() {
        return Arrays.stream(Log4jBridgeHandler.getJulRootLogger().getHandlers()).anyMatch(handler -> handler instanceof Log4jBridgeHandler);
    }

    @Override
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        org.apache.logging.log4j.Logger log4jLog = this.getLog4jLogger(record);
        Level level = this.toLevel(record.getLevel());
        String msg = julFormatter.formatMessage(record);
        Throwable thrown = record.getThrown();
        if (log4jLog instanceof ExtendedLogger) {
            try {
                ((ExtendedLogger)log4jLog).logIfEnabled(FQCN, level, null, msg, thrown);
            }
            catch (NoClassDefFoundError e) {
                log4jLog.warn("Log4jBridgeHandler: ignored exception when calling 'ExtendedLogger'", (Throwable)e);
                log4jLog.log(level, msg, thrown);
            }
        } else {
            log4jLog.log(level, msg, thrown);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    private static Logger getJulRootLogger() {
        return java.util.logging.LogManager.getLogManager().getLogger("");
    }

    private org.apache.logging.log4j.Logger getLog4jLogger(LogRecord record) {
        String name = record.getLoggerName();
        if (name == null) {
            name = UNKNOWN_LOGGER_NAME;
        }
        return LogManager.getLogger((String)name);
    }

    private Level toLevel(java.util.logging.Level julLevel) {
        if (julLevel == null) {
            return null;
        }
        Level level = (Level)this.julToLog4j.get(julLevel);
        if (level != null) {
            return level;
        }
        Level log4jLevel = this.nearestLevel(julLevel);
        this.julToLog4j.put(julLevel, log4jLevel);
        return log4jLevel;
    }

    private Level nearestLevel(java.util.logging.Level julLevel) {
        for (java.util.logging.Level level : this.sortedJulLevels) {
            if (JulLevelComparator.INSTANCE.compare(julLevel, level) > 0) continue;
            return (Level)this.julToLog4j.get(level);
        }
        return Level.OFF;
    }

    private static final class JulLevelComparator
    implements Comparator<java.util.logging.Level> {
        public static final Comparator<java.util.logging.Level> INSTANCE = new JulLevelComparator();

        private JulLevelComparator() {
        }

        @Override
        public int compare(java.util.logging.Level level1, java.util.logging.Level level2) {
            return Integer.compare(level1.intValue(), level2.intValue());
        }
    }
}

