/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.hibernate;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.CacheStoreSession;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.resources.LoggerResource;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;

public class CacheHibernateStoreSessionListener
implements CacheStoreSessionListener,
LifecycleAware {
    private SessionFactory sesFactory;
    private String hibernateCfgPath;
    @LoggerResource
    private IgniteLogger log;
    private boolean closeSesOnStop;

    public void setSessionFactory(SessionFactory sesFactory) {
        this.sesFactory = sesFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sesFactory;
    }

    public void setHibernateConfigurationPath(String hibernateCfgPath) {
        this.hibernateCfgPath = hibernateCfgPath;
    }

    public String getHibernateConfigurationPath() {
        return this.hibernateCfgPath;
    }

    public void start() throws IgniteException {
        if (this.sesFactory == null && F.isEmpty((String)this.hibernateCfgPath)) {
            throw new IgniteException("Either session factory or Hibernate configuration file is required by " + this.getClass().getSimpleName() + '.');
        }
        if (!F.isEmpty((String)this.hibernateCfgPath)) {
            if (this.sesFactory == null) {
                File cfgFile;
                try {
                    URL url = new URL(this.hibernateCfgPath);
                    this.sesFactory = new Configuration().configure(url).buildSessionFactory();
                }
                catch (MalformedURLException url) {
                    // empty catch block
                }
                if (this.sesFactory == null && (cfgFile = new File(this.hibernateCfgPath)).exists()) {
                    this.sesFactory = new Configuration().configure(cfgFile).buildSessionFactory();
                }
                if (this.sesFactory == null) {
                    this.sesFactory = new Configuration().configure(this.hibernateCfgPath).buildSessionFactory();
                }
                if (this.sesFactory == null) {
                    throw new IgniteException("Failed to resolve Hibernate configuration file: " + this.hibernateCfgPath);
                }
                this.closeSesOnStop = true;
            } else {
                U.warn((IgniteLogger)this.log, (Object)("Hibernate configuration file configured in " + this.getClass().getSimpleName() + " will be ignored (session factory is already set)."));
            }
        }
    }

    public void stop() throws IgniteException {
        if (this.closeSesOnStop && this.sesFactory != null && !this.sesFactory.isClosed()) {
            this.sesFactory.close();
        }
    }

    public void onSessionStart(CacheStoreSession ses) {
        if (ses.attachment() == null) {
            try {
                Session hibSes = this.sesFactory.openSession();
                ses.attach((Object)hibSes);
                if (ses.isWithinTransaction()) {
                    hibSes.beginTransaction();
                }
            }
            catch (HibernateException e) {
                throw new CacheWriterException("Failed to start store session [tx=" + ses.transaction() + ']', (Throwable)e);
            }
        }
    }

    public void onSessionEnd(CacheStoreSession ses, boolean commit) {
        Session hibSes = (Session)ses.attach(null);
        if (hibSes != null) {
            try {
                Transaction tx = hibSes.getTransaction();
                if (commit) {
                    hibSes.flush();
                    if (tx.isActive()) {
                        tx.commit();
                    }
                } else if (tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (HibernateException e) {
                throw new CacheWriterException("Failed to end store session [tx=" + ses.transaction() + ']', (Throwable)e);
            }
            finally {
                hibSes.close();
            }
        }
    }
}

