/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import java.util.Map;
import java.util.Properties;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyFactory;
import org.apache.ignite.cache.hibernate.HibernateCollectionRegion;
import org.apache.ignite.cache.hibernate.HibernateEntityRegion;
import org.apache.ignite.cache.hibernate.HibernateExceptionConverter;
import org.apache.ignite.cache.hibernate.HibernateKeyTransformer;
import org.apache.ignite.cache.hibernate.HibernateKeyWrapper;
import org.apache.ignite.cache.hibernate.HibernateNaturalIdRegion;
import org.apache.ignite.cache.hibernate.HibernateQueryResultsRegion;
import org.apache.ignite.cache.hibernate.HibernateTimestampsRegion;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;

public class HibernateRegionFactory
implements RegionFactory {
    private static final long serialVersionUID = 0L;
    static final HibernateExceptionConverter EXCEPTION_CONVERTER = new HibernateExceptionConverter(){

        public RuntimeException convert(Exception e) {
            return new CacheException((Throwable)e);
        }
    };
    private AccessType dfltAccessType;
    private final HibernateKeyTransformer hibernate4transformer = new HibernateKeyTransformer(){

        public Object transform(Object key) {
            if (key instanceof CacheKey) {
                CacheKey cacheKey = (CacheKey)key;
                return new HibernateKeyWrapper(cacheKey.getKey(), cacheKey.getEntityOrRoleName(), cacheKey.getTenantId());
            }
            return key;
        }
    };
    private final HibernateAccessStrategyFactory accessStgyFactory = new HibernateAccessStrategyFactory(this.hibernate4transformer, EXCEPTION_CONVERTER);

    public void start(Settings settings, Properties props) throws CacheException {
        String accessType = props.getProperty("org.apache.ignite.hibernate.default_access_type", AccessType.NONSTRICT_READ_WRITE.name());
        this.dfltAccessType = AccessType.valueOf((String)accessType);
        this.accessStgyFactory.start((Map)props);
    }

    HibernateAccessStrategyFactory accessStrategyFactory() {
        return this.accessStgyFactory;
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public AccessType getDefaultAccessType() {
        return this.dfltAccessType;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis();
    }

    public EntityRegion buildEntityRegion(String regionName, Properties props, CacheDataDescription metadata) throws CacheException {
        return new HibernateEntityRegion(this, regionName, this.accessStgyFactory.node(), this.accessStgyFactory.regionCache(regionName), metadata);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties props, CacheDataDescription metadata) throws CacheException {
        return new HibernateNaturalIdRegion(this, regionName, this.accessStgyFactory.node(), this.accessStgyFactory.regionCache(regionName), metadata);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties props, CacheDataDescription metadata) throws CacheException {
        return new HibernateCollectionRegion(this, regionName, this.accessStgyFactory.node(), this.accessStgyFactory.regionCache(regionName), metadata);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties props) throws CacheException {
        return new HibernateQueryResultsRegion(this, regionName, this.accessStgyFactory.node(), this.accessStgyFactory.regionCache(regionName));
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties props) throws CacheException {
        return new HibernateTimestampsRegion(this, regionName, this.accessStgyFactory.node(), this.accessStgyFactory.regionCache(regionName));
    }
}

