/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.its.ITSPublicEncryptionKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.its.ITSValidityPeriod;
import net.snowflake.client.jdbc.internal.org.bouncycastle.its.operator.ECDSAEncoder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.its.operator.ITSContentVerifierProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.OEREncoder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.Certificate;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.IssuerIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.PublicEncryptionKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.Signature;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.template.IEEE1609dot2;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.ContentVerifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Encodable;

public class ITSCertificate
implements Encodable {
    private final Certificate certificate;

    public ITSCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public IssuerIdentifier getIssuer() {
        return this.certificate.getCertificateBase().getIssuer();
    }

    public ITSValidityPeriod getValidityPeriod() {
        return new ITSValidityPeriod(this.certificate.getCertificateBase().getToBeSignedCertificate().getValidityPeriod());
    }

    public ITSPublicEncryptionKey getPublicEncryptionKey() {
        PublicEncryptionKey publicEncryptionKey = this.certificate.getCertificateBase().getToBeSignedCertificate().getEncryptionKey();
        if (publicEncryptionKey != null) {
            return new ITSPublicEncryptionKey(publicEncryptionKey);
        }
        return null;
    }

    public boolean isSignatureValid(ITSContentVerifierProvider iTSContentVerifierProvider) throws Exception {
        ContentVerifier contentVerifier = iTSContentVerifierProvider.get(this.certificate.getCertificateBase().getSignature().getChoice());
        OutputStream outputStream = contentVerifier.getOutputStream();
        outputStream.write(OEREncoder.toByteArray(this.certificate.getCertificateBase().getToBeSignedCertificate(), IEEE1609dot2.tbsCertificate));
        outputStream.close();
        Signature signature = this.certificate.getCertificateBase().getSignature();
        return contentVerifier.verify(ECDSAEncoder.toX962(signature));
    }

    public Certificate toASN1Structure() {
        return this.certificate;
    }

    public byte[] getEncoded() throws IOException {
        return OEREncoder.toByteArray(this.certificate.getCertificateBase(), IEEE1609dot2.certificate);
    }
}

