/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.DoesServiceRequest;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.OperationContext;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.ResultSegment;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.RetryPolicyFactory;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.ExecutionEngine;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.StorageRequest;

public final class LazySegmentedIterator<CLIENT_TYPE, PARENT_TYPE, ENTITY_TYPE>
implements Iterator<ENTITY_TYPE> {
    private ResultSegment<ENTITY_TYPE> currentSegment;
    private Iterator<ENTITY_TYPE> currentSegmentIterator;
    private final CLIENT_TYPE client;
    private final PARENT_TYPE parentObject;
    private final RetryPolicyFactory policyFactory;
    private final StorageRequest<CLIENT_TYPE, PARENT_TYPE, ResultSegment<ENTITY_TYPE>> segmentGenerator;
    private final OperationContext opContext;

    public LazySegmentedIterator(StorageRequest<CLIENT_TYPE, PARENT_TYPE, ResultSegment<ENTITY_TYPE>> segmentGenerator, CLIENT_TYPE client, PARENT_TYPE parent, RetryPolicyFactory policyFactory, OperationContext opContext) {
        this.segmentGenerator = segmentGenerator;
        this.parentObject = parent;
        this.opContext = opContext;
        this.policyFactory = policyFactory;
        this.client = client;
    }

    @Override
    @DoesServiceRequest
    public boolean hasNext() {
        while (this.currentSegment == null || !this.currentSegmentIterator.hasNext() && this.currentSegment != null && this.currentSegment.getHasMoreResults()) {
            try {
                this.currentSegment = ExecutionEngine.executeWithRetry(this.client, this.parentObject, this.segmentGenerator, this.policyFactory, this.opContext);
            }
            catch (StorageException e) {
                NoSuchElementException ex = new NoSuchElementException("An error occurred while enumerating the result, check the original exception for details.");
                ex.initCause(e);
                throw ex;
            }
            this.currentSegmentIterator = this.currentSegment.getResults().iterator();
            if (this.currentSegmentIterator.hasNext() || this.currentSegment.getHasMoreResults()) continue;
            return false;
        }
        return this.currentSegmentIterator.hasNext();
    }

    @Override
    public ENTITY_TYPE next() {
        if (this.hasNext()) {
            return this.currentSegmentIterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

