/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.rpc;

import java.util.concurrent.Callable;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.NonCancellableFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetryingFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallable;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.threeten.bp.Duration;

class CheckingAttemptCallable<RequestT, ResponseT>
implements Callable<ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final ApiCallContext originalCallContext;
    private volatile RetryingFuture<ResponseT> externalFuture;

    CheckingAttemptCallable(UnaryCallable<RequestT, ResponseT> callable, ApiCallContext callContext) {
        this.callable = Preconditions.checkNotNull(callable);
        this.originalCallContext = Preconditions.checkNotNull(callContext);
    }

    public void setExternalFuture(RetryingFuture<ResponseT> externalFuture) {
        this.externalFuture = Preconditions.checkNotNull(externalFuture);
    }

    @Override
    public ResponseT call() {
        ApiCallContext callContext = this.originalCallContext;
        try {
            Duration rpcTimeout = this.externalFuture.getAttemptSettings().getRpcTimeout();
            if (!rpcTimeout.isZero()) {
                callContext = callContext.withTimeout(rpcTimeout);
            }
            this.externalFuture.setAttemptFuture(new NonCancellableFuture());
            if (this.externalFuture.isDone()) {
                return null;
            }
            callContext.getTracer().attemptStarted(this.externalFuture.getAttemptSettings().getOverallAttemptCount());
            ApiFuture<ResponseT> internalFuture = this.callable.futureCall(null, callContext);
            this.externalFuture.setAttemptFuture(internalFuture);
        }
        catch (Throwable e) {
            this.externalFuture.setAttemptFuture(ApiFutures.immediateFailedFuture(e));
        }
        return null;
    }
}

