/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.tika.config;

import net.snowflake.client.jdbc.internal.apache.tika.log.TikaLoggerFactory;

public interface LoadErrorHandler {
    public static final LoadErrorHandler IGNORE = new LoadErrorHandler(){

        @Override
        public void handleLoadError(String classname, Throwable throwable) {
        }

        public String toString() {
            return "IGNORE";
        }
    };
    public static final LoadErrorHandler WARN = new LoadErrorHandler(){

        @Override
        public void handleLoadError(String classname, Throwable throwable) {
            TikaLoggerFactory.getLogger(LoadErrorHandler.class).warn("Unable to load {}", classname, throwable);
        }

        public String toString() {
            return "WARN";
        }
    };
    public static final LoadErrorHandler THROW = new LoadErrorHandler(){

        @Override
        public void handleLoadError(String classname, Throwable throwable) {
            throw new RuntimeException("Unable to load " + classname, throwable);
        }

        public String toString() {
            return "THROW";
        }
    };

    public void handleLoadError(String var1, Throwable var2);
}

