/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.UUID;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.plugin.security.SecuritySubjectType;

public class SecuritySubjectAdapter
implements SecuritySubject {
    private static final long serialVersionUID = 0L;
    private UUID id;
    private SecuritySubjectType type;
    @GridToStringInclude
    private Object login;
    private InetSocketAddress address;
    private SecurityPermissionSet permissions;
    private Certificate[] certificates;
    private transient boolean skipCertificates;

    public SecuritySubjectAdapter(UUID id, SecuritySubjectType type, Object login, InetSocketAddress address, SecurityPermissionSet permissions) {
        this(id, type, login, address, permissions, null);
    }

    public SecuritySubjectAdapter(UUID id, SecuritySubjectType type, Object login, InetSocketAddress address, SecurityPermissionSet permissions, Certificate[] certificates) {
        this.id = id;
        this.type = type;
        this.login = login;
        this.address = address;
        this.permissions = permissions;
        this.certificates = certificates;
    }

    public UUID id() {
        return this.id;
    }

    public SecuritySubjectType type() {
        return this.type;
    }

    public Object login() {
        return this.login;
    }

    public InetSocketAddress address() {
        return this.address;
    }

    public SecurityPermissionSet permissions() {
        return this.permissions;
    }

    public Certificate[] certificates() {
        return this.certificates;
    }

    public void skipCertificates() {
        this.skipCertificates = true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.address);
        if (!this.skipCertificates) {
            stream.writeObject(this.certificates);
        }
        stream.writeObject(this.id);
        stream.writeObject(this.login);
        stream.writeObject(this.permissions);
        stream.writeObject(this.type);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.address = (InetSocketAddress)stream.readObject();
        Object obj = stream.readObject();
        if (obj == null || obj.getClass().isArray()) {
            this.certificates = (Certificate[])obj;
            this.id = (UUID)stream.readObject();
        } else {
            this.id = (UUID)obj;
        }
        this.login = stream.readObject();
        this.permissions = (SecurityPermissionSet)stream.readObject();
        this.type = (SecuritySubjectType)stream.readObject();
    }

    public String toString() {
        return S.toString(SecuritySubjectAdapter.class, (Object)this);
    }
}

