/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.dr.VisorDrTopologyTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrTopologyTaskResult;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorDrTopologyTask
extends VisorMultiNodeTask<VisorDrTopologyTaskArgs, VisorDrTopologyTaskResult, VisorDrTopologyTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorJob<VisorDrTopologyTaskArgs, VisorDrTopologyTaskResult> job(VisorDrTopologyTaskArgs arg) {
        return new VisorDrTopologyJob(arg, this.debug);
    }

    @Nullable
    protected VisorDrTopologyTaskResult reduce0(List<ComputeJobResult> results) throws IgniteException {
        byte dataCenterId = 0;
        int serverNodesCnt = 0;
        int clientNodesCnt = 0;
        ArrayList senderHubs = new ArrayList();
        ArrayList receiverHubs = new ArrayList();
        ArrayList dataNodes = new ArrayList();
        ArrayList otherNodes = new ArrayList();
        for (ComputeJobResult result : results) {
            VisorDrTopologyTaskResult data = (VisorDrTopologyTaskResult)result.getData();
            if (data == null) continue;
            dataCenterId = data.getDataCenterId();
            serverNodesCnt += data.getServerNodesCount();
            clientNodesCnt += data.getClientNodesCount();
            senderHubs.addAll(data.getSenderHubs());
            receiverHubs.addAll(data.getReceiverHubs());
            dataNodes.addAll(data.getDataNodes());
            otherNodes.addAll(data.getOtherNodes());
        }
        return new VisorDrTopologyTaskResult(dataCenterId, serverNodesCnt, clientNodesCnt, senderHubs, receiverHubs, dataNodes, otherNodes);
    }

    private static class VisorDrTopologyJob
    extends VisorJob<VisorDrTopologyTaskArgs, VisorDrTopologyTaskResult> {
        private static final long serialVersionUID = 0L;

        public VisorDrTopologyJob(VisorDrTopologyTaskArgs arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorDrTopologyTaskResult run(@Nullable VisorDrTopologyTaskArgs arg) throws IgniteException {
            Objects.requireNonNull(arg, "arg");
            ClusterNode locNode = this.ignite.localNode();
            UUID locNodeId = locNode.id();
            String addresses = locNode.addresses().toString();
            boolean isLocNodeClient = locNode.isClient();
            String locNodeMode = isLocNodeClient ? "Client" : "Server";
            ArrayList<T3> senderHubs = new ArrayList<T3>(1);
            ArrayList<T3> receiverHubs = new ArrayList<T3>(1);
            ArrayList<T2> dataNodes = new ArrayList<T2>(1);
            ArrayList<T3> otherNodes = new ArrayList<T3>(1);
            GridGain plugin = (GridGain)this.ignite.plugin("GridGain");
            GridGainConfiguration pluginCfg = plugin.configuration();
            if (pluginCfg.getDrSenderConfiguration() != null) {
                senderHubs.add(new T3((Object)locNodeId, (Object)addresses, (Object)locNodeMode));
            }
            if (pluginCfg.getDrReceiverConfiguration() != null) {
                DrReceiverConfiguration cfg = pluginCfg.getDrReceiverConfiguration();
                String addr = cfg.getLocalInboundHost() + ":" + cfg.getLocalInboundPort();
                receiverHubs.add(new T3((Object)locNodeId, (Object)addr, (Object)locNodeMode));
            }
            if (CU.baselineNode((ClusterNode)locNode, (DiscoveryDataClusterState)this.ignite.context().state().clusterState())) {
                dataNodes.add(new T2((Object)locNodeId, (Object)addresses));
            }
            if (senderHubs.isEmpty() && receiverHubs.isEmpty() && dataNodes.isEmpty()) {
                otherNodes.add(new T3((Object)locNodeId, (Object)addresses, (Object)locNodeMode));
            }
            return new VisorDrTopologyTaskResult(pluginCfg.getDataCenterId(), isLocNodeClient ? 0 : 1, isLocNodeClient ? 1 : 0, arg.senderHubs() ? senderHubs : Collections.emptyList(), arg.receiverHubs() ? receiverHubs : Collections.emptyList(), arg.dataNodes() ? dataNodes : Collections.emptyList(), arg.otherNodes() ? otherNodes : Collections.emptyList());
        }
    }
}

