/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrReceiverInCacheMetrics;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.internal.processors.dr.DrAbstractMetricsAdapter;

class DrReceiverCacheMetricsAdapter
extends DrAbstractMetricsAdapter
implements DrReceiverInCacheMetrics,
DrReceiverOutMetrics {
    private static final String DR_RECEIVER_IN_REG_NAME = "receiver.";
    private final LongAdderMetric batchesReceived;
    private final LongAdderMetric entriesReceived;
    private final LongAdderMetric bytesReceived;
    private final LongAdderMetric batchesAcked;
    private final LongAdderMetric entriesAcked;
    private final LongAdderMetric bytesAcked;
    private final LongAdderMetric batchesSent;
    private final LongAdderMetric entriesSent;
    private final LongAdderMetric bytesSent;
    private final LongAdderMetric ackSndTime;

    DrReceiverCacheMetricsAdapter(GridKernalContext ctx, byte dcId, String cacheName) {
        super(ctx, "receiver.dc" + dcId + "." + cacheName);
        this.batchesReceived = this.reg.longAdderMetric("BatchesReceived", "Number of batches received from remote sender hubs.");
        this.entriesReceived = this.reg.longAdderMetric("EntriesReceived", "Number of entries received from remote sender hubs.");
        this.bytesReceived = this.reg.longAdderMetric("BytesReceived", "Total amount of bytes received from remote sender hubs.");
        this.batchesAcked = this.reg.longAdderMetric("BatchesAcked", "Amount of batches stored in receiver caches.");
        this.entriesAcked = this.reg.longAdderMetric("EntriesAcked", "Amount of entries stored in receiver caches.");
        this.bytesAcked = this.reg.longAdderMetric("BytesAcked", "Amount of bytes stored in receiver caches.");
        this.batchesSent = this.reg.longAdderMetric("BatchesSent", "Amount of batches waiting to be stored in receiver caches.");
        this.entriesSent = this.reg.longAdderMetric("EntriesSent", "Amount of entries waiting to be stored in receiver caches.");
        this.bytesSent = this.reg.longAdderMetric("BytesSent", "Amount of bytes waiting to be stored in receiver caches.");
        this.ackSndTime = this.reg.longAdderMetric("AckSndTime", "Total acknowledgment sent time in milliseconds.");
    }

    @Override
    public int batchesReceived() {
        return (int)this.batchesReceived.value();
    }

    @Override
    public long entriesReceived() {
        return this.entriesReceived.value();
    }

    @Override
    public long bytesReceived() {
        return this.bytesReceived.value();
    }

    @Override
    public int batchesSent() {
        return (int)this.batchesSent.value();
    }

    @Override
    public long entriesSent() {
        return this.entriesSent.value();
    }

    @Override
    public int batchesAcked() {
        return (int)this.batchesAcked.value();
    }

    @Override
    public long entriesAcked() {
        return this.entriesAcked.value();
    }

    @Override
    public long bytesSent() {
        return this.bytesSent.value();
    }

    @Override
    public long bytesAcked() {
        return this.bytesAcked.value();
    }

    @Override
    public double averageBatchAckTime() {
        long batches = this.batchesAcked();
        return batches > 0L ? (double)this.ackSendTime() * 1.0 / (double)batches : 0.0;
    }

    long ackSendTime() {
        return this.ackSndTime.value();
    }

    public void onBatchReceived(int entriesCnt, int bytesCnt) {
        this.batchesReceived.increment();
        this.entriesReceived.add((long)entriesCnt);
        this.bytesReceived.add((long)bytesCnt);
    }

    public void onBatchSent(int entryCnt, long byteCnt) {
        this.batchesSent.increment();
        this.entriesSent.add((long)entryCnt);
        this.bytesSent.add(byteCnt);
    }

    public void onBatchAcked(int entryCnt, long byteCnt, long spentTime) {
        this.batchesAcked.increment();
        this.ackSndTime.add(spentTime);
        this.entriesAcked.add((long)entryCnt);
        this.bytesAcked.add(byteCnt);
    }

    @Override
    public String toString() {
        return S.toString(DrReceiverCacheMetricsAdapter.class, (Object)this);
    }
}

