/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;

public class SnapshotEncryptionOptions
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String masterKeyName;
    private byte[] masterKeyDigest;
    private Map<Integer, GroupKeyEncrypted> encryptedCacheKeys;
    @GridToStringExclude
    private transient Map<Integer, GroupKey> decryptedCacheKeys;
    private boolean optimizedCompressedEncryption;

    public SnapshotEncryptionOptions(String masterKeyName, byte[] masterKeyDigest, Map<Integer, GroupKeyEncrypted> encryptedCacheKeys, boolean optimizedCompressedEncryption) {
        this.masterKeyName = masterKeyName;
        this.masterKeyDigest = masterKeyDigest;
        this.encryptedCacheKeys = encryptedCacheKeys;
        this.optimizedCompressedEncryption = optimizedCompressedEncryption;
    }

    public SnapshotEncryptionOptions() {
    }

    public String getMasterKeyName() {
        return this.masterKeyName;
    }

    public byte[] getMasterKeyDigest() {
        return this.masterKeyDigest;
    }

    public Map<Integer, GroupKeyEncrypted> getEncryptedCacheKeys() {
        return Collections.unmodifiableMap(this.encryptedCacheKeys);
    }

    public GroupKey getGroupKey(Integer grpId) {
        if (F.isEmpty(this.encryptedCacheKeys)) {
            return null;
        }
        assert (!F.isEmpty(this.decryptedCacheKeys)) : "Key decryption should be called before access";
        assert (this.encryptedCacheKeys.containsKey(grpId) == this.decryptedCacheKeys.containsKey(grpId)) : "Group does not have decrypted key, but has encrypted [grp=" + grpId + ']';
        return this.decryptedCacheKeys.get(grpId);
    }

    public boolean optimizedCompressedEncryption() {
        return this.optimizedCompressedEncryption;
    }

    public void decryptEncryptionKeys(EncryptionSpi encryptionSpi) {
        assert (!(encryptionSpi instanceof NoopEncryptionSpi)) : "Encryption is not supported.";
        byte[] locDigest = encryptionSpi.masterKeyDigest(this.masterKeyName);
        if (!Arrays.equals(this.masterKeyDigest, locDigest)) {
            throw new IgniteSpiException("The master key is different but has the same name [masterKeyName=" + this.masterKeyName + ", locDigest=" + Base64.getEncoder().encodeToString(locDigest) + ", extDigest=" + Base64.getEncoder().encodeToString(this.masterKeyDigest) + ']');
        }
        this.decryptedCacheKeys = new HashMap<Integer, GroupKey>();
        for (Map.Entry<Integer, GroupKeyEncrypted> grpEncryptedKey : this.encryptedCacheKeys.entrySet()) {
            this.decryptedCacheKeys.put(grpEncryptedKey.getKey(), new GroupKey(grpEncryptedKey.getValue().id(), encryptionSpi.decryptKey(grpEncryptedKey.getValue().key(), this.masterKeyName)));
        }
    }

    public byte getProtocolVersion() {
        return 2;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeMap((ObjectOutput)out, this.encryptedCacheKeys);
        U.writeLongString((DataOutput)out, (String)this.masterKeyName);
        U.writeByteArray((DataOutput)out, (byte[])this.masterKeyDigest);
        out.writeBoolean(this.optimizedCompressedEncryption);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.encryptedCacheKeys = U.readMap((ObjectInput)in);
        this.masterKeyName = U.readLongString((DataInput)in);
        this.masterKeyDigest = U.readByteArray((DataInput)in);
        if (protoVer > 1) {
            this.optimizedCompressedEncryption = in.readBoolean();
        }
    }

    public String toString() {
        return S.toString(SnapshotEncryptionOptions.class, (Object)((Object)this));
    }
}

