/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cache.configuration.CompleteConfiguration;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.jetbrains.annotations.Nullable;

public class CacheSnapshotMetadata
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final IgniteProductVersion FIRST_VERSION_WHEN_ISSUE_WITH_PART_SIZES_WAS_FIXED = IgniteProductVersion.fromString((String)"2.4.4");
    @Deprecated
    private Collection<CacheConfiguration> cacheCfgs;
    private Collection<StoredCacheData> storedCacheDatas;
    private Map<String, byte[]> cacheCfgsBinary;
    private int grpId;
    private String cacheOrGrpName;
    @GridToStringInclude
    @Deprecated
    @Nullable
    private Long prevSnapshotId;
    @GridToStringInclude
    private Map<String, Long> prevSnapshotIds;
    private Map<Integer, Map<String, Integer>> partCntrs;
    private Map<Integer, Long> partUpdCntrs;

    public CacheSnapshotMetadata(Collection<StoredCacheData> storedCacheDatas, int grpId, String cacheOrGrpName, String consistentId, @Nullable Long prevSnapshotId, Map<Integer, Map<String, Integer>> partSizes, Map<Integer, Long> partCntrs) {
        this(storedCacheDatas, grpId, cacheOrGrpName, Collections.singletonMap(consistentId, prevSnapshotId), partSizes, partCntrs);
    }

    public CacheSnapshotMetadata(Collection<StoredCacheData> storedCacheDatas, int grpId, String cacheOrGrpName, Map<String, Long> prevSnapshotIds, Map<Integer, Map<String, Integer>> partSizes, Map<Integer, Long> partCntrs) {
        this(storedCacheDatas, grpId, cacheOrGrpName, null, prevSnapshotIds, partSizes, partCntrs);
    }

    private CacheSnapshotMetadata(Collection<StoredCacheData> storedCacheDatas, int grpId, String cacheOrGrpName, @Nullable Long prevSnapshotId, Map<String, Long> prevSnapshotIds, Map<Integer, Map<String, Integer>> partSizes, Map<Integer, Long> partCntrs) {
        this.storedCacheDatas = storedCacheDatas;
        this.grpId = grpId;
        this.cacheOrGrpName = cacheOrGrpName;
        this.prevSnapshotId = prevSnapshotId;
        this.partCntrs = partSizes;
        this.partUpdCntrs = partCntrs;
        this.prevSnapshotIds = prevSnapshotIds;
    }

    public Collection<CacheConfiguration> cacheConfigurations() {
        return this.storedCacheDatas.stream().map(StoredCacheData::config).collect(Collectors.toList());
    }

    public Collection<StoredCacheData> storedCacheDataList() {
        return this.storedCacheDatas;
    }

    public Map<Integer, Map<String, Integer>> partitionSizesPerNode() {
        return this.partCntrs;
    }

    public Map<Integer, Long> partitionCounters() {
        return this.partUpdCntrs;
    }

    public Collection<Long> previousSnapshotIds() {
        return Collections.unmodifiableCollection(this.prevSnapshotIds.values());
    }

    @Nullable
    public Long previousSnapshotId(String consistentId) {
        return this.prevSnapshotIds.getOrDefault(consistentId, this.prevSnapshotId);
    }

    public Set<String> cacheNames() {
        if (this.cacheCfgsBinary != null) {
            return this.cacheCfgsBinary.keySet();
        }
        HashSet<String> cacheNames = new HashSet<String>();
        for (StoredCacheData cfg : this.storedCacheDatas) {
            cacheNames.add(cfg.config().getName());
        }
        return cacheNames;
    }

    public int groupId() {
        return this.grpId;
    }

    public String cacheOrGroupName() {
        return this.cacheOrGrpName;
    }

    public CacheSnapshotMetadata merge(CacheSnapshotMetadata other, Set<IgniteProductVersion> versions, boolean exchangelessSnapshot) throws IgniteCheckedException {
        if (!F.eq((Object)this.prevSnapshotId, (Object)other.prevSnapshotId) && this.prevSnapshotId != null && other.prevSnapshotId != null) {
            throw new IgniteCheckedException("Failed to merge snapshot metadata (different previous snapshot ID) [prev=" + this.prevSnapshotId + ", otherPrev=" + other.prevSnapshotId + ']');
        }
        if (this.grpId != other.grpId) {
            throw new IgniteCheckedException("Failed to merge snapshot metadata (different cache groups) [cache=" + this.cacheOrGrpName + ", otherCache=" + other.cacheOrGrpName + "]");
        }
        Map<Integer, Map<String, Integer>> oldSizes = other.partitionSizesPerNode();
        for (Map.Entry<Integer, Map<String, Integer>> entry : this.partCntrs.entrySet()) {
            Integer n = entry.getKey();
            assert (n != null);
            Map<String, Integer> partSize = entry.getValue();
            assert (partSize != null);
            Map<String, Integer> partSizeFromOldMeta = oldSizes.get(n);
            if (partSizeFromOldMeta == null) {
                oldSizes.put(n, partSize);
                continue;
            }
            int partCnt = -1;
            for (Map.Entry<String, Integer> e : partSize.entrySet()) {
                String consId = e.getKey();
                Integer val = e.getValue();
                Integer cnt = partSizeFromOldMeta.get(consId);
                if (cnt != null) {
                    if (!Objects.equals(cnt, val)) {
                        throw new IgniteCheckedException("Failed to merge cache snapshot metadata (different partition sizes for the same consistent ID) [cache=" + this.cacheOrGrpName + ", partition=" + n + ", consId=" + consId + ']');
                    }
                } else {
                    partSizeFromOldMeta.put(consId, val);
                }
                if ((partCnt == 0 && val > 0 || partCnt > 0 && val == 0) && !this.ignoreIssueWithDifferentPartSizes(versions) && !exchangelessSnapshot) {
                    throw new IgniteCheckedException("Failed to merge cache metadata (partition counter was not initialized for consistent ID) [cache=" + this.cacheOrGrpName + ", consId=" + consId + ", part=" + n + ']');
                }
                partCnt = val;
            }
        }
        Map<Integer, Long> oldPartCntrs = other.partitionCounters();
        if (this.partUpdCntrs != null) {
            if (oldPartCntrs == null) {
                oldPartCntrs = new HashMap<Integer, Long>();
            }
            for (Map.Entry<Integer, Long> entry : this.partUpdCntrs.entrySet()) {
                Long cntr = entry.getValue();
                oldPartCntrs.compute(entry.getKey(), (k, v) -> v == null ? cntr : Math.max(v, cntr));
            }
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>(other.prevSnapshotIds);
        hashMap.putAll(this.prevSnapshotIds);
        return new CacheSnapshotMetadata(this.storedCacheDatas, this.grpId, this.cacheOrGrpName, this.prevSnapshotId != null ? this.prevSnapshotId : other.prevSnapshotId, hashMap, oldSizes, oldPartCntrs);
    }

    private boolean ignoreIssueWithDifferentPartSizes(Set<IgniteProductVersion> versions) {
        for (IgniteProductVersion version : versions) {
            if (version.compareTo(FIRST_VERSION_WHEN_ISSUE_WITH_PART_SIZES_WAS_FIXED) >= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasCacheConfiguration() {
        return !this.storedCacheDatas.isEmpty();
    }

    public boolean checkPartitions() {
        Iterator<StoredCacheData> iter = this.storedCacheDatas.iterator();
        if (iter.hasNext()) {
            return this.partCntrs.size() == iter.next().config().getAffinity().partitions();
        }
        throw new IgniteException("No cache configuration. You should check that it exists before checking.");
    }

    public boolean isEncryptionEnabled() {
        StoredCacheData firstCache = (StoredCacheData)F.first(this.storedCacheDatas);
        return firstCache != null && firstCache.config().isEncryptionEnabled();
    }

    void prepareMarshal() throws IgniteCheckedException {
        if (this.storedCacheDatas == null) {
            return;
        }
        JdkMarshaller marsh = new JdkMarshaller();
        this.cacheCfgsBinary = new HashMap<String, byte[]>(this.storedCacheDatas.size());
        for (StoredCacheData cfg : this.storedCacheDatas) {
            byte[] bytes = marsh.marshal((Object)cfg);
            this.cacheCfgsBinary.put(cfg.config().getName(), bytes);
        }
        this.storedCacheDatas = null;
        this.cacheCfgs = null;
    }

    void finishUnmarshal(ClassLoader ldr, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses) throws IgniteCheckedException {
        if (this.cacheCfgsBinary == null) {
            return;
        }
        JdkMarshaller marsh = new JdkMarshaller();
        this.storedCacheDatas = new ArrayList<StoredCacheData>(this.cacheCfgsBinary.size());
        for (String cacheName : this.cacheCfgsBinary.keySet()) {
            StoredCacheData storedCacheData;
            block11: {
                storedCacheData = null;
                try {
                    Object unmarshaledObj = marsh.unmarshal(this.cacheCfgsBinary.get(cacheName), ldr);
                    storedCacheData = unmarshaledObj instanceof CacheConfiguration ? new StoredCacheData((CacheConfiguration)unmarshaledObj) : (StoredCacheData)unmarshaledObj;
                }
                catch (IgniteCheckedException e) {
                    if ((c != null || ignoreMissedClasses) && X.hasCause((Throwable)e, (Class[])new Class[]{ClassNotFoundException.class})) break block11;
                    throw e;
                }
            }
            if (c != null) {
                if (storedCacheData == null) {
                    storedCacheData = new StoredCacheData((CacheConfiguration)c.apply((Object)cacheName, null));
                } else {
                    CacheConfiguration cfg = new CacheConfiguration((CompleteConfiguration)storedCacheData.config());
                    cfg.clearQueryEntities();
                    cfg.setQueryEntities(storedCacheData.queryEntities());
                    cfg = (CacheConfiguration)c.apply((Object)cacheName, (Object)cfg);
                    storedCacheData.config(cfg);
                    storedCacheData.queryEntities(cfg.getQueryEntities());
                }
            }
            if (storedCacheData != null) {
                this.storedCacheDatas.add(storedCacheData);
            }
            if (storedCacheData != null || ignoreMissedClasses) continue;
            throw new IgniteCheckedException("can't deserialize configuration for cache " + cacheName);
        }
        if (this.prevSnapshotIds == null) {
            Map snapIds;
            if (this.prevSnapshotId != null) {
                snapIds = new HashMap();
                Map<Integer, Map<String, Integer>> cntrs = this.partCntrs;
                Long oldPrevSnapshotId = this.prevSnapshotId;
                cntrs.values().stream().flatMap(map -> map.keySet().stream()).distinct().forEach(consId -> snapIds.put(consId, oldPrevSnapshotId));
            } else {
                snapIds = Collections.emptyMap();
            }
            this.prevSnapshotIds = snapIds;
        }
    }

    public String toString() {
        return S.toString(CacheSnapshotMetadata.class, (Object)this, (String)"cache", (Object)this.cacheOrGrpName);
    }
}

