/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.interop.product;

import java.util.Calendar;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.GridProduct;
import org.gridgain.grid.product.ProductLicense;

public class InteropProduct
extends PlatformAbstractTarget {
    private static final int OP_UPDATE_LICENSE = 2;
    private static final int OP_GRACE_PERIOD_LEFT = 3;
    private static final int OP_LICENSE_RAW = 4;
    private final GridProduct product;

    public InteropProduct(PlatformContext platformCtx) {
        super(platformCtx);
        GridGain gg = (GridGain)platformCtx.kernalContext().grid().plugin("GridGain");
        this.product = gg.product();
    }

    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 2: {
                this.product.updateLicense(reader.readString());
                return 1L;
            }
        }
        return super.processInStreamOutLong(type, reader);
    }

    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 3: {
                return this.product.gracePeriodLeft();
            }
        }
        return super.processInLongOutLong(type, val);
    }

    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 4: {
                InteropProduct.writeLicense((BinaryRawWriter)writer, this.product.license());
                return;
            }
        }
        super.processOutStream(type, writer);
    }

    private static void writeLicense(BinaryRawWriter w, ProductLicense lic) {
        w.writeUuid(lic.id());
        w.writeString(lic.version());
        w.writeString(lic.versionRegexp());
        Calendar cal = Calendar.getInstance();
        cal.setTime(lic.issueDate());
        w.writeShort((short)cal.get(1));
        w.writeByte((byte)cal.get(2));
        w.writeByte((byte)cal.get(5));
        w.writeInt(lic.maintenanceTime());
        w.writeString(lic.issueOrganization());
        w.writeString(lic.userOrganization());
        w.writeString(lic.licenseNote());
        w.writeString(lic.userWww());
        w.writeString(lic.userEmail());
        w.writeString(lic.userName());
        w.writeDate(lic.expireDate());
        w.writeInt(lic.maxNodes());
        w.writeInt(lic.maxComputers());
        w.writeInt(lic.maxCpus());
        w.writeLong(lic.maxUpTime());
        w.writeLong(lic.gracePeriod());
        w.writeString(lic.attributeName());
        w.writeString(lic.attributeValue());
    }
}

