/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.communication;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.direct.state.DirectMessageState;
import org.apache.ignite.internal.direct.state.DirectMessageStateItem;
import org.apache.ignite.internal.direct.stream.DirectByteBufferStream;
import org.apache.ignite.internal.direct.stream.v1.DirectByteBufferStreamImplV1;
import org.apache.ignite.internal.direct.stream.v2.DirectByteBufferStreamImplV2;
import org.apache.ignite.internal.direct.stream.v3.DirectByteBufferStreamImplV3;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

class RollingUpgradeMessageWriter
implements MessageWriter {
    private final IgniteBiPredicate<Class<? extends Message>, String> msgFieldFilter;
    @GridToStringInclude
    private final DirectMessageState<StateItem> state;
    @GridToStringInclude
    private final byte protoVer;

    public RollingUpgradeMessageWriter(@Nullable IgniteBiPredicate<Class<? extends Message>, String> msgFieldFilter, final byte protoVer) {
        this.msgFieldFilter = msgFieldFilter;
        this.state = new DirectMessageState(StateItem.class, (IgniteOutClosure)new IgniteOutClosure<StateItem>(){

            public StateItem apply() {
                return new StateItem(protoVer);
            }
        });
        this.protoVer = protoVer;
    }

    public void setBuffer(ByteBuffer buf) {
        ((StateItem)this.state.item()).stream.setBuffer(buf);
    }

    public void setCurrentWriteClass(Class<? extends Message> msgCls) {
        ((StateItem)this.state.item()).writeMsgCls = msgCls;
    }

    public boolean writeHeader(short type, byte fieldCnt) {
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        if (stream.remaining() < 3) {
            return false;
        }
        stream.writeShort(type);
        stream.writeByte(fieldCnt);
        return true;
    }

    public boolean writeByte(String name, byte val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)1)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeByte(val);
        return stream.lastFinished();
    }

    public boolean writeShort(String name, short val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)2)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeShort(val);
        return stream.lastFinished();
    }

    public boolean writeInt(String name, int val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)3)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeInt(val);
        return stream.lastFinished();
    }

    public boolean writeLong(String name, long val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)4)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeLong(val);
        return stream.lastFinished();
    }

    public boolean writeFloat(String name, float val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)5)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeFloat(val);
        return stream.lastFinished();
    }

    public boolean writeDouble(String name, double val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)6)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeDouble(val);
        return stream.lastFinished();
    }

    public boolean writeChar(String name, char val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)7)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeChar(val);
        return stream.lastFinished();
    }

    public boolean writeBoolean(String name, boolean val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)8)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeBoolean(val);
        return stream.lastFinished();
    }

    public boolean writeByteArray(String name, byte[] val) {
        return this.writeByteArray(name, val, 0L, val != null ? val.length : 0);
    }

    public boolean writeByteArray(String name, byte[] val, long off, int len) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)9)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeByteArray(val, off, len);
        return stream.lastFinished();
    }

    public boolean writeShortArray(String name, short[] val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)10)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeShortArray(val);
        return stream.lastFinished();
    }

    public boolean writeIntArray(String name, int[] val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)11)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeIntArray(val);
        return stream.lastFinished();
    }

    public boolean writeLongArray(String name, long[] val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)12)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeLongArray(val);
        return stream.lastFinished();
    }

    public boolean writeLongArray(String name, long[] val, int len) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)12)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeLongArray(val, len);
        return stream.lastFinished();
    }

    public boolean writeFloatArray(String name, float[] val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)13)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeFloatArray(val);
        return stream.lastFinished();
    }

    public boolean writeDoubleArray(String name, double[] val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)14)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeDoubleArray(val);
        return stream.lastFinished();
    }

    public boolean writeCharArray(String name, char[] val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)15)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeCharArray(val);
        return stream.lastFinished();
    }

    public boolean writeBooleanArray(String name, boolean[] val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)16)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeBooleanArray(val);
        return stream.lastFinished();
    }

    public boolean writeString(String name, String val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)17)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeString(val);
        return stream.lastFinished();
    }

    public boolean writeBitSet(String name, BitSet val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)18)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeBitSet(val);
        return stream.lastFinished();
    }

    public boolean writeUuid(String name, UUID val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)19)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeUuid(val);
        return stream.lastFinished();
    }

    public boolean writeIgniteUuid(String name, IgniteUuid val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)20)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeIgniteUuid(val);
        return stream.lastFinished();
    }

    public boolean writeAffinityTopologyVersion(String name, AffinityTopologyVersion val) {
        if (this.protoVer >= 3) {
            if (this.skipField(name)) {
                return true;
            }
            if (!this.writeFieldHeader(name, (byte)25)) {
                return false;
            }
            DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
            stream.writeAffinityTopologyVersion(val);
            return stream.lastFinished();
        }
        return this.writeMessage(name, (Message)val);
    }

    public boolean writeMessage(String name, Message val) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeFieldHeader(name, (byte)21)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeMessage(val, (MessageWriter)this);
        return stream.lastFinished();
    }

    public <T> boolean writeObjectArray(String name, T[] arr, MessageCollectionItemType itemType) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeCollectionFieldHeader(name, true, itemType)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeObjectArray((Object[])arr, itemType, (MessageWriter)this);
        return stream.lastFinished();
    }

    public <T> boolean writeCollection(String name, Collection<T> col, MessageCollectionItemType itemType) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeCollectionFieldHeader(name, false, itemType)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeCollection(col, itemType, (MessageWriter)this);
        return stream.lastFinished();
    }

    public <K, V> boolean writeMap(String name, Map<K, V> map, MessageCollectionItemType keyType, MessageCollectionItemType valType) {
        if (this.skipField(name)) {
            return true;
        }
        if (!this.writeMapFieldHeader(name, keyType, valType)) {
            return false;
        }
        DirectByteBufferStream stream = ((StateItem)this.state.item()).stream;
        stream.writeMap(map, keyType, valType, (MessageWriter)this);
        return stream.lastFinished();
    }

    public boolean isHeaderWritten() {
        return ((StateItem)this.state.item()).hdrWritten;
    }

    public void onHeaderWritten() {
        ((StateItem)this.state.item()).hdrWritten = true;
    }

    public int state() {
        return ((StateItem)this.state.item()).state;
    }

    public void incrementState() {
        StateItem item = (StateItem)this.state.item();
        item.state++;
        item.fieldNameWritten = false;
        item.fieldTypeWritten = false;
        item.colItemTypeWritten = false;
        item.mapKeyTypeWritten = false;
        item.mapValTypeWritten = false;
    }

    public void beforeInnerMessageWrite() {
        this.state.forward();
    }

    public void afterInnerMessageWrite(boolean finished) {
        this.state.backward(finished);
    }

    public void reset() {
        this.state.reset();
    }

    private boolean writeFieldHeader(String name, byte type) {
        StateItem item = (StateItem)this.state.item();
        DirectByteBufferStream stream = item.stream;
        if (!item.fieldNameWritten) {
            stream.writeString(name);
            if (!stream.lastFinished()) {
                return false;
            }
            item.fieldNameWritten = true;
        }
        if (!item.fieldTypeWritten) {
            stream.writeByte(type);
            if (!stream.lastFinished()) {
                return false;
            }
            item.fieldTypeWritten = true;
        }
        return true;
    }

    private boolean writeCollectionFieldHeader(String name, boolean isArr, MessageCollectionItemType itemType) {
        if (!this.writeFieldHeader(name, isArr ? (byte)22 : 23)) {
            return false;
        }
        StateItem item = (StateItem)this.state.item();
        DirectByteBufferStream stream = item.stream;
        if (!item.colItemTypeWritten) {
            stream.writeByte((byte)itemType.ordinal());
            if (!stream.lastFinished()) {
                return false;
            }
            item.colItemTypeWritten = true;
        }
        return true;
    }

    private boolean writeMapFieldHeader(String name, MessageCollectionItemType keyType, MessageCollectionItemType valType) {
        if (!this.writeFieldHeader(name, (byte)24)) {
            return false;
        }
        StateItem item = (StateItem)this.state.item();
        DirectByteBufferStream stream = item.stream;
        if (!item.mapKeyTypeWritten) {
            stream.writeByte((byte)keyType.ordinal());
            if (!stream.lastFinished()) {
                return false;
            }
            item.mapKeyTypeWritten = true;
        }
        if (!item.mapValTypeWritten) {
            stream.writeByte((byte)valType.ordinal());
            if (!stream.lastFinished()) {
                return false;
            }
            item.mapValTypeWritten = true;
        }
        return true;
    }

    private boolean skipField(String name) {
        return this.msgFieldFilter != null && this.msgFieldFilter.apply((Object)((StateItem)this.state.item()).writeMsgCls, (Object)name);
    }

    public String toString() {
        return S.toString(RollingUpgradeMessageWriter.class, (Object)this);
    }

    private static class StateItem
    implements DirectMessageStateItem {
        private final DirectByteBufferStream stream;
        private int state;
        private boolean hdrWritten;
        private boolean fieldNameWritten;
        private boolean fieldTypeWritten;
        private boolean colItemTypeWritten;
        private boolean mapKeyTypeWritten;
        private boolean mapValTypeWritten;
        private Class<? extends Message> writeMsgCls;

        public StateItem(byte protoVer) {
            switch (protoVer) {
                case 1: {
                    this.stream = new DirectByteBufferStreamImplV1(null);
                    break;
                }
                case 2: {
                    this.stream = new DirectByteBufferStreamImplV2(null);
                    break;
                }
                case 3: {
                    this.stream = new DirectByteBufferStreamImplV3(null);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid protocol version: " + protoVer);
                }
            }
        }

        public void reset() {
            this.state = 0;
            this.hdrWritten = false;
            this.fieldNameWritten = false;
            this.fieldTypeWritten = false;
            this.colItemTypeWritten = false;
            this.mapKeyTypeWritten = false;
            this.mapValTypeWritten = false;
            this.writeMsgCls = null;
        }

        public String toString() {
            return S.toString(StateItem.class, (Object)this);
        }
    }
}

