/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.dr;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrReceiverLoadBalancingMode;
import org.gridgain.grid.dr.store.DrSenderStore;

public class DrSenderConnectionConfiguration {
    public static final DrReceiverLoadBalancingMode DFLT_LOAD_BALANCING_MODE = DrReceiverLoadBalancingMode.DR_RANDOM;
    public static final boolean DFLT_AWAIT_ACK = true;
    private byte dataCenterId;
    private String[] rcvAddrs;
    private String locOutboundHost;
    private String locOutboundAddr;
    private DrReceiverLoadBalancingMode loadBalancingMode = DFLT_LOAD_BALANCING_MODE;
    private byte[] ignoreDataCenterIds;
    private boolean awaitAck = true;
    private DrSenderStore store;

    public DrSenderConnectionConfiguration() {
    }

    public DrSenderConnectionConfiguration(DrSenderConnectionConfiguration cfg) {
        this.rcvAddrs = cfg.getReceiverAddresses();
        this.dataCenterId = cfg.getDataCenterId();
        this.ignoreDataCenterIds = cfg.getIgnoredDataCenterIds();
        this.loadBalancingMode = cfg.getLoadBalancingMode();
        this.locOutboundAddr = cfg.getLocalOutboundAddress();
        this.locOutboundHost = cfg.getLocalOutboundHost();
        this.awaitAck = cfg.isAwaitAcknowledge();
        this.store = cfg.getStore();
    }

    public byte getDataCenterId() {
        return this.dataCenterId;
    }

    public DrSenderConnectionConfiguration setDataCenterId(byte dataCenterId) {
        this.dataCenterId = dataCenterId;
        return this;
    }

    public String[] getReceiverAddresses() {
        return this.rcvAddrs;
    }

    public DrSenderConnectionConfiguration setReceiverAddresses(String ... rcvAddrs) {
        this.rcvAddrs = rcvAddrs;
        return this;
    }

    @Deprecated
    public String getLocalOutboundHost() {
        return this.locOutboundHost;
    }

    @Deprecated
    public DrSenderConnectionConfiguration setLocalOutboundHost(String locOutboundHost) {
        this.locOutboundHost = locOutboundHost;
        return this;
    }

    public String getLocalOutboundAddress() {
        return this.locOutboundAddr;
    }

    public DrSenderConnectionConfiguration setLocalOutboundAddress(String locOutboundAddr) {
        this.locOutboundAddr = locOutboundAddr;
        return this;
    }

    public DrReceiverLoadBalancingMode getLoadBalancingMode() {
        return this.loadBalancingMode;
    }

    public DrSenderConnectionConfiguration setLoadBalancingMode(DrReceiverLoadBalancingMode loadBalancingMode) {
        this.loadBalancingMode = loadBalancingMode;
        return this;
    }

    public byte[] getIgnoredDataCenterIds() {
        return this.ignoreDataCenterIds;
    }

    public DrSenderConnectionConfiguration setIgnoredDataCenterIds(byte ... ignoreDataCenterIds) {
        this.ignoreDataCenterIds = ignoreDataCenterIds;
        return this;
    }

    public boolean isAwaitAcknowledge() {
        return this.awaitAck;
    }

    public DrSenderConnectionConfiguration setAwaitAcknowledge(boolean awaitAck) {
        this.awaitAck = awaitAck;
        return this;
    }

    public DrSenderStore getStore() {
        return this.store;
    }

    public DrSenderConnectionConfiguration setStore(DrSenderStore store) {
        this.store = store;
        return this;
    }

    public String toString() {
        return S.toString(DrSenderConnectionConfiguration.class, (Object)this);
    }
}

