/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.segmentation.reachability;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.segmentation.SegmentationResolver;

public class ReachabilitySegmentationResolver
implements SegmentationResolver {
    private static final long serialVersionUID = -6705219309370534259L;
    public static final int DFLT_TTL = 0;
    public static final int DFLT_TIMEOUT = 1000;
    private InetAddress addr;
    private InetAddress itfAddr;
    private NetworkInterface itf;
    private int timeout = 1000;
    private int ttl = 0;
    private boolean init;
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final CountDownLatch initLatch = new CountDownLatch(1);

    public boolean isValidSegment() throws IgniteCheckedException {
        this.init();
        try {
            return this.addr.isReachable(this.itf, this.ttl, this.timeout);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to check address reachability: " + this.addr, (Throwable)e);
        }
    }

    private void init() throws IgniteCheckedException {
        if (this.initGuard.compareAndSet(false, true)) {
            try {
                if (this.addr == null) {
                    throw new IgniteCheckedException("Property 'address' cannot be null: " + this);
                }
                if (this.itf == null && this.itfAddr != null) {
                    this.itf = NetworkInterface.getByInetAddress(this.itfAddr);
                }
                if (this.ttl < 0) {
                    throw new IgniteCheckedException("Property 'TTL' cannot be negative: " + this);
                }
                if (this.timeout < 0) {
                    throw new IgniteCheckedException("Property 'timeout' cannot be negative: " + this);
                }
                this.init = true;
            }
            catch (SocketException e) {
                throw new IgniteCheckedException("Failed to get network interface: " + this, (Throwable)e);
            }
            finally {
                this.initLatch.countDown();
            }
        } else {
            U.await((CountDownLatch)this.initLatch);
            if (!this.init) {
                throw new IgniteCheckedException("Segmentation resolver was not properly initialized.");
            }
        }
    }

    public ReachabilitySegmentationResolver setAddress(InetAddress addr) {
        this.addr = addr;
        return this;
    }

    public ReachabilitySegmentationResolver setAddressAsString(String addr) throws IgniteCheckedException {
        A.notNull((Object)addr, (String)"addr");
        try {
            this.addr = InetAddress.getByName(addr);
        }
        catch (UnknownHostException e) {
            throw new IgniteCheckedException("Failed to get address by name: " + addr, (Throwable)e);
        }
        return this;
    }

    public ReachabilitySegmentationResolver setNetworkInterfaceAddress(InetAddress itfAddr) {
        this.itfAddr = itfAddr;
        return this;
    }

    public ReachabilitySegmentationResolver setNetworkInterfaceAddressAsString(String itfAddr) throws IgniteCheckedException {
        A.notNull((Object)itfAddr, (String)"itfAddr");
        try {
            this.itfAddr = InetAddress.getByName(itfAddr);
        }
        catch (UnknownHostException e) {
            throw new IgniteCheckedException("Failed to get address by name: " + this.addr, (Throwable)e);
        }
        return this;
    }

    public ReachabilitySegmentationResolver setNetworkInterface(NetworkInterface itf) {
        this.itf = itf;
        return this;
    }

    public ReachabilitySegmentationResolver setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public ReachabilitySegmentationResolver setTtl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    public String toString() {
        return S.toString(ReachabilitySegmentationResolver.class, (Object)this);
    }
}

