/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.license;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.GridProduct;
import org.gridgain.grid.internal.visor.license.VisorLicenseFeature;
import org.gridgain.grid.product.ProductLicense;
import org.jetbrains.annotations.Nullable;

public class VisorLicense
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private UUID id;
    private String ver;
    private String verRegexp;
    private String issueOrganization;
    private String userName;
    private String userOrganization;
    private String userWww;
    private String userEmail;
    private String note;
    private Date expireDate;
    private Date issueDate;
    private int maintenanceTime;
    private int maxNodes;
    private int maxComputers;
    private int maxCpus;
    private long maxUpTime;
    private long gracePeriod;
    private String attributeName;
    private String attributeVal;
    private long gracePeriodLeft;
    private List<VisorLicenseFeature> enabledFeatures;

    private static Date safeDate(Date date) {
        return date != null ? (Date)date.clone() : null;
    }

    public VisorLicense() {
    }

    public VisorLicense(GridProduct product) {
        assert (product != null);
        assert (product.license() != null);
        ProductLicense lic = product.license();
        this.id = lic.id();
        this.ver = lic.version();
        this.verRegexp = lic.versionRegexp();
        this.issueOrganization = lic.issueOrganization();
        this.userName = lic.userName();
        this.userOrganization = lic.userOrganization();
        this.userWww = lic.userWww();
        this.userEmail = lic.userEmail();
        this.note = lic.licenseNote();
        this.expireDate = VisorLicense.safeDate(lic.expireDate());
        this.issueDate = VisorLicense.safeDate(lic.issueDate());
        this.maintenanceTime = lic.maintenanceTime();
        this.maxNodes = lic.maxNodes();
        this.maxComputers = lic.maxComputers();
        this.maxCpus = lic.maxCpus();
        this.maxUpTime = lic.maxUpTime();
        this.gracePeriod = lic.gracePeriod();
        this.attributeName = lic.attributeName();
        this.attributeVal = lic.attributeValue();
        this.gracePeriodLeft = product.gracePeriodLeft();
        this.enabledFeatures = VisorLicenseFeature.from(lic.getEnabledFeatures());
    }

    public UUID getId() {
        return this.id;
    }

    public String getVersion() {
        return this.ver;
    }

    public String getVersionRegexp() {
        return this.verRegexp;
    }

    public String getIssueOrganization() {
        return this.issueOrganization;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserOrganization() {
        return this.userOrganization;
    }

    public String getUserWww() {
        return this.userWww;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getNote() {
        return this.note;
    }

    @Nullable
    public Date getExpireDate() {
        return VisorLicense.safeDate(this.expireDate);
    }

    public Date getIssueDate() {
        return VisorLicense.safeDate(this.issueDate);
    }

    public int getMaintenanceTime() {
        return this.maintenanceTime;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public int getMaxComputers() {
        return this.maxComputers;
    }

    public int getMaxCpus() {
        return this.maxCpus;
    }

    public long getMaxUpTime() {
        return this.maxUpTime;
    }

    public long getGracePeriod() {
        return this.gracePeriod;
    }

    @Nullable
    public String getAttributeName() {
        return this.attributeName;
    }

    @Nullable
    public String getAttributeValue() {
        return this.attributeVal;
    }

    public long getGracePeriodLeft() {
        return this.gracePeriodLeft;
    }

    public List<VisorLicenseFeature> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeUuid((DataOutput)out, (UUID)this.id);
        U.writeCutString((DataOutput)out, (String)this.ver);
        U.writeCutString((DataOutput)out, (String)this.verRegexp);
        U.writeCutString((DataOutput)out, (String)this.issueOrganization);
        U.writeCutString((DataOutput)out, (String)this.userName);
        U.writeCutString((DataOutput)out, (String)this.userOrganization);
        U.writeCutString((DataOutput)out, (String)this.userWww);
        U.writeCutString((DataOutput)out, (String)this.userEmail);
        U.writeCutString((DataOutput)out, (String)this.note);
        out.writeObject(this.expireDate);
        out.writeObject(this.issueDate);
        out.writeInt(this.maintenanceTime);
        out.writeInt(this.maxNodes);
        out.writeInt(this.maxComputers);
        out.writeInt(this.maxCpus);
        out.writeLong(this.maxUpTime);
        out.writeLong(this.gracePeriod);
        U.writeCutString((DataOutput)out, (String)this.attributeName);
        U.writeCutString((DataOutput)out, (String)this.attributeVal);
        out.writeLong(this.gracePeriodLeft);
        U.writeCollection((ObjectOutput)out, this.enabledFeatures);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readUuid((DataInput)in);
        this.ver = U.readString((DataInput)in);
        this.verRegexp = U.readString((DataInput)in);
        this.issueOrganization = U.readString((DataInput)in);
        this.userName = U.readString((DataInput)in);
        this.userOrganization = U.readString((DataInput)in);
        this.userWww = U.readString((DataInput)in);
        this.userEmail = U.readString((DataInput)in);
        this.note = U.readString((DataInput)in);
        this.expireDate = (Date)in.readObject();
        this.issueDate = (Date)in.readObject();
        this.maintenanceTime = in.readInt();
        this.maxNodes = in.readInt();
        this.maxComputers = in.readInt();
        this.maxCpus = in.readInt();
        this.maxUpTime = in.readLong();
        this.gracePeriod = in.readLong();
        this.attributeName = U.readString((DataInput)in);
        this.attributeVal = U.readString((DataInput)in);
        this.gracePeriodLeft = in.readLong();
        this.enabledFeatures = U.readList((ObjectInput)in);
    }

    public String toString() {
        return S.toString(VisorLicense.class, (Object)((Object)this));
    }
}

