/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.dr.VisorDrCacheTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrCacheTaskResult;
import org.apache.ignite.lang.IgniteFuture;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.cache.dr.CacheDrSenderMetrics;
import org.gridgain.grid.cache.dr.CacheDrStatus;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.dr.DrSender;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.visor.dr.VisorDrReceiverCacheMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrReceiverHubInMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrReceiverHubOutMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrSenderCacheMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrSenderHubInMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrSenderHubOutMetrics;
import org.gridgain.grid.internal.visor.dr.console.VisorDrCacheLocalTaskResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorDrCacheTask
extends VisorMultiNodeTask<VisorDrCacheTaskArgs, VisorDrCacheTaskResult, VisorDrCacheLocalTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorJob<VisorDrCacheTaskArgs, VisorDrCacheLocalTaskResult> job(VisorDrCacheTaskArgs arg) {
        return new VisorDrCacheJob(arg, this.debug);
    }

    private void addInt(Map<String, AtomicInteger> map, String key, int val) {
        map.computeIfAbsent(key, k -> new AtomicInteger()).addAndGet(val);
    }

    private void addLong(Map<String, AtomicLong> map, String key, long val) {
        map.computeIfAbsent(key, k -> new AtomicLong()).addAndGet(val);
    }

    @Nullable
    protected VisorDrCacheTaskResult reduce0(List<ComputeJobResult> results) throws IgniteException {
        VisorDrCacheTaskResult res = new VisorDrCacheTaskResult();
        TreeSet<String> cacheNames = new TreeSet<String>();
        HashMap<String, List<T2<String, Object>>> sndCfg = new HashMap<String, List<T2<String, Object>>>();
        HashMap<String, List<T2<String, Object>>> rcvCfg = new HashMap<String, List<T2<String, Object>>>();
        HashMap sndMetrics = new HashMap();
        HashMap rcvMetrics = new HashMap();
        HashMap<String, AtomicInteger> sndBatchesSent = new HashMap<String, AtomicInteger>();
        HashMap<String, AtomicInteger> sndBatchesRcv = new HashMap<String, AtomicInteger>();
        HashMap<String, AtomicInteger> sndBatchesAcked = new HashMap<String, AtomicInteger>();
        HashMap<String, AtomicInteger> sndBatchesFailed = new HashMap<String, AtomicInteger>();
        HashMap<String, AtomicLong> sndBytesSent = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> sndBytesRcv = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> sndBytesAcked = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> sndEntriesSent = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> sndEntriesRcv = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> sndEntriesAcked = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> sndEntriesFiltered = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicInteger> rcvBatchesSent = new HashMap<String, AtomicInteger>();
        HashMap<String, AtomicInteger> rcvBatchesRcv = new HashMap<String, AtomicInteger>();
        HashMap<String, AtomicInteger> rcvBatchesAcked = new HashMap<String, AtomicInteger>();
        HashMap<String, AtomicLong> rcvBytesSent = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> rcvBytesRcv = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> rcvBytesAcked = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> rcvEntriesSent = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> rcvEntriesRcv = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> rcvEntriesAcked = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> rcvConflictMerge = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> rcvConflictNew = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> rcvConflictOld = new HashMap<String, AtomicLong>();
        LinkedHashMap<String, List> msgs = new LinkedHashMap<String, List>();
        for (ComputeJobResult computeJobResult : results) {
            VisorDrCacheLocalTaskResult data = (VisorDrCacheLocalTaskResult)((Object)computeJobResult.getData());
            if (data == null) continue;
            Map<String, T3<VisorDrSenderCacheMetrics, VisorDrSenderHubInMetrics, VisorDrSenderHubOutMetrics>> cacheSndMetrics = data.getSenderMetrics();
            Map<String, T3<VisorDrReceiverCacheMetrics, VisorDrReceiverHubInMetrics, VisorDrReceiverHubOutMetrics>> cacheRcvMetrics = data.getReceiverMetrics();
            res.setDataCenterId(data.getDataCenterId());
            cacheNames.addAll(data.getCacheNames());
            if (data.getSenderConfig() != null) {
                sndCfg.putAll(data.getSenderConfig());
            }
            if (data.getReceiverConfig() != null) {
                rcvCfg.putAll(data.getReceiverConfig());
            }
            for (String cacheName : data.getCacheNames()) {
                Object t3;
                if (cacheSndMetrics != null && (t3 = cacheSndMetrics.get(cacheName)) != null) {
                    VisorDrSenderCacheMetrics sndCacheMetrics = (VisorDrSenderCacheMetrics)((Object)t3.get1());
                    VisorDrSenderHubInMetrics sndInMetrics = (VisorDrSenderHubInMetrics)((Object)t3.get2());
                    VisorDrSenderHubOutMetrics sndOutMetrics = (VisorDrSenderHubOutMetrics)((Object)t3.get3());
                    this.addInt(sndBatchesSent, cacheName, sndCacheMetrics.getBatchesSent());
                    this.addInt(sndBatchesRcv, cacheName, sndInMetrics.getBatchesReceived());
                    this.addInt(sndBatchesAcked, cacheName, sndCacheMetrics.getBatchesAcked());
                    this.addInt(sndBatchesFailed, cacheName, sndCacheMetrics.getBatchesFailed());
                    this.addLong(sndBytesSent, cacheName, sndOutMetrics.getBytesSent());
                    this.addLong(sndBytesRcv, cacheName, sndInMetrics.getBytesReceived());
                    this.addLong(sndBytesAcked, cacheName, sndOutMetrics.getBytesAcked());
                    this.addLong(sndEntriesSent, cacheName, sndCacheMetrics.getEntriesSent());
                    this.addLong(sndEntriesRcv, cacheName, sndInMetrics.getEntriesReceived());
                    this.addLong(sndEntriesAcked, cacheName, sndCacheMetrics.getEntriesAcked());
                    this.addLong(sndEntriesFiltered, cacheName, sndCacheMetrics.getEntriesFiltered());
                }
                if (cacheRcvMetrics == null || (t3 = cacheRcvMetrics.get(cacheName)) == null) continue;
                VisorDrReceiverCacheMetrics rcvCacheMetrics = (VisorDrReceiverCacheMetrics)((Object)t3.get1());
                VisorDrReceiverHubInMetrics rcvInMetrics = (VisorDrReceiverHubInMetrics)((Object)t3.get2());
                VisorDrReceiverHubOutMetrics rcvOutMetrics = (VisorDrReceiverHubOutMetrics)((Object)t3.get3());
                this.addInt(rcvBatchesSent, cacheName, rcvOutMetrics.getBatchesSent());
                this.addInt(rcvBatchesRcv, cacheName, rcvInMetrics.getBatchesReceived());
                this.addInt(rcvBatchesAcked, cacheName, rcvOutMetrics.getBatchesAcked());
                this.addLong(rcvBytesSent, cacheName, rcvOutMetrics.getBytesSent());
                this.addLong(rcvBytesRcv, cacheName, rcvInMetrics.getBytesReceived());
                this.addLong(rcvBytesAcked, cacheName, rcvOutMetrics.getBytesAcked());
                this.addLong(rcvEntriesSent, cacheName, rcvOutMetrics.getEntriesSent());
                this.addLong(rcvEntriesRcv, cacheName, rcvInMetrics.getEntriesReceived());
                this.addLong(rcvEntriesAcked, cacheName, rcvOutMetrics.getEntriesAcked());
                this.addLong(rcvConflictMerge, cacheName, rcvCacheMetrics.getConflictMerge());
                this.addLong(rcvConflictNew, cacheName, rcvCacheMetrics.getConflictNew());
                this.addLong(rcvConflictOld, cacheName, rcvCacheMetrics.getConflictOld());
            }
            for (String msg : data.getResultMessages()) {
                msgs.computeIfAbsent(msg, k -> new ArrayList()).add(computeJobResult.getNode().id());
            }
        }
        for (Map.Entry entry : msgs.entrySet()) {
            res.addResultMessage("Problem occurred on nodes " + entry.getValue());
            res.addResultMessage("  " + (String)entry.getKey());
        }
        for (String string : cacheNames) {
            if (sndBatchesSent.get(string) != null) {
                ArrayList<T2> cacheSndMetrics = new ArrayList<T2>();
                cacheSndMetrics.add(IgniteUtils.tuple((Object)"BatchesSent", sndBatchesSent.get(string)));
                cacheSndMetrics.add(IgniteUtils.tuple((Object)"BatchesReceived", sndBatchesRcv.get(string)));
                cacheSndMetrics.add(IgniteUtils.tuple((Object)"BatchesAcked", sndBatchesAcked.get(string)));
                cacheSndMetrics.add(IgniteUtils.tuple((Object)"BatchesFailed", sndBatchesFailed.get(string)));
                cacheSndMetrics.add(IgniteUtils.tuple((Object)"BytesSent", sndBytesSent.get(string)));
                cacheSndMetrics.add(IgniteUtils.tuple((Object)"BytesReceived", sndBytesRcv.get(string)));
                cacheSndMetrics.add(IgniteUtils.tuple((Object)"BytesAcked", sndBytesAcked.get(string)));
                cacheSndMetrics.add(IgniteUtils.tuple((Object)"EntriesSent", sndEntriesSent.get(string)));
                cacheSndMetrics.add(IgniteUtils.tuple((Object)"EntriesReceived", sndEntriesRcv.get(string)));
                cacheSndMetrics.add(IgniteUtils.tuple((Object)"EntriesAcked", sndEntriesAcked.get(string)));
                cacheSndMetrics.add(IgniteUtils.tuple((Object)"EntriesFiltered", sndEntriesFiltered.get(string)));
                sndMetrics.put(string, cacheSndMetrics);
            }
            if (rcvBatchesSent.get(string) == null) continue;
            ArrayList<T2> cacheRcvMetrics = new ArrayList<T2>();
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"BatchesSent", rcvBatchesSent.get(string)));
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"BatchesReceived", rcvBatchesRcv.get(string)));
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"BatchesAcked", rcvBatchesAcked.get(string)));
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"BytesSent", rcvBytesSent.get(string)));
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"BytesReceived", rcvBytesRcv.get(string)));
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"BytesAcked", rcvBytesAcked.get(string)));
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"EntriesSent", rcvEntriesSent.get(string)));
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"EntriesReceived", rcvEntriesRcv.get(string)));
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"EntriesAcked", rcvEntriesAcked.get(string)));
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"ConflictMerge", rcvConflictMerge.get(string)));
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"ConflictNew", rcvConflictNew.get(string)));
            cacheRcvMetrics.add(IgniteUtils.tuple((Object)"ConflictOld", rcvConflictOld.get(string)));
            rcvMetrics.put(string, cacheRcvMetrics);
        }
        res.setCacheNames(new ArrayList(cacheNames));
        res.setSenderConfig(sndCfg);
        res.setReceiverConfig(rcvCfg);
        res.setSenderMetrics(sndMetrics);
        res.setReceiverMetrics(rcvMetrics);
        return res;
    }

    private static class VisorDrCacheJob
    extends VisorJob<VisorDrCacheTaskArgs, VisorDrCacheLocalTaskResult> {
        private static final long serialVersionUID = 0L;

        public VisorDrCacheJob(VisorDrCacheTaskArgs arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorDrCacheLocalTaskResult run(@Nullable VisorDrCacheTaskArgs arg) throws IgniteException {
            Objects.requireNonNull(arg, "arg");
            VisorDrCacheLocalTaskResult res = new VisorDrCacheLocalTaskResult();
            GridGain plugin = (GridGain)this.ignite.plugin("GridGain");
            GridGainConfiguration pluginCfg = plugin.configuration();
            res.setDataCenterId(pluginCfg.getDataCenterId());
            GridDr dr = plugin.dr();
            Pattern cachePattern = this.compileCachePattern(arg);
            ArrayList<String> cacheNames = new ArrayList<String>();
            byte remoteDataCenterId = arg.getRemoteDataCenterId();
            UUID localNodeId = this.ignite.localNode().id();
            boolean localNodeIsActionCoordinator = localNodeId.equals(arg.getActionCoordinator());
            LinkedHashMap transferFuts = new LinkedHashMap();
            block31: for (String string : this.ignite.cacheNames()) {
                GridGainCacheConfiguration ggCcfg;
                IgniteInternalCache cachex;
                if (!cachePattern.matcher(string).matches() || (cachex = this.ignite.cachex(string)) == null || CU.isSystemCache((String)cachex.name()) || (ggCcfg = this.ggCacheCfg(cachex)) == null) continue;
                String sndGrp = pluginCfg.isDrUseCacheNames() || ggCcfg.getDrSenderConfiguration() == null ? null : DrUtils.effectiveSenderGroup(ggCcfg.getDrSenderConfiguration());
                switch (arg.getSenderGroup()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (!pluginCfg.isDrUseCacheNames() && "<default>".equals(sndGrp)) break;
                        continue block31;
                    }
                    case 2: {
                        if (pluginCfg.isDrUseCacheNames()) break;
                        continue block31;
                    }
                    case 3: {
                        if (!pluginCfg.isDrUseCacheNames() && arg.getSenderGroupName().equals(sndGrp)) break;
                        continue block31;
                    }
                }
                int cacheFilter = arg.getFilter();
                switch (cacheFilter) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        try {
                            CacheDrSenderMetrics sndMetrics = dr.senderCacheMetrics(string);
                            if (sndMetrics == null) continue block31;
                            CacheDrStatus status = sndMetrics.status();
                            if ((cacheFilter != 4 || status != null && status.error() != null) && (cacheFilter != 3 || status != null && status.stopped())) break;
                            continue block31;
                        }
                        catch (IllegalStateException sndMetrics) {
                            break;
                        }
                    }
                    case 2: {
                        try {
                            dr.receiverCacheMetrics(string);
                            break;
                        }
                        catch (IllegalStateException notReceiverCacheException) {
                            continue block31;
                        }
                    }
                }
                switch (arg.getAction()) {
                    case 0: {
                        if (remoteDataCenterId != 0 || !localNodeId.equals(arg.getCacheNamesMap().get(string))) break;
                        this.stopReplication(res, dr, string);
                        break;
                    }
                    case 1: {
                        if (remoteDataCenterId != 0 || !localNodeId.equals(arg.getCacheNamesMap().get(string))) break;
                        this.startReplication(res, dr, string);
                        break;
                    }
                    case 2: {
                        if (!localNodeId.equals(arg.getCacheNamesMap().get(string))) break;
                        transferFuts.put(string, this.stateTransfer(dr, string, arg.isFstSyncMode()));
                    }
                }
                cacheNames.add(string);
            }
            switch (arg.getAction()) {
                case 0: {
                    if (remoteDataCenterId == 0 || !localNodeIsActionCoordinator) break;
                    this.stopReplication(res, dr, remoteDataCenterId);
                    break;
                }
                case 1: {
                    if (remoteDataCenterId == 0 || !localNodeIsActionCoordinator) break;
                    this.startReplication(res, dr, remoteDataCenterId);
                    break;
                }
                case 2: {
                    for (Map.Entry entry : transferFuts.entrySet()) {
                        try {
                            ((IgniteFuture)entry.getValue()).get();
                        }
                        catch (Exception e) {
                            res.addResultMessage(String.format("Failed to execute full state transfer for cache \"%s\": %s", entry.getKey(), e.getMessage()));
                        }
                    }
                    break;
                }
            }
            res.setCacheNames(cacheNames);
            HashMap<String, List<T2<String, Object>>> sndHubCfgs = new HashMap<String, List<T2<String, Object>>>();
            HashMap<String, List<T2<String, Object>>> hashMap = new HashMap<String, List<T2<String, Object>>>();
            res.setSenderConfig(sndHubCfgs);
            res.setReceiverConfig(hashMap);
            HashMap<String, T3<VisorDrSenderCacheMetrics, VisorDrSenderHubInMetrics, VisorDrSenderHubOutMetrics>> sndMetrics = new HashMap<String, T3<VisorDrSenderCacheMetrics, VisorDrSenderHubInMetrics, VisorDrSenderHubOutMetrics>>();
            HashMap<String, T3<VisorDrReceiverCacheMetrics, VisorDrReceiverHubInMetrics, VisorDrReceiverHubOutMetrics>> rcvMetrics = new HashMap<String, T3<VisorDrReceiverCacheMetrics, VisorDrReceiverHubInMetrics, VisorDrReceiverHubOutMetrics>>();
            res.setSenderMetrics(sndMetrics);
            res.setReceiverMetrics(rcvMetrics);
            for (String cacheName : cacheNames) {
                IgniteInternalCache cachex = this.ignite.cachex(cacheName);
                GridGainCacheConfiguration ggCcfg = this.ggCacheCfg(cachex);
                assert (ggCcfg != null);
                if (arg.isConfig()) {
                    sndHubCfgs.put(cacheName, this.collectCacheSenderConfig(ggCcfg));
                    hashMap.put(cacheName, this.collectCacheReceiverConfig(ggCcfg));
                }
                if (!arg.isMetrics()) continue;
                try {
                    sndMetrics.put(cacheName, (T3<VisorDrSenderCacheMetrics, VisorDrSenderHubInMetrics, VisorDrSenderHubOutMetrics>)IgniteUtils.tuple((Object)((Object)new VisorDrSenderCacheMetrics(dr, cacheName)), (Object)((Object)new VisorDrSenderHubInMetrics(dr.senderInMetrics(cacheName))), (Object)((Object)new VisorDrSenderHubOutMetrics(dr.senderAggregatedOutMetrics(cacheName)))));
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    rcvMetrics.put(cacheName, (T3<VisorDrReceiverCacheMetrics, VisorDrReceiverHubInMetrics, VisorDrReceiverHubOutMetrics>)IgniteUtils.tuple((Object)((Object)new VisorDrReceiverCacheMetrics(dr, cacheName)), (Object)((Object)new VisorDrReceiverHubInMetrics(dr.receiverAggregatedInMetrics(cacheName))), (Object)((Object)new VisorDrReceiverHubOutMetrics(dr.receiverOutMetrics(cacheName)))));
                }
                catch (IllegalStateException illegalStateException) {}
            }
            return res;
        }

        private Pattern compileCachePattern(@NotNull VisorDrCacheTaskArgs arg) {
            try {
                return Pattern.compile(arg.getRegex());
            }
            catch (PatternSyntaxException e) {
                return Pattern.compile("");
            }
        }

        private GridGainCacheConfiguration ggCacheCfg(IgniteInternalCache<?, ?> cachex) {
            return (GridGainCacheConfiguration)GridCacheUtils.cachePluginConfiguration((CacheConfiguration)cachex.configuration(), GridGainCacheConfiguration.class);
        }

        private List<T2<String, Object>> collectCacheSenderConfig(GridGainCacheConfiguration ggCcfg) {
            ArrayList<T2<String, Object>> cacheSndCfg = new ArrayList<T2<String, Object>>();
            CacheDrSenderConfiguration drSndCfg = ggCcfg.getDrSenderConfiguration();
            if (drSndCfg != null) {
                cacheSndCfg.add((T2<String, Object>)IgniteUtils.tuple((Object)"PreferLocalSender", (Object)drSndCfg.isPreferLocalSender()));
                cacheSndCfg.add((T2<String, Object>)IgniteUtils.tuple((Object)"BatchSendSize", (Object)drSndCfg.getBatchSendSize()));
                cacheSndCfg.add((T2<String, Object>)IgniteUtils.tuple((Object)"BatchSendFrequency", (Object)drSndCfg.getBatchSendFrequency()));
                cacheSndCfg.add((T2<String, Object>)IgniteUtils.tuple((Object)"EntryFilter", (Object)drSndCfg.getEntryFilter()));
                cacheSndCfg.add((T2<String, Object>)IgniteUtils.tuple((Object)"LoadBalancingMode", (Object)((Object)drSndCfg.getLoadBalancingMode())));
                cacheSndCfg.add((T2<String, Object>)IgniteUtils.tuple((Object)"StateTransferThreadsCount", (Object)drSndCfg.getStateTransferThreadsCount()));
                cacheSndCfg.add((T2<String, Object>)IgniteUtils.tuple((Object)"MaxBatches", (Object)drSndCfg.getMaxBatches()));
                cacheSndCfg.add((T2<String, Object>)IgniteUtils.tuple((Object)"SenderGroup", (Object)drSndCfg.getSenderGroup()));
                cacheSndCfg.add((T2<String, Object>)IgniteUtils.tuple((Object)"StateTransferThrottleBytes", (Object)drSndCfg.getStateTransferThrottleBytes()));
                cacheSndCfg.add((T2<String, Object>)IgniteUtils.tuple((Object)"MaxBackupQueueSize", (Object)drSndCfg.getMaxBackupQueueSize()));
            }
            return cacheSndCfg;
        }

        private List<T2<String, Object>> collectCacheReceiverConfig(GridGainCacheConfiguration ggCcfg) {
            ArrayList<T2<String, Object>> cacheRcvCfg = new ArrayList<T2<String, Object>>();
            if (ggCcfg.isDrReceiverEnabled()) {
                cacheRcvCfg.add((T2<String, Object>)IgniteUtils.tuple((Object)"ReceiverEnabled", (Object)true));
            }
            return cacheRcvCfg;
        }

        private void startReplication(VisorDrCacheLocalTaskResult res, GridDr dr, String cacheName) {
            try {
                dr.startReplication(cacheName);
            }
            catch (Exception e) {
                res.addResultMessage(String.format("Failed to start replication for cache \"%s\": %s", cacheName, e.getMessage()));
            }
        }

        private void startReplication(VisorDrCacheLocalTaskResult res, GridDr dr, byte remoteDataCenterId) {
            if (dr.isLocalSender()) {
                DrSender locSnd = dr.localSender();
                if (locSnd.connections().stream().anyMatch(c -> c.dataCenterId() == remoteDataCenterId)) {
                    try {
                        locSnd.resume(remoteDataCenterId);
                    }
                    catch (Exception e) {
                        res.addResultMessage(String.format("Failed to start replication for data center %d: %s", remoteDataCenterId, e.getMessage()));
                    }
                } else {
                    res.addResultMessage(String.format("Data center replication for data center %d is not configured.", remoteDataCenterId));
                }
            } else {
                res.addResultMessage("Data center replication is not configured.");
            }
        }

        private void stopReplication(VisorDrCacheLocalTaskResult res, GridDr dr, String cacheName) {
            try {
                dr.stopReplication(cacheName);
            }
            catch (Exception e) {
                res.addResultMessage(String.format("Failed to stop replication for cache \"%s\": %s", cacheName, e.getMessage()));
            }
        }

        private void stopReplication(VisorDrCacheLocalTaskResult res, GridDr dr, byte remoteDataCenterId) {
            if (dr.isLocalSender()) {
                DrSender locSnd = dr.localSender();
                if (locSnd.connections().stream().anyMatch(c -> c.dataCenterId() == remoteDataCenterId)) {
                    try {
                        locSnd.pause(remoteDataCenterId);
                    }
                    catch (Exception e) {
                        res.addResultMessage(String.format("Failed to stop replication for data center %d: %s", remoteDataCenterId, e.getMessage()));
                    }
                } else {
                    res.addResultMessage(String.format("Data center replication for data center %d is not configured.", remoteDataCenterId));
                }
            }
        }

        private IgniteFuture<?> stateTransfer(GridDr dr, String cacheName, boolean syncMode) {
            try {
                return dr.stateTransfer(cacheName, syncMode, new byte[0]);
            }
            catch (Exception e) {
                return new IgniteFinishedFutureImpl((Throwable)e);
            }
        }
    }
}

