/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.util.dr;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

public class CheckDrCacheData
implements IgniteRunnable {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    IgniteEx ignite;
    private String groupName;
    private int part;

    public static List<IgniteFuture> runTask(Ignite ignite, String ... cacheNames) {
        List contexts;
        HashSet groups = new HashSet();
        if (cacheNames.length == 0) {
            Set allCacheNames = ((IgniteEx)ignite).context().cache().cacheDescriptors().keySet();
            allCacheNames.stream().forEach(arg_0 -> ((Ignite)ignite).cache(arg_0));
            contexts = allCacheNames.stream().map(name -> ((IgniteEx)ignite).context().cache().cache(name).context()).filter(cctx -> groups.add(cctx.groupId())).collect(Collectors.toList());
        } else {
            Arrays.stream(cacheNames).forEach(arg_0 -> ((Ignite)ignite).cache(arg_0));
            contexts = Arrays.stream(cacheNames).map(name -> ((IgniteEx)ignite).context().cache().cache(name).context()).filter(cctx -> groups.add(cctx.groupId())).collect(Collectors.toList());
        }
        ArrayList<IgniteFuture> futs = new ArrayList<IgniteFuture>();
        for (GridCacheContext cctx2 : contexts) {
            int parts = cctx2.affinity().partitions();
            AffinityAssignment assignment = cctx2.affinity().assignment(cctx2.affinity().affinityTopologyVersion());
            for (int p = 0; p < parts; ++p) {
                IgniteFuture fut = ignite.compute(ignite.cluster().forNodes((Collection)assignment.assignment().get(p))).broadcastAsync((IgniteRunnable)new CheckDrCacheData(cctx2.group().cacheOrGroupName(), p));
                futs.add(fut);
            }
        }
        return futs;
    }

    public CheckDrCacheData(String groupName, int part) {
        this.groupName = groupName;
        this.part = part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.ignite.cache(this.groupName);
        IgniteLogger log = this.ignite.log();
        CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(CU.cacheId((String)this.groupName));
        if (grpCtx == null) {
            grpCtx = this.ignite.cachex(this.groupName).context().group();
        }
        if (grpCtx == null) {
            log.warning("No group found for name: " + this.groupName);
            return;
        }
        GridDhtLocalPartition locPart = this.reservePartition(grpCtx);
        long startTime = System.currentTimeMillis();
        Metrics metrics = new Metrics(this.part, locPart.fullSize());
        try {
            GridIterator it = grpCtx.offheap().partitionIterator(this.part, 3);
            HashSet<Long> set = new HashSet<Long>();
            while (it.hasNext()) {
                grpCtx.shared().database().checkpointReadLock();
                try {
                    int cnt = 100;
                    while (it.hasNext() && cnt-- > 0) {
                        CacheDataRow next = (CacheDataRow)it.next();
                        metrics.entriesProcessed++;
                        if (set.add(next.version().updateCounter())) continue;
                        metrics.brokenEntriesFound++;
                        metrics.affectedCaches.add(next.cacheId());
                    }
                }
                finally {
                    grpCtx.shared().database().checkpointReadUnlock();
                }
            }
        }
        catch (IgniteCheckedException e) {
            log.warning("Task failed: cacheGroup=" + this.groupName + ", part=" + this.part, (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
        finally {
            locPart.release();
            metrics.duration = System.currentTimeMillis() - startTime;
        }
        if (metrics.brokenEntriesFound > 0L) {
            log.warning("Found broken DR data: " + (grpCtx.sharedGroup() ? ", cacheGroup=" + grpCtx.cacheOrGroupName() + ", affectedCaches=" + metrics.affectedCaches : ", cacheName=" + grpCtx.cacheOrGroupName()) + ", details=" + metrics);
        }
    }

    private GridDhtLocalPartition reservePartition(@Nullable CacheGroupContext grpCtx) {
        if (grpCtx == null) {
            throw new IllegalArgumentException("Cache group not found: " + this.groupName);
        }
        GridDhtLocalPartition locPart = grpCtx.topology().localPartition(this.part);
        if (locPart == null || !locPart.reserve()) {
            throw new IllegalArgumentException("Failed to reserve partition for group: groupName=" + this.groupName + ", part=" + this.part);
        }
        if (locPart.state() != GridDhtPartitionState.OWNING || grpCtx.topology().stopping()) {
            locPart.release();
            throw new IllegalArgumentException("Failed to reserve non-owned partition for group: groupName=" + this.groupName + ", part=" + this.part);
        }
        return locPart;
    }

    private static class Metrics
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final int part;
        private final long size;
        private final Set<Integer> affectedCaches = new HashSet<Integer>();
        private long entriesProcessed;
        private long brokenEntriesFound;
        private long duration;

        public Metrics(int part, long size) {
            this.part = part;
            this.size = size;
        }

        public String toString() {
            return "[partition=" + this.part + "partitionSize=" + this.size + ", entriesProcessed=" + this.entriesProcessed + ", brokenEntriesFound=" + this.brokenEntriesFound + ", duration=" + Duration.ofMillis(this.duration) + ']';
        }
    }
}

