/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.security;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.security.GridSecurityProcessor;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContextHolder;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.events.AuthenticationEvent;
import org.gridgain.grid.events.AuthorizationEvent;
import org.gridgain.grid.internal.processors.security.AllowAllPermissionSet;
import org.gridgain.grid.internal.processors.security.GridAuthenticatorHandler;
import org.gridgain.grid.internal.processors.security.GridSecurityContext;
import org.gridgain.grid.internal.processors.security.GridSecurityImpl;
import org.gridgain.grid.internal.processors.security.GridSecuritySubjectDescriptor;
import org.gridgain.grid.internal.processors.security.GridSecuritySubjectKey;
import org.gridgain.grid.internal.processors.security.RemoteAuthTask;
import org.gridgain.grid.internal.processors.security.SecuritySubjectAdapter;
import org.gridgain.grid.security.AuthenticationValidator;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.passcode.PasscodeAuthenticator;
import org.jetbrains.annotations.Nullable;

public class GridEntSecurityProcessor
extends GridProcessorAdapter
implements GridSecurityProcessor {
    private static final int TOP_HISTORY_SEARCH_SIZE = 5;
    private static final int ADD_TO_CACHE_RETRIES_CNT = 5;
    private static final SecurityPermissionSet ALLOW_ALL = new AllowAllPermissionSet();
    private static final byte EMPTY_AUTH_TOKEN = 1;
    private static final String VISOR_IGNITE_TASK_PREFIX = "org.apache.ignite.internal.visor.";
    private static final String VISOR_GRIDGAIN_TASK_PREFIX = "org.gridgain.grid.internal.visor.";
    private static final String VISOR_CACHE_LOAD_TASK_NAME = "org.apache.ignite.internal.visor.cache.VisorCacheLoadTask";
    private static final String VISOR_CACHE_CLEAR_TASK_NAME = "org.apache.ignite.internal.visor.cache.VisorCacheClearTask";
    private static final String VISOR_CACHE_MODIFY_TASK_NAME = "org.apache.ignite.internal.visor.cache.VisorCacheModifyTask";
    private static final String VISOR_CACHE_GET_VALUE_TASK_NAME = "org.apache.ignite.internal.visor.cache.VisorCacheGetValueTask";
    private static final String VISOR_CACHE_REBALANCE_TASK_NAME = "org.apache.ignite.internal.visor.cache.VisorCacheRebalanceTask";
    private static final String VISOR_CACHE_RESET_METRICS_TASK_NAME = "org.apache.ignite.internal.visor.cache.VisorCacheResetMetricsTask";
    private static final String VISOR_CLEAR_CACHES_TASK_NAME = "org.apache.ignite.internal.visor.cache.ClearCachesTask";
    private static final String VISOR_CACHE_START_TASK_NAME = "org.apache.ignite.internal.visor.cache.VisorCacheStartTask";
    private static final String VISOR_CACHE_STOP_TASK_NAME = "org.apache.ignite.internal.visor.cache.VisorCacheStopTask";
    private static final String VISOR_SCAN_QUERY_TASK_NAME = "org.apache.ignite.internal.visor.query.VisorScanQueryTask";
    private static final String VISOR_QUERY_TASK_NAME = "org.apache.ignite.internal.visor.query.VisorQueryTask";
    private static final String VISOR_QUERY_FETCH_FIRST_PAGE_TASK_NAME = "org.apache.ignite.internal.visor.query.VisorQueryFetchFirstPageTask";
    private static final String VISOR_QUERY_PING_TASK_NAME = "org.apache.ignite.internal.visor.query.VisorQueryPingTask";
    private static final String VISOR_QUERY_RESET_METRICS_TASK_NAME = "org.apache.ignite.internal.visor.query.VisorQueryResetMetricsTask";
    private static final String VISOR_QUERY_CANCEL_TASK_NAME = "org.apache.ignite.internal.visor.query.VisorQueryCancelTask";
    private static final String VISOR_QUERY_DETAIL_METRICS_RESET_TASK_NAME = "org.apache.ignite.internal.visor.query.VisorQueryResetDetailMetricsTask";
    private static final String VISOR_QUERY_HISTORY_METRICS_RESET_TASK_NAME = "org.apache.ignite.internal.visor.query.VisorQueryHistoryMetricsResetTask";
    private static final String VISOR_LICENSE_UPLOAD_TASK = "org.gridgain.grid.internal.visor.license.VisorLicenseUpdateTask";
    private static final String VISOR_NODE_GC_TASK = "org.apache.ignite.internal.visor.node.VisorNodeGcTask";
    private static final String VISOR_NODES_RESTART_TASK = "org.apache.ignite.internal.visor.node.VisorNodeRestartTask";
    private static final String VISOR_NODES_STOP_TASK = "org.apache.ignite.internal.visor.node.VisorNodeStopTask";
    private static final String VISOR_DR_SENDER_CACHE_BOOTSTRAP_TASK = "org.gridgain.grid.internal.visor.dr.VisorDrSenderCacheBootstrapTask";
    private static final String VISOR_DR_SENDER_CACHE_CHANGE_REPLICATION_STATE_TASK = "org.gridgain.grid.internal.visor.dr.VisorDrSenderCacheChangeReplicationStateTask";
    private static final String VISOR_DR_RESET_METRICS_TASK = "org.gridgain.grid.internal.visor.dr.VisorDrResetMetricsTask";
    private static final String VISOR_DR_NODE_TASK = "org.gridgain.grid.internal.visor.dr.console.VisorDrNodeTask";
    private static final String VISOR_DR_CACHE_TASK = "org.gridgain.grid.internal.visor.dr.console.VisorDrCacheTask";
    private static final String VISOR_DR_FST_TASK = "org.gridgain.grid.internal.visor.dr.console.VisorDrProcessFSTTask";
    private static final String VISOR_DR_CHECK_PARTITION_COUNTERS_TASK = "org.apache.ignite.internal.visor.dr.VisorDrCheckPartitionCountersTask";
    private static final String VISOR_DR_REBUILD_TREE_TASK = "org.apache.ignite.internal.visor.dr.VisorDrRebuildTreeTask";
    private static final String VISOR_DR_CLEANUP_TREE_TASK = "org.apache.ignite.internal.visor.dr.VisorDrCleanupTreeTask";
    private static final String VISOR_DR_REPAIR_PARTITION_COUNTERS_TASK = "org.apache.ignite.internal.visor.dr.VisorDrRepairPartitionCountersTask";
    private static final String VISOR_DR_STATE_TASK = "org.gridgain.grid.internal.visor.dr.console.VisorDrStateTask";
    private static final String VISOR_DR_TOPOLOGY_TASK = "org.gridgain.grid.internal.visor.dr.console.VisorDrTopologyTask";
    private static final String VISOR_DR_CLEAR_SENDER_CONNECTION_STORE_TASK = "org.gridgain.grid.internal.visor.dr.VisorDrClearSenderConnectionStoreTask";
    private static final String VISOR_CHANGE_GRID_ACTIVE_STATE_TASK = "org.apache.ignite.internal.visor.misc.VisorChangeGridActiveStateTask";
    private static final String VISOR_RESET_COMPUTE_METRICS_TASK = "org.apache.ignite.internal.visor.compute.VisorComputeResetMetricsTask";
    private static final String VISOR_CANCEL_SNAPSHOT_OPERATION_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorCancelSnapshotOperationTask";
    private static final String VISOR_CHECK_SNAPSHOT_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorCheckSnapshotTask";
    private static final String VISOR_CREATE_SNAPSHOT_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorCreateSnapshotTask";
    private static final String VISOR_DELETE_SNAPSHOT_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorDeleteSnapshotTask";
    private static final String VISOR_CLEANUP_RESTARTING_CACHES_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorCleanupRestartingCachesTask";
    private static final String VISOR_MOVE_SNAPSHOT_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorMoveSnapshotTask";
    private static final String VISOR_COPY_SNAPSHOT_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorCopySnapshotTask";
    private static final String VISOR_RESTORE_SNAPSHOT_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorRestoreSnapshotTask";
    private static final String VISOR_CHANGE_SNAPSHOT_SECURITY_LEVEL_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorChangeSnapshotSecurityLevelTask";
    private static final String VISOR_SCHEDULE_SNAPSHOT_OPERATION_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorScheduleSnapshotOperationTask";
    private static final String VISOR_DELETE_SNAPSHOT_SCHEDULE_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorDeleteSnapshotScheduleTask";
    private static final String VISOR_IDLE_VERIFY_TASK = "org.apache.ignite.internal.visor.verify.VisorIdleVerifyTask";
    private static final String VISOR_IDLE_VERIFY_TASK_V2 = "org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskV2";
    private static final String VISOR_IDLE_VERIFY_DUMP_TASK = "org.apache.ignite.internal.visor.verify.VisorIdleVerifyDumpTask";
    private static final String VISOR_IDLE_ANALYZE_TASK = "org.apache.ignite.internal.visor.verify.VisorIdleAnalyzeTask";
    private static final String VISOR_TOGGLE_SNAPSHOT_SCHEDULE_ENABLED_STATE_TASK = "org.gridgain.grid.internal.visor.database.snapshot.VisorToggleSnapshotScheduleEnabledStateTask";
    private static final String VISOR_BASELINE_TASK = "org.apache.ignite.internal.visor.baseline.VisorBaselineTask";
    private static final String VISOR_CLUSTER_CHANGE_TAG_TASK = "org.apache.ignite.internal.visor.id_and_tag.VisorClusterChangeTagTask";
    private static final String VISOR_CLUSTER_CHANGE_ID_TASK = "org.apache.ignite.internal.visor.id_and_tag.VisorClusterChangeIdTask";
    private static final String VISOR_TX_TASK = "org.apache.ignite.internal.visor.tx.VisorTxTask";
    private static final String TX_INFO_FETCH_NEAR_XID_TASK = "org.apache.ignite.internal.visor.tx.FetchNearXidVersionTask";
    private static final String VISOR_CONTENTION_TASK = "org.apache.ignite.internal.visor.verify.VisorContentionTask";
    private static final String VISOR_VIEW_CACHE_TASK = "org.apache.ignite.internal.visor.verify.VisorViewCacheTask";
    private static final String VISOR_VALIDATE_INDEXES_TASK = "org.apache.ignite.internal.visor.verify.VisorValidateIndexesTask";
    private static final String VISOR_FIND_AND_DELETE_GARBAGE_TASK = "org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceTask";
    private static final String VISOR_CACHE_RESET_LOST_PARTITIONS_TASK_NAME = "org.apache.ignite.internal.visor.cache.VisorCacheResetLostPartitionsTask";
    private static final String VISOR_CACHE_TOGGLE_STATISTICS_TASK_NAME = "org.apache.ignite.internal.visor.cache.VisorCacheToggleStatisticsTask";
    private static final String VISOR_FORCE_REBUILD_INDEX_TASK = "org.apache.ignite.internal.visor.cache.index.IndexForceRebuildTask";
    private static final String VISOR_WAL_TASK = "org.apache.ignite.internal.visor.misc.VisorWalTask";
    private static final String VISOR_DIAGNOSTIC_PAGE_LOCKS = "org.apache.ignite.internal.visor.diagnostic.VisorPageLocksTask";
    private static final String VISOR_DIAGNOSTIC_CONNECTIVITY = "org.apache.ignite.internal.visor.diagnostic.availability.VisorConnectivityTask";
    private static final String VISOR_DEFRAGMENTATION_TASK = "org.apache.ignite.internal.visor.defragmentation.VisorDefragmentationTask";
    private static final String IGNITE_KILL_TASK = "org.apache.ignite.internal.cluster.IgniteKillTask";
    private static final String CACHE_SIZE_TASK = "org.apache.ignite.internal.processors.cache.GridCacheAdapter$SizeTask";
    private static final String CACHE_SIZE_LONG_TASK = "org.apache.ignite.internal.processors.cache.GridCacheAdapter$SizeLongTask";
    private static final String CACHE_PARTITION_SIZE_LONG_TASK = "org.apache.ignite.internal.processors.cache.GridCacheAdapter$PartitionSizeLongTask";
    private static final String CACHE_CLEAR_TASK = "org.apache.ignite.internal.processors.cache.GridCacheAdapter$ClearTask";
    private static final String REMOTE_MAP_TASK = "org.apache.ignite.internal.util.future.IgniteRemoteMapTask";
    private static final String VERIFY_BACKUP_PARTITIONS_TASK = "org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTask";
    private static final String VERIFY_BACKUP_PARTITIONS_TASK_V2 = "org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTaskV2";
    private static final String VERIFY_BACKUP_PARTITIONS_DUMP_TASK = "org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsDumpTask";
    private static final String COLLECT_SNAPSHOT_INFO_TASK = "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTask";
    private static final String COLLECT_SNAPSHOT_INFO_TASK_V2 = "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskV2";
    private static final String COLLECT_SNAPSHOT_LIST_TASK = "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotListTask";
    public static final String COLLECT_DEPENDANT_SNAPSHOTS_TASK = "org.gridgain.grid.internal.processors.cache.database.CollectDependantSnapshotSetTask";
    public static final String COLLECT_SNAPSHOT_DESCRIPTOR_TASK_V2 = "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotDescriptorV2Task";
    public static final String COLLECT_SNAPSHOT_DESCRIPTOR_TASK = "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTask$CollectSnapshotDescriptorTask";
    public static final String COLLECT_SNAPSHOT_DESCRIPTOR_TASK_V3 = "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskV2$CollectSnapshotDescriptorTask";
    public static final String GET_ONGOING_SNAPSHOT_OPERATION_TASK = "org.gridgain.grid.internal.processors.cache.database.GetOngoingOperationTask";
    public static final String COLLECT_SNAPSHOT_PARTITION_DISTRIBUTION_TASK = "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotPartitionDistributionTask";
    public static final String COLLECT_SNAPSHOT_PARTITION_DISTRIBUTION_TASK_V2 = "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotPartitionDistributionTaskV2";
    public static final String COLLECT_SNAPSHOT_PARTITION_DISTRIBUTION_TASK_V3 = "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotPartitionDistributionTaskV3";
    public static final String CACHE_PROXY_RESET_RESTART_FLAG_TASK = "org.gridgain.grid.internal.processors.cache.database.CacheProxyResetRestartFlagTask";
    private static final String VISOR_CREATE_CONSISTENT_TASK = "org.gridgain.grid.internal.visor.txdr.VisorCreateConsistentCutTask";
    private static final String VISOR_APPLY_CONSISTENT_TASK = "org.gridgain.grid.internal.visor.txdr.VisorApplyConsistentCutTask";
    private static final String VISOR_CUT_TESTING_SNAPSHOT_CREATE = "org.gridgain.grid.internal.visor.txdr.VisorCutTestingSnapshotCreateTask";
    private static final String VISOR_TX_REPLICATION_BOOTSTRAP_TASK = "org.gridgain.grid.internal.visor.txdr.VisorReplicationBootstrapTask";
    private static final String VISOR_TX_REPLICATION_STATUS_TASK = "org.gridgain.grid.internal.visor.txdr.VisorReplicationStatusTask";
    private static final String VISOR_TX_REPLICATION_STOP_TASK = "org.gridgain.grid.internal.visor.txdr.VisorReplicationStopTask";
    private static final String VISOR_TX_REPLICATION_PAUSE_TASK = "org.gridgain.grid.internal.visor.txdr.VisorReplicationPauseTask";
    private static final String VISOR_TX_REPLICATION_RESUME_TASK = "org.gridgain.grid.internal.visor.txdr.VisorReplicationResumeTask";
    private static final String VISOR_TX_REPLICATION_SWITCH_TASK = "org.gridgain.grid.internal.visor.txdr.VisorReplicationSwitchTask";
    private static final String VISOR_TX_REPLICATION_DEBUG_TASK = "org.gridgain.grid.internal.visor.txdr.VisorReplicationDebugTask";
    private static final String VISOR_ROLLING_UPGRADE_CHANGE_MODE_TASK = "org.apache.ignite.internal.visor.ru.VisorRollingUpgradeChangeModeTask";
    private static final String VISOR_ROLLING_UPGRADE_CHANGE_MODE_INTERNAL_TASK = "org.gridgain.grid.internal.visor.nodevalidation.VisorRollingUpgradeChangeModeTask";
    private static final String VISOR_ROLLING_UPGRADE_STATUS_TASK = "org.apache.ignite.internal.visor.ru.VisorRollingUpgradeStatusTask";
    private static final String VISOR_ID_AND_TAG_VIEW_TASK = "org.apache.ignite.internal.client.impl.id_and_tag.IdAndTagViewTask";
    private static final String VISOR_RESET_LOST_PARTITIONS_TASK = "org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTask";
    private static final String VISOR_CACHE_DISTRIBUTION_TASK = "org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTask";
    private static final String RECONCILIATION_BATCH_TASK = "org.apache.ignite.internal.processors.cache.checker.tasks.CollectPartitionKeysByBatchTask";
    private static final String RECONCILIATION_RECHECK_TASK = "org.apache.ignite.internal.processors.cache.checker.tasks.CollectPartitionKeysByRecheckRequestTask";
    private static final String RECONCILIATION_REPAIR_TASK = "org.apache.ignite.internal.processors.cache.checker.tasks.RepairRequestTask";
    private static final String RECONCILIATION_PROCESSOR_TASK = "org.apache.ignite.internal.processors.cache.verify.checker.tasks.PartitionReconciliationProcessorTask";
    private static final String RECONCILIATION_SESSION_TASK = "org.apache.ignite.internal.processors.cache.verify.checker.tasks.PartitionReconciliationProcessorTask$ReconciliationSessionId";
    private static final String VISOR_PERSISTENCE_CLEAN_TASK = "org.apache.ignite.internal.visor.persistence.PersistenceTask";
    private static final String VISOR_CHANGE_MASTER_KEY_TASK = "org.apache.ignite.internal.visor.encryption.VisorChangeMasterKeyTask";
    private static final String VISOR_GET_MASTER_KEY_NAME_TASK = "org.apache.ignite.internal.visor.encryption.VisorGetMasterKeyNameTask";
    private static final String VISOR_REENCRYPTION_RATE_TASK = "org.apache.ignite.internal.visor.encryption.VisorReencryptionRateTask";
    private static final String VISOR_CHANGE_CACHE_GROUP_KEY_TASK = "org.apache.ignite.internal.visor.encryption.VisorChangeCacheGroupKeyTask";
    private static final String VISOR_ENCRYPTION_KEY_IDS_TASK = "org.apache.ignite.internal.visor.encryption.VisorEncryptionKeyIdsTask";
    private static final String VISOR_REENCRYPTION_STATUS_TASK = "org.apache.ignite.internal.visor.encryption.VisorReencryptionStatusTask";
    private static final String VISOR_REENCRYPTION_SUSPEND_TASK = "org.apache.ignite.internal.visor.encryption.VisorReencryptionSuspendTask";
    private static final String VISOR_REENCRYPTION_RESUME_TASK = "org.apache.ignite.internal.visor.encryption.VisorReencryptionResumeTask";
    private static final String VISOR_CHECKPOINT_TASK = "org.apache.ignite.internal.visor.checkpoint.VisorCheckpointTask";
    private static final String VISOR_TRACING_CONFIGURATION_TASK = "org.apache.ignite.internal.visor.tracing.configuration.VisorTracingConfigurationTask";
    private static final Set<String> SKIP_AUTH_TASK_NAMES = new HashSet<String>(){
        {
            this.add(GridEntSecurityProcessor.REMOTE_MAP_TASK);
            this.add("org.apache.ignite.internal.jdbc.JdbcConnectionValidationTask");
            this.add(GridEntSecurityProcessor.MANAGEMENT_CONSOLE_EXECUTE_ACTION_TASK);
            this.add("org.apache.ignite.internal.processors.cache.FetchActiveTxOwnerTraceClosure");
            this.add("org.apache.ignite.internal.CheckCpHistTask");
            this.add("org.apache.ignite.internal.CheckCpHistTask.CheckCpHistClosureJob");
            this.add("org.gridgain.grid.internal.processors.security.RemoteAuthTask");
            this.add("org.gridgain.grid.internal.processors.security.RemoteAuthTask.RemoteAuthJob");
        }
    };
    private static final Set<String> VISOR_REQUIRED_DEPENDENT_TASKS = new HashSet<String>(Arrays.asList("org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager$MetadataJob", "org.apache.ignite.internal.client.impl.id_and_tag.IdAndTagViewTask", "org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTask", "org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTask"));
    private static final String MANAGEMENT_CONSOLE_EXECUTE_ACTION_TASK = "org.gridgain.control.agent.processor.action.ExecuteActionTask";
    private static final Set<String> INTERNAL_TASK_NAMES = new HashSet<String>(Arrays.asList("org.apache.ignite.internal.cluster.IgniteKillTask", "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTask", "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskV2", "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotListTask", "org.gridgain.grid.internal.processors.cache.database.CollectDependantSnapshotSetTask", "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTask$CollectSnapshotDescriptorTask", "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotDescriptorV2Task", "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskV2$CollectSnapshotDescriptorTask", "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotPartitionDistributionTask", "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotPartitionDistributionTaskV2", "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotPartitionDistributionTaskV3", "org.gridgain.grid.internal.processors.cache.database.GetOngoingOperationTask", "org.apache.ignite.internal.processors.cache.GridCacheAdapter$SizeTask", "org.apache.ignite.internal.processors.cache.GridCacheAdapter$SizeLongTask", "org.apache.ignite.internal.processors.cache.GridCacheAdapter$PartitionSizeLongTask", "org.apache.ignite.internal.processors.cache.GridCacheAdapter$ClearTask", "org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTask", "org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTaskV2", "org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsDumpTask", "org.gridgain.grid.internal.processors.cache.database.CacheProxyResetRestartFlagTask", "org.gridgain.control.agent.processor.action.ExecuteActionTask", "org.apache.ignite.internal.processors.cache.checker.tasks.CollectPartitionKeysByBatchTask", "org.apache.ignite.internal.processors.cache.checker.tasks.CollectPartitionKeysByRecheckRequestTask", "org.apache.ignite.internal.processors.cache.checker.tasks.RepairRequestTask", "org.apache.ignite.internal.processors.cache.verify.checker.tasks.PartitionReconciliationProcessorTask", "org.apache.ignite.internal.processors.cache.verify.checker.tasks.PartitionReconciliationProcessorTask$ReconciliationSessionId"));
    private static final Set<String> VISOR_TASK_NAMES = new HashSet<String>(Arrays.asList("org.apache.ignite.internal.visor.binary.VisorBinaryMetadataCollectorTask", "org.apache.ignite.internal.visor.cache.VisorCacheClearTask", "org.apache.ignite.internal.visor.cache.VisorCacheModifyTask", "org.apache.ignite.internal.visor.cache.VisorCacheConfigurationCollectorTask", "org.apache.ignite.internal.visor.cache.VisorCacheLoadTask", "org.apache.ignite.internal.visor.cache.VisorCacheMetadataTask", "org.apache.ignite.internal.visor.cache.VisorCacheMetricsCollectorTask", "org.apache.ignite.internal.visor.cache.VisorCacheNodesTask", "org.apache.ignite.internal.visor.cache.VisorCacheQueryMetricsCollectorTask", "org.apache.ignite.internal.visor.cache.VisorCacheRebalanceTask", "org.apache.ignite.internal.visor.cache.VisorCacheResetMetricsTask", "org.apache.ignite.internal.visor.cache.VisorCacheResetQueryMetricsTask", "org.apache.ignite.internal.visor.cache.VisorCacheStartTask", "org.apache.ignite.internal.visor.cache.VisorCacheStopTask", "org.apache.ignite.internal.visor.cache.VisorCacheSwapBackupsTask", "org.apache.ignite.internal.visor.cache.VisorCacheNamesCollectorTask", "org.apache.ignite.internal.visor.cache.VisorCacheAffinityNodeTask", "org.apache.ignite.internal.visor.cache.VisorCachePartitionsTask", "org.apache.ignite.internal.visor.cache.VisorCacheLostPartitionsTask", "org.apache.ignite.internal.visor.cache.index.IndexListTask", "org.apache.ignite.internal.visor.cache.index.IndexRebuildStatusTask", "org.apache.ignite.internal.visor.compute.VisorComputeCancelSessionsTask", "org.apache.ignite.internal.visor.compute.VisorComputeResetMetricsTask", "org.apache.ignite.internal.visor.compute.VisorComputeToggleMonitoringTask", "org.apache.ignite.internal.visor.compute.VisorGatewayTask", "org.apache.ignite.internal.visor.debug.VisorThreadDumpTask", "org.apache.ignite.internal.visor.file.VisorFileBlockTask", "org.apache.ignite.internal.visor.file.VisorLatestTextFilesTask", "org.apache.ignite.internal.visor.log.VisorLogSearchTask", "org.apache.ignite.internal.visor.metric.VisorMetricTask", "org.apache.ignite.internal.visor.misc.VisorAckTask", "org.apache.ignite.internal.visor.misc.VisorChangeGridActiveStateTask", "org.apache.ignite.internal.visor.misc.VisorLatestVersionTask", "org.apache.ignite.internal.visor.misc.VisorNopTask", "org.apache.ignite.internal.visor.misc.VisorResolveHostNameTask", "org.apache.ignite.internal.visor.node.VisorNodeConfigurationCollectorTask", "org.apache.ignite.internal.visor.node.VisorNodeDataCollectorTask", "org.apache.ignite.internal.visor.node.VisorCacheRebalanceCollectorTask", "org.apache.ignite.internal.visor.node.VisorNodeEventsCollectorTask", "org.apache.ignite.internal.visor.node.VisorNodeGcTask", "org.apache.ignite.internal.visor.node.VisorNodePingTask", "org.apache.ignite.internal.visor.node.VisorNodeRestartTask", "org.apache.ignite.internal.visor.node.VisorNodeStopTask", "org.apache.ignite.internal.visor.node.VisorNodeSuppressedErrorsTask", "org.apache.ignite.internal.visor.query.VisorQueryCleanupTask", "org.apache.ignite.internal.visor.query.VisorQueryNextPageTask", "org.apache.ignite.internal.visor.query.VisorQueryTask", "org.apache.ignite.internal.visor.query.VisorQueryFetchFirstPageTask", "org.apache.ignite.internal.visor.query.VisorQueryPingTask", "org.apache.ignite.internal.visor.query.VisorQueryCancelTask", "org.apache.ignite.internal.visor.query.VisorRunningQueriesCollectorTask", "org.apache.ignite.internal.visor.query.VisorScanQueryTask", "org.apache.ignite.internal.visor.query.VisorQueryDetailMetricsCollectorTask", "org.apache.ignite.internal.visor.query.VisorQueryHistoryMetricsCollectorTask", "org.apache.ignite.internal.visor.query.VisorQueryHistoryMetricsCollectorTask", "org.apache.ignite.internal.visor.service.VisorCancelServiceTask", "org.apache.ignite.internal.visor.service.VisorServiceTask", "org.apache.ignite.internal.visor.VisorMultiNodeTask", "org.apache.ignite.internal.visor.VisorOneNodeTask", "org.gridgain.grid.internal.visor.cache.VisorGridGainCacheConfigurationCollectorTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorCheckSnapshotTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorCreateSnapshotTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorDeleteSnapshotTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorListSnapshotsTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorMoveSnapshotTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorRestoreSnapshotTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfoTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotsStatusTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorCollectSnapshotSchedulesTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorCheckSnapshotsChangesTask", "org.gridgain.grid.internal.visor.dr.VisorDrResetMetricsTask", "org.gridgain.grid.internal.visor.dr.VisorDrSenderCacheBootstrapTask", "org.gridgain.grid.internal.visor.dr.VisorDrSenderCacheChangeReplicationStateTask", "org.gridgain.grid.internal.visor.license.VisorLicenseCollectorTask", "org.gridgain.grid.internal.visor.license.VisorLicenseUpdateTask", "org.gridgain.grid.internal.visor.node.VisorGridGainNodeConfigurationCollectorTask", "org.gridgain.grid.internal.visor.node.VisorGridGainNodeDataCollectorTask", "org.gridgain.grid.internal.visor.node.VisorGridGainNodeEventsCollectorTask", "org.gridgain.grid.internal.visor.security.VisorSecurityCollectorTask", "org.apache.ignite.internal.visor.baseline.VisorBaselineViewTask", "org.apache.ignite.internal.visor.baseline.VisorBaselineTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorDisplaySnapshotSecurityLevelTask", "org.gridgain.grid.internal.visor.event.VisorEventsCollectorTask", "org.apache.ignite.internal.visor.checker.VisorPartitionReconciliationTask", "org.apache.ignite.internal.visor.checker.VisorPartitionReconciliationCancelTask", "org.apache.ignite.internal.visor.shutdown.VisorShutdownPolicyTask", "org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotConfigurationRequestTask"));
    private final boolean strictSystemPermsModeEnabled = IgniteSystemProperties.getBoolean((String)"GG_STRICT_SYSTEM_PERMISSIONS_MODE");
    private GridAuthenticatorHandler authHnd;
    private SecurityContext locNodeSecurityCtx;
    private final Authenticator authenticator;
    private GridSecurityImpl security;
    private SecurityCredentialsProvider securityCred;
    private final JdkMarshaller marsh;
    private ConcurrentHashMap<UUID, GridFutureAdapter<?>> locAuthFuts = new ConcurrentHashMap();
    private long waitCtxPropagation;
    private long sesInvalidateTimeout;
    private volatile boolean descriptorsCacheAvailable;

    public GridEntSecurityProcessor(GridKernalContext ctx) {
        super(ctx);
        this.marsh = MarshallerUtils.jdkMarshaller((String)ctx.igniteInstanceName());
        GridGain gg = (GridGain)ctx.pluginProvider("GridGain").plugin();
        this.authenticator = gg.configuration().getAuthenticator();
        this.securityCred = gg.configuration().getSecurityCredentialsProvider();
    }

    public void start() throws IgniteCheckedException {
        this.authHnd = new GridAuthenticatorHandler(this.authenticator);
        if (this.authenticator != null) {
            this.ctx.resource().injectGeneric((Object)this.authenticator);
            if (this.authenticator instanceof LifecycleAware) {
                ((LifecycleAware)this.authenticator).start();
            }
        }
        try {
            boolean securityEnabled = this.authenticator != null;
            SecurityCredentialsProvider provider = this.securityCred;
            if (provider == null && this.authenticator instanceof SecurityCredentialsProvider) {
                provider = (SecurityCredentialsProvider)this.authenticator;
            }
            if (provider != null) {
                SecurityCredentials cred = provider.credentials();
                if (cred != null) {
                    this.ctx.addNodeAttribute("org.apache.ignite.security.cred", (Object)cred);
                } else if (securityEnabled) {
                    throw new IgniteCheckedException("Failed to start node (authentication is configured, but security credentials provider returned null).");
                }
            } else if (securityEnabled) {
                throw new IgniteCheckedException("Failed to start node (authentication is configured, but security credentials provider is not set. Fix the configuration and restart the node).");
            }
        }
        catch (IgniteCheckedException e2) {
            throw new IgniteCheckedException("Failed to create node security credentials", (Throwable)e2);
        }
        if (this.authenticator != null) {
            this.ctx.addNodeAttribute("plugins.gg.authentication.class", (Object)this.authenticator.getClass().getName());
            if (this.authenticator instanceof AuthenticationValidator) {
                Map<Object, SecurityPermissionSet> tok;
                if (this.authenticator instanceof PasscodeAuthenticator) {
                    Map rowTok = (Map)((PasscodeAuthenticator)this.authenticator).validationToken();
                    tok = rowTok.entrySet().stream().collect(Collectors.toMap(e -> ((SecurityCredentials)e.getKey()).getLogin(), Map.Entry::getValue));
                    this.ctx.addNodeAttribute("plugins.gg.authentication.token.ext.bytes", (Object)U.marshal((Marshaller)new JdkMarshaller(), new HashSet(rowTok.keySet())));
                } else {
                    tok = ((AuthenticationValidator)((Object)this.authenticator)).validationToken();
                }
                this.ctx.addNodeAttribute("plugins.gg.authentication.token", (Object)tok);
                this.ctx.addNodeAttribute("plugins.gg.authentication.token.bytes", (Object)U.marshal((Marshaller)new JdkMarshaller(), tok));
            } else {
                this.ctx.addNodeAttribute("plugins.gg.authentication.token", (Object)1);
            }
        } else {
            this.ctx.addNodeAttribute("plugins.gg.authentication.token", (Object)1);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processor started ok: " + ((Object)((Object)this)).getClass().getName());
        }
        this.security = new GridSecurityImpl(this, this.ctx);
        this.waitCtxPropagation = Math.max(0L, IgniteSystemProperties.getLong((String)"GG_SECURITY_CONTEXT_PROPAGATION_TIMEOUT_MILLIS", (long)((long)((double)this.ctx.config().getFailureDetectionTimeout().longValue() * 1.2))));
        this.sesInvalidateTimeout = Math.max(0L, IgniteSystemProperties.getLong((String)"GG_SECURITY_SESSION_INVALIDATE_TIMEOUT_MILLIS", (long)((long)((double)this.ctx.config().getFailureDetectionTimeout().longValue() * 1.2))));
    }

    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.authenticator != null && this.authenticator instanceof LifecycleAware) {
            ((LifecycleAware)this.authenticator).stop();
        }
    }

    public void onKernalStart(boolean active) throws IgniteCheckedException {
        if (this.authenticator != null && !this.ctx.isDaemon()) {
            this.ctx.event().addLocalEventListener(evt -> this.checkDescriptorsCache(), 12, new int[]{11});
        }
        this.locNodeSecurityCtx = this.nodeSecurityContext(this.ctx.discovery().localNode());
    }

    public void onKernalStop(boolean cancel) {
        super.onKernalStop(cancel);
        this.descriptorsCacheAvailable = false;
    }

    private <K, V> IgniteInternalCache<K, V> descriptorsCache() {
        try {
            this.ctx.cache().awaitStarted();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
        return this.ctx.cache().utilityCache();
    }

    private void waitForDescriptorsCacheAvailableForLocalReading() throws IgniteCheckedException {
        if (!this.descriptorsCacheAvailable) {
            this.descriptorsCache().context().preloader().syncFuture().get();
            this.descriptorsCacheAvailable = true;
        }
    }

    public SecurityContext authenticateNode(ClusterNode node, SecurityCredentials cred) throws IgniteCheckedException {
        AuthenticationContext authCtx = new AuthenticationContext();
        authCtx.subjectType(SecuritySubjectType.REMOTE_NODE);
        authCtx.subjectId(node.id());
        authCtx.credentials(cred);
        authCtx.nodeAttributes(node.attributes());
        authCtx.setClient(node.isClient());
        authCtx.address(new InetSocketAddress((String)F.first((Iterable)IgniteUtils.sortAddresses((Collection)node.addresses())), 0));
        ArrayList<InetSocketAddress> lst = new ArrayList<InetSocketAddress>();
        for (String e : node.addresses()) {
            lst.add(new InetSocketAddress(e, 0));
        }
        authCtx.allAddresses(lst);
        return this.authenticate(authCtx);
    }

    public boolean isGlobalNodeAuthentication() {
        return this.authenticator != null && this.authenticator.isGlobalNodeAuthentication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityContext authenticate(AuthenticationContext authCtx) throws IgniteCheckedException {
        assert (this.authHnd != null);
        if (this.isServersideAuth()) {
            return (SecurityContext)this.ctx.grid().compute().execute(RemoteAuthTask.class, (Object)authCtx);
        }
        SecuritySubject res = null;
        try {
            res = this.authHnd.authenticate(authCtx);
        }
        catch (Throwable throwable) {
            Object login = authCtx.credentials() == null ? null : authCtx.credentials().getLogin();
            ArrayList<InetSocketAddress> allAddresses = authCtx.allAddresses();
            if (allAddresses == null) {
                allAddresses = new ArrayList<InetSocketAddress>();
                allAddresses.add(authCtx.address());
            }
            if (res != null) {
                if (authCtx.subjectType() == SecuritySubjectType.REMOTE_CLIENT) {
                    this.addToCache(res, 5);
                }
                if (this.ctx.event().isRecordable(1001)) {
                    this.recordAuthenticationEvent(1001, authCtx.subjectType(), authCtx.subjectId(), login, allAddresses);
                }
            } else if (this.ctx.event().isRecordable(1002)) {
                this.recordAuthenticationEvent(1002, authCtx.subjectType(), authCtx.subjectId(), login, allAddresses);
            }
            throw throwable;
        }
        Object login = authCtx.credentials() == null ? null : authCtx.credentials().getLogin();
        ArrayList<InetSocketAddress> allAddresses = authCtx.allAddresses();
        if (allAddresses == null) {
            allAddresses = new ArrayList<InetSocketAddress>();
            allAddresses.add(authCtx.address());
        }
        if (res != null) {
            if (authCtx.subjectType() == SecuritySubjectType.REMOTE_CLIENT) {
                this.addToCache(res, 5);
            }
            if (this.ctx.event().isRecordable(1001)) {
                this.recordAuthenticationEvent(1001, authCtx.subjectType(), authCtx.subjectId(), login, allAddresses);
            }
        } else if (this.ctx.event().isRecordable(1002)) {
            this.recordAuthenticationEvent(1002, authCtx.subjectType(), authCtx.subjectId(), login, allAddresses);
        }
        return res == null ? null : new GridSecurityContext(res);
    }

    private boolean isServersideAuth() {
        DiscoverySpi spi = this.ctx.discovery().getInjectedDiscoverySpi();
        if (this.ctx.discovery().discoCache() == null || !IgniteFeatures.allNodesSupports((GridKernalContext)this.ctx, (Iterable)this.ctx.discovery().aliveServerNodes(), (IgniteFeatures)IgniteFeatures.REMOTE_AUTH)) {
            return false;
        }
        return this.ctx.config().isClientMode() != false && (!(spi instanceof TcpDiscoverySpi) || !((TcpDiscoverySpi)spi).isForceServerMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SecuritySubject> authenticatedSubjects() throws IgniteCheckedException {
        Collection nodes = this.ctx.discovery().nodes(this.ctx.discovery().topologyVersionEx());
        ArrayList<SecuritySubject> res = new ArrayList<SecuritySubject>(nodes.size());
        for (ClusterNode n : nodes) {
            res.add(this.nodeSecurityContext(n).subject());
        }
        IgniteInternalCache descCache = this.descriptorsCache();
        if (descCache == null) {
            return res;
        }
        descCache.context().gate().enter();
        try {
            Iterator it = descCache.scanIterator(false, (IgniteBiPredicate)SecurityDescriptorPredicate.INSTANCE);
            while (it.hasNext()) {
                Cache.Entry entry = (Cache.Entry)it.next();
                res.add(((GridSecuritySubjectDescriptor)entry.getValue()).subject());
            }
        }
        finally {
            descCache.context().gate().leave();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuritySubject authenticatedSubject(UUID subjId) throws IgniteCheckedException {
        ClusterNode n = this.ctx.discovery().node(subjId);
        if (n != null) {
            return this.nodeSecurityContext(n).subject();
        }
        GridSecuritySubjectDescriptor desc = null;
        IgniteInternalCache descCache = this.descriptorsCache();
        if (descCache != null && !descCache.context().isRecoveryMode()) {
            this.waitForDescriptorsCacheAvailableForLocalReading();
            descCache.context().gate().enter();
            try {
                desc = !this.ctx.discovery().localNode().isClient() ? (GridSecuritySubjectDescriptor)descCache.localPeek((Object)new GridSecuritySubjectKey(subjId), new CachePeekMode[]{CachePeekMode.PRIMARY, CachePeekMode.BACKUP}) : (GridSecuritySubjectDescriptor)descCache.get((Object)new GridSecuritySubjectKey(subjId));
            }
            finally {
                descCache.context().gate().leave();
            }
        }
        if (desc != null) {
            return desc.subject();
        }
        long cur = this.ctx.discovery().topologyVersion();
        for (long topVer = cur - 1L; topVer > 1L && cur - topVer > 5L; --topVer) {
            Collection nodes = this.ctx.discovery().topology(topVer);
            for (ClusterNode node : nodes) {
                if (!node.id().equals(subjId)) continue;
                return this.nodeSecurityContext(node).subject();
            }
        }
        return null;
    }

    public SecurityContext securityContext(UUID subjId) {
        try {
            SecuritySubject subj = this.authenticatedSubject(subjId);
            if (subj == null) {
                return null;
            }
            return new GridSecurityContext(subj);
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to get security context", (Throwable)e);
            return null;
        }
    }

    public void touch(SecurityContext secCtx) throws SecurityException {
        try {
            this.waitForSessionContextPropagation(secCtx.subject().id());
        }
        catch (SecurityException e) {
            U.warn((IgniteLogger)this.log, (Object)("Failed to wait for security context propagation [subj=" + secCtx.subject().id() + ", err=" + e.getMessage() + ']'), (Throwable)e);
        }
    }

    public void authorize(String name, SecurityPermission perm, @Nullable SecurityContext securityCtx) throws SecurityException {
        assert (perm != null);
        try {
            boolean authorized;
            if (securityCtx == null) {
                securityCtx = SecurityContextHolder.get();
            }
            if (securityCtx == null) {
                securityCtx = this.locNodeSecurityCtx;
            }
            if (securityCtx == null) {
                securityCtx = this.nodeSecurityContext(this.ctx.discovery().localNode());
            }
            assert (securityCtx != null);
            switch (perm) {
                case CACHE_READ: 
                case CACHE_PUT: 
                case CACHE_REMOVE: {
                    authorized = securityCtx.cacheOperationAllowed(name, perm);
                    break;
                }
                case TASK_EXECUTE: 
                case TASK_CANCEL: {
                    if (SKIP_AUTH_TASK_NAMES.contains(name)) {
                        return;
                    }
                    if (this.visorTask(name)) {
                        SecurityPermission visorPerm = this.visorTaskPermission(name);
                        if (visorPerm != null) {
                            perm = visorPerm;
                            authorized = securityCtx.systemOperationAllowed(perm);
                            break;
                        }
                        authorized = !this.strictSystemPermsModeEnabled && securityCtx.taskOperationAllowed(name, perm);
                        break;
                    }
                    if (this.internalTask(name)) {
                        SecurityPermission internalPerm = this.internalTaskPermission(name);
                        if (internalPerm != null) {
                            perm = internalPerm;
                            authorized = securityCtx.systemOperationAllowed(perm);
                            break;
                        }
                        authorized = false;
                        break;
                    }
                    authorized = securityCtx.taskOperationAllowed(name, perm);
                    break;
                }
                case SERVICE_DEPLOY: 
                case SERVICE_CANCEL: 
                case SERVICE_INVOKE: {
                    authorized = securityCtx.serviceOperationAllowed(name, perm);
                    break;
                }
                case TRACING_CONFIGURATION_UPDATE: {
                    authorized = securityCtx.tracingOperationAllowed(perm);
                    break;
                }
                case EVENTS_DISABLE: 
                case EVENTS_ENABLE: 
                case ADMIN_VIEW: 
                case ADMIN_CACHE: 
                case ADMIN_QUERY: 
                case ADMIN_OPS: 
                case JOIN_AS_SERVER: 
                case CHANGE_SNAPSHOT_SECURITY_LEVEL: 
                case SET_QUERY_MEMORY_QUOTA: 
                case GET_QUERY_VIEWS: 
                case KILL_QUERY: 
                case ADMIN_METADATA_OPS: 
                case ADMIN_READ_DISTRIBUTED_PROPERTY: 
                case ADMIN_WRITE_DISTRIBUTED_PROPERTY: 
                case REFRESH_STATISTICS: 
                case CHANGE_STATISTICS: {
                    authorized = securityCtx.systemOperationAllowed(perm);
                    break;
                }
                case CACHE_CREATE: 
                case CACHE_DESTROY: {
                    authorized = securityCtx.systemOperationAllowed(perm) || securityCtx.cacheOperationAllowed(name, perm);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid security permission: " + perm);
                }
            }
            SecuritySubject subj = securityCtx.subject();
            if (!authorized) {
                this.recordAuthorisationEvent(1006, perm, subj, name);
                throw new SecurityException("Authorization failed [perm=" + perm + ", name=" + name + ", subject=" + subj + ']');
            }
            this.recordAuthorisationEvent(1005, perm, subj, name);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to get local node security context.", (Throwable)e);
        }
    }

    public void onSessionExpired(final UUID subjId) {
        this.waitForSessionContextPropagation(subjId);
        if (this.authenticator != null && this.cacheAvaliableForUpdateSubjectInfo()) {
            boolean added = this.ctx.timeout().addTimeoutObject((GridTimeoutObject)new GridTimeoutObjectAdapter(this.sesInvalidateTimeout){

                public void onTimeout() {
                    GridEntSecurityProcessor.this.ctx.closure().runLocalSafe((Runnable)new GridPlainRunnable(){

                        public void run() {
                            IgniteInternalCache descCache = GridEntSecurityProcessor.this.descriptorsCache();
                            descCache.context().gate().enter();
                            try {
                                descCache.invokeAsync((Object)new GridSecuritySubjectKey(subjId), (EntryProcessor)new RemoveSubjectNode(GridEntSecurityProcessor.this.ctx.localNodeId()), new Object[0]).listen((IgniteInClosure & Serializable)fut -> {
                                    try {
                                        fut.get();
                                        if (GridEntSecurityProcessor.this.log.isInfoEnabled()) {
                                            GridEntSecurityProcessor.this.log.info("Security session expired [subjId=" + subjId + ", locNodeId=" + GridEntSecurityProcessor.this.ctx.localNodeId() + ", sesionInvalidationTimeout=" + GridEntSecurityProcessor.this.sesInvalidateTimeout + ']');
                                        }
                                    }
                                    catch (IgniteCheckedException e) {
                                        U.error((IgniteLogger)GridEntSecurityProcessor.this.log, (Object)("Failed to update security subject cache: " + subjId), (Throwable)e);
                                    }
                                });
                            }
                            finally {
                                descCache.context().gate().leave();
                            }
                        }
                    }, (byte)35);
                }
            });
            if (this.log.isDebugEnabled() && added) {
                this.log.debug("Security session expiration scheduled [subjId=" + subjId + ", locNodeId=" + this.ctx.localNodeId() + ", sesionInvalidationTimeout=" + this.sesInvalidateTimeout + ']');
            }
        }
    }

    private void waitForSessionContextPropagation(UUID subjId) {
        GridFutureAdapter<?> locAuthFut = this.locAuthFuts.get(subjId);
        if (locAuthFut != null) {
            if (!IgniteFeatures.allNodesSupports((GridKernalContext)this.ctx, (Iterable)this.ctx.discovery().allNodes(), (IgniteFeatures)IgniteFeatures.IGNITE_SECURITY_PROCESSOR_V2)) {
                return;
            }
            try {
                locAuthFut.get(this.waitCtxPropagation);
            }
            catch (IgniteCheckedException e) {
                throw new SecurityException("Security context is not ready [subjectId=" + subjId + ", contextPropagationTimeout=" + this.waitCtxPropagation + ", sesionInvalidationTimeout=" + this.sesInvalidateTimeout + ", failureDetectionTimeout=" + this.ctx.config().getFailureDetectionTimeout() + ']', (Throwable)e);
            }
        }
    }

    public boolean enabled() {
        return this.authenticator != null || this.securityCred != null && this.ctx.config().isClientMode() != false;
    }

    public GridSecurityImpl security() {
        return this.security;
    }

    private boolean visorTask(String taskCls) {
        return taskCls != null && (taskCls.startsWith(VISOR_IGNITE_TASK_PREFIX) || taskCls.startsWith(VISOR_GRIDGAIN_TASK_PREFIX) || VISOR_REQUIRED_DEPENDENT_TASKS.contains(taskCls));
    }

    private boolean internalTask(String taskCls) {
        return taskCls != null && INTERNAL_TASK_NAMES.contains(taskCls);
    }

    private SecurityPermission visorTaskPermission(String taskName) {
        switch (taskName) {
            case "org.apache.ignite.internal.visor.query.VisorQueryTask": 
            case "org.apache.ignite.internal.visor.query.VisorQueryFetchFirstPageTask": 
            case "org.apache.ignite.internal.visor.query.VisorQueryPingTask": 
            case "org.apache.ignite.internal.visor.query.VisorScanQueryTask": {
                return SecurityPermission.ADMIN_QUERY;
            }
            case "org.apache.ignite.internal.visor.cache.VisorCacheClearTask": 
            case "org.apache.ignite.internal.visor.cache.VisorCacheLoadTask": 
            case "org.apache.ignite.internal.visor.cache.VisorCacheModifyTask": 
            case "org.apache.ignite.internal.visor.cache.VisorCacheGetValueTask": 
            case "org.apache.ignite.internal.visor.cache.VisorCacheRebalanceTask": 
            case "org.apache.ignite.internal.visor.cache.VisorCacheResetMetricsTask": 
            case "org.apache.ignite.internal.visor.cache.ClearCachesTask": 
            case "org.apache.ignite.internal.visor.cache.VisorCacheStartTask": 
            case "org.apache.ignite.internal.visor.cache.VisorCacheStopTask": 
            case "org.apache.ignite.internal.visor.query.VisorQueryResetDetailMetricsTask": 
            case "org.apache.ignite.internal.visor.query.VisorQueryHistoryMetricsResetTask": 
            case "org.apache.ignite.internal.visor.query.VisorQueryResetMetricsTask": 
            case "org.apache.ignite.internal.visor.cache.VisorCacheResetLostPartitionsTask": 
            case "org.apache.ignite.internal.visor.cache.VisorCacheToggleStatisticsTask": {
                return SecurityPermission.ADMIN_CACHE;
            }
            case "org.gridgain.grid.internal.visor.license.VisorLicenseUpdateTask": 
            case "org.apache.ignite.internal.visor.node.VisorNodeGcTask": 
            case "org.apache.ignite.internal.visor.node.VisorNodeRestartTask": 
            case "org.apache.ignite.internal.visor.node.VisorNodeStopTask": 
            case "org.gridgain.grid.internal.visor.dr.VisorDrSenderCacheBootstrapTask": 
            case "org.gridgain.grid.internal.visor.dr.VisorDrResetMetricsTask": 
            case "org.gridgain.grid.internal.visor.dr.VisorDrClearSenderConnectionStoreTask": 
            case "org.apache.ignite.internal.visor.misc.VisorChangeGridActiveStateTask": 
            case "org.gridgain.grid.internal.visor.dr.VisorDrSenderCacheChangeReplicationStateTask": 
            case "org.apache.ignite.internal.visor.compute.VisorComputeResetMetricsTask": 
            case "org.apache.ignite.internal.visor.query.VisorQueryCancelTask": 
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorCancelSnapshotOperationTask": 
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorCheckSnapshotTask": 
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorCreateSnapshotTask": 
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorDeleteSnapshotTask": 
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorCleanupRestartingCachesTask": 
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorMoveSnapshotTask": 
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorCopySnapshotTask": 
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorRestoreSnapshotTask": 
            case "org.apache.ignite.internal.visor.verify.VisorIdleVerifyTask": 
            case "org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskV2": 
            case "org.apache.ignite.internal.visor.verify.VisorIdleVerifyDumpTask": 
            case "org.apache.ignite.internal.visor.verify.VisorIdleAnalyzeTask": 
            case "org.apache.ignite.internal.visor.verify.VisorViewCacheTask": 
            case "org.apache.ignite.internal.visor.verify.VisorContentionTask": 
            case "org.apache.ignite.internal.visor.cache.index.IndexForceRebuildTask": 
            case "org.apache.ignite.internal.visor.verify.VisorValidateIndexesTask": 
            case "org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceTask": 
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorScheduleSnapshotOperationTask": 
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorDeleteSnapshotScheduleTask": 
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorToggleSnapshotScheduleEnabledStateTask": 
            case "org.apache.ignite.internal.visor.baseline.VisorBaselineTask": 
            case "org.apache.ignite.internal.visor.misc.VisorWalTask": 
            case "org.apache.ignite.internal.visor.diagnostic.VisorPageLocksTask": 
            case "org.apache.ignite.internal.visor.diagnostic.availability.VisorConnectivityTask": 
            case "org.apache.ignite.internal.visor.id_and_tag.VisorClusterChangeTagTask": 
            case "org.apache.ignite.internal.visor.id_and_tag.VisorClusterChangeIdTask": 
            case "org.gridgain.grid.internal.visor.txdr.VisorCreateConsistentCutTask": 
            case "org.gridgain.grid.internal.visor.txdr.VisorApplyConsistentCutTask": 
            case "org.gridgain.grid.internal.visor.txdr.VisorReplicationBootstrapTask": 
            case "org.gridgain.grid.internal.visor.txdr.VisorReplicationStatusTask": 
            case "org.gridgain.grid.internal.visor.txdr.VisorCutTestingSnapshotCreateTask": 
            case "org.gridgain.grid.internal.visor.txdr.VisorReplicationStopTask": 
            case "org.gridgain.grid.internal.visor.txdr.VisorReplicationPauseTask": 
            case "org.gridgain.grid.internal.visor.txdr.VisorReplicationResumeTask": 
            case "org.gridgain.grid.internal.visor.txdr.VisorReplicationSwitchTask": 
            case "org.gridgain.grid.internal.visor.txdr.VisorReplicationDebugTask": 
            case "org.apache.ignite.internal.visor.ru.VisorRollingUpgradeChangeModeTask": 
            case "org.gridgain.grid.internal.visor.nodevalidation.VisorRollingUpgradeChangeModeTask": 
            case "org.apache.ignite.internal.visor.ru.VisorRollingUpgradeStatusTask": 
            case "org.apache.ignite.internal.visor.tx.VisorTxTask": 
            case "org.apache.ignite.internal.visor.tx.FetchNearXidVersionTask": 
            case "org.gridgain.grid.internal.visor.dr.console.VisorDrNodeTask": 
            case "org.gridgain.grid.internal.visor.dr.console.VisorDrCacheTask": 
            case "org.gridgain.grid.internal.visor.dr.console.VisorDrStateTask": 
            case "org.gridgain.grid.internal.visor.dr.console.VisorDrTopologyTask": 
            case "org.gridgain.grid.internal.visor.dr.console.VisorDrProcessFSTTask": 
            case "org.apache.ignite.internal.visor.dr.VisorDrCheckPartitionCountersTask": 
            case "org.apache.ignite.internal.visor.dr.VisorDrRebuildTreeTask": 
            case "org.apache.ignite.internal.visor.dr.VisorDrCleanupTreeTask": 
            case "org.apache.ignite.internal.visor.dr.VisorDrRepairPartitionCountersTask": 
            case "org.apache.ignite.internal.client.impl.id_and_tag.IdAndTagViewTask": 
            case "org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTask": 
            case "org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTask": 
            case "org.apache.ignite.internal.visor.persistence.PersistenceTask": 
            case "org.apache.ignite.internal.visor.encryption.VisorChangeMasterKeyTask": 
            case "org.apache.ignite.internal.visor.encryption.VisorGetMasterKeyNameTask": 
            case "org.apache.ignite.internal.visor.encryption.VisorReencryptionRateTask": 
            case "org.apache.ignite.internal.visor.encryption.VisorChangeCacheGroupKeyTask": 
            case "org.apache.ignite.internal.visor.encryption.VisorEncryptionKeyIdsTask": 
            case "org.apache.ignite.internal.visor.encryption.VisorReencryptionStatusTask": 
            case "org.apache.ignite.internal.visor.encryption.VisorReencryptionSuspendTask": 
            case "org.apache.ignite.internal.visor.encryption.VisorReencryptionResumeTask": 
            case "org.apache.ignite.internal.visor.defragmentation.VisorDefragmentationTask": 
            case "org.apache.ignite.internal.visor.checkpoint.VisorCheckpointTask": 
            case "org.apache.ignite.internal.visor.tracing.configuration.VisorTracingConfigurationTask": {
                return SecurityPermission.ADMIN_OPS;
            }
            case "org.gridgain.grid.internal.visor.database.snapshot.VisorChangeSnapshotSecurityLevelTask": {
                return SecurityPermission.CHANGE_SNAPSHOT_SECURITY_LEVEL;
            }
        }
        return VISOR_TASK_NAMES.contains(taskName) || VISOR_REQUIRED_DEPENDENT_TASKS.contains(taskName) ? SecurityPermission.ADMIN_VIEW : null;
    }

    private SecurityPermission internalTaskPermission(String taskName) {
        switch (taskName) {
            case "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTask": 
            case "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskV2": 
            case "org.gridgain.grid.internal.processors.cache.database.CollectDependantSnapshotSetTask": 
            case "org.gridgain.grid.internal.processors.cache.database.GetOngoingOperationTask": 
            case "org.apache.ignite.internal.processors.cache.GridCacheAdapter$SizeTask": 
            case "org.apache.ignite.internal.processors.cache.GridCacheAdapter$SizeLongTask": 
            case "org.apache.ignite.internal.processors.cache.GridCacheAdapter$PartitionSizeLongTask": 
            case "org.gridgain.grid.internal.processors.cache.database.CacheProxyResetRestartFlagTask": 
            case "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTask$CollectSnapshotDescriptorTask": 
            case "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotDescriptorV2Task": 
            case "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskV2$CollectSnapshotDescriptorTask": {
                return SecurityPermission.ADMIN_CACHE;
            }
            case "org.gridgain.grid.internal.processors.cache.database.CollectSnapshotListTask": {
                return SecurityPermission.ADMIN_VIEW;
            }
        }
        assert (INTERNAL_TASK_NAMES.contains(taskName)) : taskName;
        return SecurityPermission.ADMIN_OPS;
    }

    private void checkDescriptorsCache() {
        long oldest = Long.MAX_VALUE;
        final Collection nodes = this.ctx.discovery().nodes(this.ctx.discovery().topologyVersionEx());
        for (ClusterNode n : nodes) {
            oldest = Math.min(n.order(), oldest);
        }
        if (this.ctx.discovery().localNode().order() == oldest) {
            this.ctx.closure().callLocalSafe((Callable)new GridPlainCallable<Void>(){

                public Void call() {
                    GridEntSecurityProcessor.this.verifyDescriptorsCache((IgniteInternalCache<GridSecuritySubjectKey, GridSecuritySubjectDescriptor>)GridEntSecurityProcessor.this.descriptorsCache(), nodes);
                    return null;
                }
            }, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyDescriptorsCache(IgniteInternalCache<GridSecuritySubjectKey, GridSecuritySubjectDescriptor> descCache, Collection<ClusterNode> nodes) {
        ArrayList topSnapshot = new ArrayList(F.viewReadOnly(nodes, (IgniteClosure)F.node2id(), (IgnitePredicate[])new IgnitePredicate[0]));
        for (Cache.Entry e : descCache) {
            if (!(e.getKey() instanceof GridSecuritySubjectKey)) continue;
            GridSecuritySubjectKey key = (GridSecuritySubjectKey)e.getKey();
            UUID subjId = key.subjectId();
            descCache.context().gate().enter();
            try {
                descCache.invokeAsync((Object)key, (EntryProcessor)new VerifySubjectNodes(topSnapshot), new Object[0]).listen((IgniteInClosure & Serializable)fut -> {
                    try {
                        fut.get();
                    }
                    catch (IgniteCheckedException e1) {
                        U.error((IgniteLogger)this.log, (Object)("Failed to update descriptors cache for key: " + subjId), (Throwable)e1);
                    }
                });
            }
            finally {
                descCache.context().gate().leave();
            }
        }
    }

    private void addToCache(final SecuritySubject subj, final int retryCnt) throws IgniteException {
        if (this.cacheAvaliableForUpdateSubjectInfo()) {
            GridSecuritySubjectDescriptor desc;
            final IgniteInternalCache descCache = this.descriptorsCache();
            final GridSecuritySubjectKey key = new GridSecuritySubjectKey(subj.id());
            descCache.context().gate().enter();
            try {
                desc = (GridSecuritySubjectDescriptor)descCache.localPeek((Object)key, null);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
            finally {
                descCache.context().gate().leave();
            }
            if (desc == null || !desc.activeNodes().contains(this.ctx.localNodeId())) {
                final GridFutureAdapter fut = new GridFutureAdapter();
                GridFutureAdapter oldFut = this.locAuthFuts.putIfAbsent(subj.id(), fut);
                if (oldFut != null) {
                    return;
                }
                fut.listen((IgniteInClosure & Serializable)fut0 -> this.locAuthFuts.remove(subj.id()));
                if (!this.supportCertificatesOnSubject()) {
                    if (subj instanceof SecuritySubjectAdapter) {
                        ((SecuritySubjectAdapter)subj).skipCertificates();
                    } else if (subj instanceof org.gridgain.grid.security.SecuritySubjectAdapter) {
                        ((org.gridgain.grid.security.SecuritySubjectAdapter)subj).skipCertificates();
                    }
                }
                this.ctx.closure().runLocalSafe((Runnable)new GridPlainRunnable(){

                    public void run() {
                        GridEntSecurityProcessor.this.addToCache0(fut, (IgniteInternalCache<GridSecuritySubjectKey, GridSecuritySubjectDescriptor>)descCache, key, subj, retryCnt);
                    }
                }, (byte)35);
            }
        }
    }

    private boolean supportCertificatesOnSubject() {
        return U.isOldestNodeVersionAtLeast((IgniteProductVersion)IgniteProductVersion.fromString((String)"8.7.14"), (Iterable)this.ctx.discovery().aliveServerNodes());
    }

    private boolean cacheAvaliableForUpdateSubjectInfo() {
        return this.ctx.state().publicApiActiveState(false);
    }

    /*
     * Exception decompiling
     */
    private void addToCache0(GridFutureAdapter<?> updFut, IgniteInternalCache<GridSecuritySubjectKey, GridSecuritySubjectDescriptor> descCache, GridSecuritySubjectKey key, SecuritySubject subj, int retryCnt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void recordAuthenticationEvent(int type, SecuritySubjectType subjType, UUID subjId, Object login, List<InetSocketAddress> subjAddr) {
        if (this.ctx.event().isRecordable(type)) {
            String msg;
            if (type == 1001) {
                msg = "Authentication procedure succeeded.";
            } else {
                assert (type == 1002) : type;
                msg = "Authentication procedure failed.";
            }
            ClusterNode locNode = this.ctx.discovery().localNode();
            assert (subjAddr != null);
            this.ctx.event().record((Event)new AuthenticationEvent(locNode, msg, type, subjType, subjId, login, subjAddr.get(0), subjAddr));
        }
    }

    private void recordAuthorisationEvent(int type, SecurityPermission perm, SecuritySubject subj, String securityObjName) {
        if (this.ctx.event().isRecordable(type)) {
            String msg;
            String res;
            if (type == 1005) {
                res = "succeeded";
            } else {
                assert (type == 1006);
                res = "failed";
            }
            switch (perm) {
                case CACHE_READ: 
                case CACHE_PUT: 
                case CACHE_REMOVE: {
                    msg = String.format("Authorization %s [permission: %s, cache: %s]", res, perm, securityObjName);
                    break;
                }
                case TASK_EXECUTE: 
                case TASK_CANCEL: {
                    msg = String.format("Authorization %s [permission: %s, task: %s]", res, perm, securityObjName);
                    break;
                }
                default: {
                    msg = String.format("Authorization procedure %s [permission: %s]", res, perm);
                }
            }
            ClusterNode locNode = this.ctx.discovery().localNode();
            this.ctx.event().record((Event)new AuthorizationEvent(locNode, msg, type, perm, subj));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityContext nodeSecurityContext(ClusterNode node) throws IgniteCheckedException {
        byte[] subjBytes = (byte[])node.attribute("org.apache.ignite.security.subject");
        byte[] subjBytesV2 = (byte[])node.attribute("org.apache.ignite.security.subject.v2");
        if (subjBytes == null && subjBytesV2 == null) {
            SecuritySubjectAdapter subj = new SecuritySubjectAdapter(SecuritySubjectType.REMOTE_NODE, node.id());
            subj.address(new InetSocketAddress((String)F.first((Iterable)IgniteUtils.sortAddresses((Collection)node.addresses())), 0));
            subj.permissions(ALLOW_ALL);
            return new GridSecurityContext(subj);
        }
        if (subjBytesV2 != null) {
            return (SecurityContext)U.unmarshal((Marshaller)this.marsh, (byte[])subjBytesV2, (ClassLoader)U.resolveClassLoader((IgniteConfiguration)this.ctx.config()));
        }
        try {
            SecurityUtils.serializeVersion((int)1);
            SecurityContext securityContext = (SecurityContext)U.unmarshal((Marshaller)this.marsh, (byte[])subjBytes, (ClassLoader)U.resolveClassLoader((IgniteConfiguration)this.ctx.config()));
            return securityContext;
        }
        finally {
            SecurityUtils.restoreDefaultSerializeVersion();
        }
    }

    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        String rmtCls;
        IgniteNodeValidationResult res = super.validateNode(node);
        if (res != null) {
            return res;
        }
        ClusterNode locNode = this.ctx.discovery().localNode();
        if (node.isClient()) {
            return null;
        }
        String locCls = (String)locNode.attribute("plugins.gg.authentication.class");
        if (!F.eq((Object)locCls, (Object)(rmtCls = (String)node.attribute("plugins.gg.authentication.class")))) {
            String msgFormat = "Local node's authenticator class is not equal to remote node's authenticator class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]";
            return new IgniteNodeValidationResult(node.id(), String.format(msgFormat, locNode.id(), node.id(), locCls, rmtCls), String.format(msgFormat, node.id(), locNode.id(), rmtCls, locCls));
        }
        Object rmtAuthTok = node.attribute("plugins.gg.authentication.token");
        if (rmtAuthTok == null) {
            return null;
        }
        byte[] rmtAuthTokBytes = (byte[])node.attribute("plugins.gg.authentication.token.bytes");
        byte[] locAuthTokBytes = (byte[])this.ctx.nodeAttribute("plugins.gg.authentication.token.bytes");
        Object locAuthTok = locNode.attribute("plugins.gg.authentication.token");
        if (rmtAuthTokBytes != null && locAuthTokBytes != null) {
            try {
                rmtAuthTok = U.unmarshal((Marshaller)new JdkMarshaller(), (byte[])rmtAuthTokBytes, (ClassLoader)U.resolveClassLoader((IgniteConfiguration)this.ctx.config()));
                locAuthTok = U.unmarshal((Marshaller)new JdkMarshaller(), (byte[])locAuthTokBytes, (ClassLoader)U.resolveClassLoader((IgniteConfiguration)this.ctx.config()));
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        String locNodeAddrs = U.addressesAsString((ClusterNode)locNode);
        String rmtNodeAddrs = U.addressesAsString((ClusterNode)node);
        if (!F.eq((Object)locAuthTok, (Object)rmtAuthTok)) {
            String msgFormat = "Local node's authentication token is not equal to remote node's authentication token [locAuthTok=%s, rmtAuthTok=%s, locNodeAddrs=%s, rmtNodeAddrs=%s, locNodeId=%s, rmtNodeId=%s]";
            return new IgniteNodeValidationResult(node.id(), String.format(msgFormat, locAuthTok, rmtAuthTok, locNodeAddrs, rmtNodeAddrs, locNode.id(), node.id()), String.format(msgFormat, rmtAuthTok, locAuthTok, rmtNodeAddrs, locNodeAddrs, node.id(), locNode.id()));
        }
        byte[] rmtAuthExtTokBytes = (byte[])node.attribute("plugins.gg.authentication.token.ext.bytes");
        byte[] locAuthExtTokBytes = (byte[])this.ctx.nodeAttribute("plugins.gg.authentication.token.ext.bytes");
        if (rmtAuthExtTokBytes != null && locAuthExtTokBytes != null) {
            try {
                Object rmtAuthExtTok = U.unmarshal((Marshaller)new JdkMarshaller(), (byte[])rmtAuthExtTokBytes, (ClassLoader)U.resolveClassLoader((IgniteConfiguration)this.ctx.config()));
                Object locAuthExtTok = U.unmarshal((Marshaller)new JdkMarshaller(), (byte[])locAuthExtTokBytes, (ClassLoader)U.resolveClassLoader((IgniteConfiguration)this.ctx.config()));
                if (!F.eq((Object)rmtAuthExtTok, (Object)locAuthExtTok)) {
                    String msgFormat = "Local node's authentication token is not equal to remote node's authentication token. Servers have different passwords for the same users. [locNodeAddrs=%s, rmtNodeAddrs=%s, locNodeId=%s, rmtNodeId=%s]";
                    return new IgniteNodeValidationResult(node.id(), String.format(msgFormat, locNodeAddrs, rmtNodeAddrs, locNode.id(), node.id()), String.format(msgFormat, rmtNodeAddrs, locNodeAddrs, node.id(), locNode.id()));
                }
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        return null;
    }

    static class SecurityDescriptorPredicate
    implements IgniteBiPredicate<Object, Object> {
        private static final long serialVersionUID = 0L;
        private static final SecurityDescriptorPredicate INSTANCE = new SecurityDescriptorPredicate();

        SecurityDescriptorPredicate() {
        }

        public boolean apply(Object key, Object val) {
            return key instanceof GridSecuritySubjectKey;
        }

        public String toString() {
            return S.toString(SecurityDescriptorPredicate.class, (Object)this);
        }
    }

    private static class VerifySubjectNodes
    implements EntryProcessor<GridSecuritySubjectKey, GridSecuritySubjectDescriptor, Void>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private Collection<UUID> topSnapshot;

        private VerifySubjectNodes(Collection<UUID> topSnapshot) {
            this.topSnapshot = topSnapshot;
        }

        public Void process(MutableEntry<GridSecuritySubjectKey, GridSecuritySubjectDescriptor> e, Object ... args) {
            GridSecuritySubjectDescriptor old = (GridSecuritySubjectDescriptor)e.getValue();
            if (old == null) {
                return null;
            }
            HashSet<UUID> updated = new HashSet<UUID>();
            for (UUID nId : old.activeNodes()) {
                if (!this.topSnapshot.contains(nId)) continue;
                updated.add(nId);
            }
            if (updated.isEmpty()) {
                e.remove();
                return null;
            }
            e.setValue((Object)new GridSecuritySubjectDescriptor(old.subject(), updated));
            return null;
        }
    }

    private static class RemoveSubjectNode
    implements EntryProcessor<GridSecuritySubjectKey, GridSecuritySubjectDescriptor, Void>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private UUID nodeId;

        private RemoveSubjectNode(UUID nodeId) {
            this.nodeId = nodeId;
        }

        public Void process(MutableEntry<GridSecuritySubjectKey, GridSecuritySubjectDescriptor> e, Object ... args) {
            GridSecuritySubjectDescriptor old = (GridSecuritySubjectDescriptor)e.getValue();
            if (old == null) {
                return null;
            }
            HashSet<UUID> updated = new HashSet<UUID>(old.activeNodes());
            updated.remove(this.nodeId);
            if (updated.isEmpty()) {
                e.remove();
                return null;
            }
            e.setValue((Object)new GridSecuritySubjectDescriptor(old.subject(), updated));
            return null;
        }
    }

    private static class AddSubjectNode
    implements EntryProcessor<GridSecuritySubjectKey, GridSecuritySubjectDescriptor, Void>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private SecuritySubject subj;
        private UUID nodeId;

        private AddSubjectNode(SecuritySubject subj, UUID nodeId) {
            this.subj = subj;
            this.nodeId = nodeId;
        }

        public Void process(MutableEntry<GridSecuritySubjectKey, GridSecuritySubjectDescriptor> e, Object ... args) {
            GridSecuritySubjectDescriptor old = (GridSecuritySubjectDescriptor)e.getValue();
            if (old == null) {
                e.setValue((Object)new GridSecuritySubjectDescriptor(this.subj, Collections.singletonList(this.nodeId)));
                return null;
            }
            HashSet<UUID> updated = new HashSet<UUID>(old.activeNodes());
            updated.add(this.nodeId);
            e.setValue((Object)new GridSecuritySubjectDescriptor(old.subject(), updated));
            return null;
        }
    }
}

