/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.nodevalidation;

import java.util.List;
import java.util.Optional;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.ru.RollingUpgrade;
import org.apache.ignite.internal.processors.ru.RollingUpgradeModeChangeResult;
import org.apache.ignite.internal.processors.ru.RollingUpgradeStatus;
import org.apache.ignite.internal.processors.ru.RollingUpgradeUtil;
import org.apache.ignite.lang.IgniteProductVersion;
import org.gridgain.grid.ru.RollingUpgradeMXBean;

public class RollingUpgradeMXBeanImpl
implements RollingUpgradeMXBean {
    public static final String NOT_AVAILABLE_VAL = "N/A";
    private final GridKernalContext ctx;
    private final RollingUpgrade rollingUpgradeProcessor;

    public RollingUpgradeMXBeanImpl(GridKernalContext ctx) {
        this.ctx = ctx;
        this.rollingUpgradeProcessor = ctx.rollingUpgrade();
    }

    @Override
    public boolean isEnabled() {
        return this.rollingUpgradeProcessor.getStatus().enabled();
    }

    @Override
    public String getInitialVersion() {
        return Optional.ofNullable(this.rollingUpgradeProcessor.getStatus().initialVersion()).map(IgniteProductVersion::toString).orElse(NOT_AVAILABLE_VAL);
    }

    @Override
    public List<String> getInitialNodes() {
        return RollingUpgradeUtil.initialNodes((GridKernalContext)this.ctx, (RollingUpgradeStatus)this.rollingUpgradeProcessor.getStatus());
    }

    @Override
    public String getTargetVersion() {
        return Optional.ofNullable(this.rollingUpgradeProcessor.getStatus().targetVersion()).map(IgniteProductVersion::toString).orElse(NOT_AVAILABLE_VAL);
    }

    @Override
    public List<String> getUpdatedNodes() {
        return RollingUpgradeUtil.updatedNodes((GridKernalContext)this.ctx, (RollingUpgradeStatus)this.rollingUpgradeProcessor.getStatus());
    }

    @Override
    public void start() {
        this.handleResult(this.rollingUpgradeProcessor.setMode(true));
    }

    @Override
    public void finish() {
        this.handleResult(this.rollingUpgradeProcessor.setMode(false));
    }

    @Override
    public void force() {
        this.handleResult(this.rollingUpgradeProcessor.enableForcedMode());
    }

    private void handleResult(RollingUpgradeModeChangeResult res) {
        if (res.result() == RollingUpgradeModeChangeResult.Result.FAIL) {
            throw new IgniteException((Throwable)res.cause());
        }
    }
}

