/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.license;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginContext;
import org.gridgain.grid.GridProduct;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridPluginProcessorAdapter;
import org.gridgain.grid.internal.processors.license.GridLicenseFeature;
import org.gridgain.grid.internal.processors.license.GridProductImpl;
import org.gridgain.grid.internal.processors.license.LicenseProcessor;
import org.gridgain.grid.internal.processors.license.LicenseVersion;
import org.gridgain.grid.product.ProductLicense;
import org.jetbrains.annotations.Nullable;

public class ClientEntLicenseProcessor
extends GridPluginProcessorAdapter
implements LicenseProcessor {
    private GridProductImpl product;

    public ClientEntLicenseProcessor(PluginContext ctx, GridGainConfiguration cfg) {
        super(ctx, cfg);
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        this.product = new GridProductImpl(this.igniteCtx, this);
    }

    @Override
    @Nullable
    public ProductLicense license() {
        return new UltimateLicenseImpl();
    }

    @Override
    public GridProduct product() {
        return this.product;
    }

    @Override
    public long gracePeriodLeft() {
        return -1L;
    }

    @Override
    public void updateLicense(String licTxt) {
        U.log((IgniteLogger)this.log, (Object)"There was an attempt to upload a license to the client.");
    }

    @Override
    public String toString() {
        return S.toString(ClientEntLicenseProcessor.class, (Object)this);
    }

    private static class UltimateLicenseImpl
    implements ProductLicense {
        private static final long serialVersionUID = 5017231673450788233L;
        private static final UUID DUMMY_LICENSE_ID = UUID.fromString("fe65bc92-3178-11ec-8d3d-0242ac130003");
        private final UUID id = DUMMY_LICENSE_ID;
        private final String ver = LicenseVersion.getCurrentVersion().getVersion();
        private final String userOrg = "GridGain - In-Memory Computing Platform";
        private final String note = "It's a dummy ultimate license for client nodes";
        private final int maintenanceTime = 0;
        private final int maxNodes = 0;
        private final int maxComps = 0;
        private final int maxCpus = 0;
        private final long maxUpTime = 0L;
        private final long gracePeriod = 0L;
        private final Collection<GridLicenseFeature> enabledFeatures = Arrays.asList(new GridLicenseFeature("ultimate"), new GridLicenseFeature("zos"));

        private UltimateLicenseImpl() {
        }

        @Override
        public String version() {
            return this.ver;
        }

        @Override
        public UUID id() {
            return this.id;
        }

        @Override
        public String versionRegexp() {
            return null;
        }

        @Override
        public Date issueDate() {
            return null;
        }

        @Override
        public int maintenanceTime() {
            return 0;
        }

        @Override
        public String issueOrganization() {
            return null;
        }

        @Override
        public String userOrganization() {
            return "GridGain - In-Memory Computing Platform";
        }

        @Override
        public String licenseNote() {
            return "It's a dummy ultimate license for client nodes";
        }

        @Override
        public String userWww() {
            return null;
        }

        @Override
        public String userEmail() {
            return null;
        }

        @Override
        public String userName() {
            return null;
        }

        @Override
        public Date expireDate() {
            return null;
        }

        @Override
        public int maxNodes() {
            return 0;
        }

        @Override
        public int maxComputers() {
            return 0;
        }

        @Override
        public int maxCpus() {
            return 0;
        }

        @Override
        public long maxUpTime() {
            return 0L;
        }

        @Override
        public long gracePeriod() {
            return 0L;
        }

        @Override
        public String attributeName() {
            return null;
        }

        @Override
        public String attributeValue() {
            return null;
        }

        @Override
        public Collection<GridLicenseFeature> getEnabledFeatures() {
            return this.enabledFeatures;
        }

        public String toString() {
            return S.toString(UltimateLicenseImpl.class, (Object)this);
        }
    }
}

