/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.nio;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.gridgain.grid.internal.processors.dr.nio.DrMessageMarshaller;
import org.gridgain.grid.internal.processors.dr.nio.DrNioMessageMarshaller;
import org.gridgain.grid.internal.processors.dr.nio.DrNioServerBuffer;

public class DrNioParser
implements GridNioParser {
    private static final int BUF_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    private final DrNioMessageMarshaller marsh;

    public DrNioParser(DrMessageMarshaller marsh) {
        this.marsh = (DrNioMessageMarshaller)marsh;
    }

    public Object decode(GridNioSession ses, ByteBuffer buf) throws IgniteCheckedException {
        ByteBuffer decoded;
        DrNioServerBuffer nioBuf = (DrNioServerBuffer)ses.meta(BUF_META_KEY);
        if (nioBuf == null) {
            nioBuf = new DrNioServerBuffer();
            DrNioServerBuffer old = (DrNioServerBuffer)ses.addMeta(BUF_META_KEY, (Object)nioBuf);
            assert (old == null);
        }
        return (decoded = nioBuf.read(buf)) == null ? null : this.marsh.unmarshal(decoded);
    }

    public ByteBuffer encode(GridNioSession ses, Object msg) throws IgniteCheckedException {
        ByteBuffer buf = this.marsh.marshal(msg);
        assert (buf.limit() > 4 && buf.getInt(0) + 4 == buf.limit());
        return buf;
    }

    public String toString() {
        return DrNioParser.class.getSimpleName();
    }
}

