/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.store.local;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.thread.IgniteThread;
import org.gridgain.grid.cache.store.local.CacheFileLocalStore;
import org.gridgain.grid.cache.store.local.CacheFileLocalStoreWriteMode;
import org.gridgain.grid.internal.processors.cache.store.local.CacheFileLocalStoreChannelScanner;
import org.gridgain.grid.internal.processors.cache.store.local.CacheFileLocalStoreMap;
import org.gridgain.grid.internal.processors.cache.store.local.CacheFileLocalStoreStripedMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheFileLocalStoreFileManager {
    private static final ClassLoader LOADER = CacheFileLocalStore.class.getClassLoader();
    private static final String LOCK_FILE = "lock";
    private final CacheFileLocalStoreStripedMap map;
    private final CacheFileLocalStore store;
    private final long fsyncDelay;
    private final Marshaller marsh;
    private final IgniteLogger log;
    private final Path dir;
    private FileChannel dirLock;
    private final StoreFile[] files = new StoreFile[3];
    private final ReadWriteLock filesLock = new ReentrantReadWriteLock();
    private static final int fileIdxShift = 46;
    private static final long fileSizeMask = 0x3FFFFFFFFFFFL;
    private StoreFile curFile;
    private final GridWorker writer;
    private final GridWorker compactor;
    private final AtomicLong xids = new AtomicLong(1L);
    private long fileIdx;
    private long maxCompactIdx;
    private final ByteBuffer compactBuf;
    private final ByteBuffer writeBuf;
    private final Semaphore flushMux = new Semaphore(1);

    public CacheFileLocalStoreFileManager(final CacheFileLocalStore store, Ignite ignite, IgniteLogger log, String cacheName, Path dir, final long fsyncDelay) throws IOException, IgniteCheckedException {
        this.store = store;
        this.fsyncDelay = fsyncDelay * 1000L;
        this.log = log;
        this.marsh = ignite.configuration().getMarshaller();
        this.dir = dir;
        this.compactBuf = ByteBuffer.allocateDirect(store.getCompactBufferSize());
        this.writeBuf = ByteBuffer.allocateDirect(store.getWriteBufferSize());
        this.map = new CacheFileLocalStoreStripedMap(store.getMapSegments(), store.getMapCapacity() / store.getMapSegments());
        if (Files.exists(dir, new LinkOption[0]) && Files.isDirectory(dir, new LinkOption[0])) {
            this.lockDirectory();
            if (log.isDebugEnabled()) {
                log.debug("CacheFileLocalStoreFileManager uses existing directory [path=" + dir + ", storeRoot=" + store.getRootPath() + ']');
            }
            this.initFromExistingFiles();
        } else {
            Files.createDirectories(dir, new FileAttribute[0]);
            if (log.isDebugEnabled()) {
                log.debug("CacheFileLocalStoreFileManager created new directory [path=" + dir + ", storeRoot=" + store.getRootPath() + ']');
            }
            this.lockDirectory();
        }
        if (this.curFile == null) {
            int idx = this.slotForNewFile();
            this.curFile = this.files[idx] = new StoreFile(idx, this.fileIdx++);
        }
        if (fsyncDelay <= 0L && store.getWriteMode() == CacheFileLocalStoreWriteMode.SYNC) {
            this.writer = null;
        } else {
            this.writer = new GridWorker(ignite.name(), "local-store-writer-" + cacheName, log){
                private long lastFsync;
                {
                    super(arg0, arg1, arg2);
                    this.lastFsync = U.microTime();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void body() {
                    while (!this.isCancelled()) {
                        long sleep = 0L;
                        Lock l = CacheFileLocalStoreFileManager.this.filesLock.readLock();
                        try {
                            l.lockInterruptibly();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        try {
                            if (this.isCancelled()) {
                                return;
                            }
                            StoreFile f = CacheFileLocalStoreFileManager.this.curFile;
                            if (store.getWriteMode() == CacheFileLocalStoreWriteMode.ASYNC_BUFFERED) {
                                sleep = f.tryFlush();
                            }
                            assert (sleep >= 0L) : sleep;
                            if (fsyncDelay > 0L) {
                                long awaitToFsync = f.tryFsync(this.lastFsync);
                                if (sleep == 0L || awaitToFsync < sleep) {
                                    sleep = awaitToFsync;
                                }
                                if (awaitToFsync == fsyncDelay) {
                                    this.lastFsync = U.microTime();
                                }
                            }
                            assert (sleep >= 0L) : sleep;
                        }
                        finally {
                            l.unlock();
                        }
                        if (sleep == 0L) continue;
                        LockSupport.parkNanos(sleep * 1000L);
                    }
                }
            };
            new IgniteThread(this.writer).start();
        }
        this.compactor = new GridWorker(ignite.name(), "local-store-compactor-" + cacheName, log){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void body() {
                while (!this.isCancelled()) {
                    try {
                        StoreFile to;
                        Lock l;
                        int fromIdx = CacheFileLocalStoreFileManager.this.fileWithBiggestWaste();
                        if (fromIdx == -1) {
                            U.sleep((long)store.getSparsityCheckFrequency());
                            continue;
                        }
                        StoreFile from = CacheFileLocalStoreFileManager.this.files[fromIdx];
                        if (CacheFileLocalStoreFileManager.this.curFile == from) {
                            int newIdx = CacheFileLocalStoreFileManager.this.slotForNewFile();
                            StoreFile newFile = new StoreFile(newIdx, CacheFileLocalStoreFileManager.this.fileIdx++);
                            l = CacheFileLocalStoreFileManager.this.filesLock.writeLock();
                            CacheFileLocalStoreFileManager.this.acquireLock(l, false);
                            try {
                                ((CacheFileLocalStoreFileManager)CacheFileLocalStoreFileManager.this).files[newIdx] = newFile;
                                CacheFileLocalStoreFileManager.this.curFile = CacheFileLocalStoreFileManager.this.files[newIdx];
                                CacheFileLocalStoreFileManager.this.flushMux.acquire();
                            }
                            finally {
                                l.unlock();
                            }
                            from.stopWriting();
                        }
                        int toIdx = -1;
                        for (int i = 0; i < CacheFileLocalStoreFileManager.this.files.length; ++i) {
                            StoreFile f = CacheFileLocalStoreFileManager.this.files[i];
                            if (i == fromIdx || f == null || f.fileIdx >= from.fileIdx || f == CacheFileLocalStoreFileManager.this.curFile) continue;
                            toIdx = i;
                            break;
                        }
                        if (toIdx == -1) {
                            toIdx = CacheFileLocalStoreFileManager.this.slotForNewFile();
                            to = new StoreFile(toIdx, from);
                            assert (to.compactIdx > CacheFileLocalStoreFileManager.this.maxCompactIdx);
                            l = CacheFileLocalStoreFileManager.this.filesLock.writeLock();
                            CacheFileLocalStoreFileManager.this.acquireLock(l, false);
                            try {
                                CacheFileLocalStoreFileManager.this.maxCompactIdx = to.compactIdx;
                                ((CacheFileLocalStoreFileManager)CacheFileLocalStoreFileManager.this).files[toIdx] = to;
                            }
                            finally {
                                l.unlock();
                            }
                        } else {
                            to = CacheFileLocalStoreFileManager.this.files[toIdx];
                        }
                        assert (to != null);
                        CacheFileLocalStoreFileManager.this.compact(from, to);
                        to.fsync();
                        l = CacheFileLocalStoreFileManager.this.filesLock.writeLock();
                        CacheFileLocalStoreFileManager.this.acquireLock(l, false);
                        try {
                            ((CacheFileLocalStoreFileManager)CacheFileLocalStoreFileManager.this).files[fromIdx] = null;
                        }
                        finally {
                            l.unlock();
                        }
                        to.liveSize.addAndGet(from.liveSize.get());
                        from.delete();
                    }
                    catch (InterruptedException | ClosedByInterruptException | IgniteInterruptedCheckedException ignored) {
                        return;
                    }
                    catch (IOException | IgniteCheckedException e) {
                        U.error((IgniteLogger)this.log, (Object)"Failed to compact store, exiting compaction thread.", (Throwable)e);
                        return;
                    }
                }
            }
        };
        new IgniteThread(this.compactor).start();
    }

    private void lockDirectory() throws IOException {
        FileChannel ch = FileChannel.open(this.dir.resolve(LOCK_FILE), EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.READ, StandardOpenOption.WRITE), new FileAttribute[0]);
        FileLock lock = null;
        try {
            lock = ch.tryLock();
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            // empty catch block
        }
        if (lock == null) {
            throw new IOException("Failed to lock database (probably it is in use by another store instance): " + this.dir);
        }
        this.dirLock = ch;
    }

    private void initFromExistingFiles() throws IOException, IgniteCheckedException {
        ArrayList<Path> paths = new ArrayList<Path>(3);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.dir);){
            for (Path file : stream) {
                if (file.endsWith(LOCK_FILE)) continue;
                paths.add(file);
            }
        }
        if (paths.isEmpty()) {
            return;
        }
        if (paths.size() > 3) {
            throw new IllegalStateException("Failed to initialize database from directory: " + this.dir);
        }
        ArrayList<StoreFile> list = new ArrayList<StoreFile>();
        int idx = 0;
        for (Path file : paths) {
            this.files[idx] = new StoreFile(idx, file);
            list.add(this.files[idx]);
            ++idx;
        }
        if (list.size() > 1) {
            Collections.sort(list);
        }
        if (list.size() == 3 && ((StoreFile)list.get(1)).fileIdx == 0L) {
            StoreFile f = (StoreFile)list.remove(1);
            assert (((StoreFile)list.get(0)).fileIdx == 0L && ((StoreFile)list.get(0)).compactIdx == f.compactIdx - 1L);
            this.files[((StoreFile)f).idx] = null;
            f.delete();
        }
        for (StoreFile f : list) {
            this.initFile(f);
        }
        if (list.size() == 3) {
            StoreFile compact = (StoreFile)list.get(1);
            try {
                this.compact(compact, (StoreFile)list.get(0));
            }
            catch (InterruptedException e) {
                throw new IgniteInterruptedCheckedException(e);
            }
            this.files[((StoreFile)compact).idx] = null;
            compact.delete();
        }
        this.curFile = (StoreFile)list.get(list.size() - 1);
        this.curFile.initEntriesBuffer();
        this.fileIdx = this.curFile.fileIdx + 1L;
        for (Iterator<Path> iterator : this.files) {
            if (iterator == null || ((StoreFile)iterator).compactIdx <= this.maxCompactIdx) continue;
            this.maxCompactIdx = ((StoreFile)iterator).compactIdx;
        }
    }

    private void initFile(StoreFile f) throws IOException, IgniteCheckedException {
        f.writeCh.position(0L);
        CacheFileLocalStoreChannelScanner scan = new CacheFileLocalStoreChannelScanner(this.compactBuf, f.writeCh);
        HashMap<Long, ArrayList<Op>> txs = new HashMap<Long, ArrayList<Op>>();
        long pos = 0L;
        long liveSize = 0L;
        try {
            while (true) {
                short magic;
                if ((magic = scan.getShort()) == EntryType.COMMIT.magic) {
                    long xid = scan.getLong();
                    List txOps = (List)txs.remove(xid);
                    if (txOps != null) {
                        for (Op op : txOps) {
                            boolean res;
                            if (op.rmv) {
                                res = this.map.remove(op.keyHash, op.old.position());
                                assert (res);
                                this.file(op.old.position()).decrementLiveSize(op.old.size());
                                continue;
                            }
                            liveSize += (long)op.size;
                            if (op.old == null) {
                                this.map.add(op.keyHash, op.addr);
                                continue;
                            }
                            res = this.map.replace(op.keyHash, op.old.position(), op.addr);
                            assert (res);
                            this.file(op.old.position()).decrementLiveSize(op.old.size());
                        }
                        liveSize += 10L;
                    }
                } else {
                    int hdrSize;
                    int entrySize;
                    int skipSize;
                    long xid;
                    int keyHash;
                    int keySize;
                    if (magic == EntryType.PUT.magic) {
                        keySize = scan.getInt();
                        int valSize = scan.getInt();
                        keyHash = scan.getInt();
                        scan.getInt();
                        xid = scan.getLong();
                        skipSize = keySize + valSize;
                        entrySize = 26 + skipSize;
                        hdrSize = 26;
                    } else if (magic == EntryType.REMOVE.magic) {
                        keySize = scan.getInt();
                        keyHash = scan.getInt();
                        xid = scan.getLong();
                        skipSize = 16 + keySize;
                        entrySize = 34 + keySize;
                        hdrSize = 34;
                    } else {
                        throw new IgniteCheckedException("Failed to read entry: [file=" + f + ", magic=" + Integer.toHexString(magic) + "]");
                    }
                    if (this.xids.get() < xid) {
                        this.xids.lazySet(xid);
                    }
                    if (!scan.skip(skipSize)) break;
                    byte[] key = new byte[keySize];
                    ByteBuffer keyBuf = ByteBuffer.wrap(key);
                    do {
                        f.read(keyBuf, pos + (long)hdrSize + (long)keyBuf.position(), true);
                    } while (keyBuf.hasRemaining());
                    DataEntry e = this.findEntry(keyHash, key);
                    if (xid != 0L) {
                        Op op = new Op();
                        op.keyHash = keyHash;
                        op.old = e;
                        op.rmv = magic == EntryType.REMOVE.magic;
                        if (!op.rmv) {
                            op.size = entrySize;
                            op.addr = f.withFileId(pos);
                        }
                        if (op.rmv && op.old != null || !op.rmv) {
                            ArrayList<Op> txOps = (ArrayList<Op>)txs.get(xid);
                            if (txOps == null) {
                                txOps = new ArrayList<Op>();
                                txs.put(xid, txOps);
                            }
                            txOps.add(op);
                        }
                    } else if (magic == EntryType.PUT.magic) {
                        liveSize += (long)entrySize;
                        if (e == null) {
                            this.map.add(keyHash, f.withFileId(pos));
                        } else {
                            boolean res = this.map.replace(keyHash, e.position(), f.withFileId(pos));
                            assert (res);
                            this.file(e.position()).decrementLiveSize(e.size());
                        }
                    } else if (e != null) {
                        boolean res = this.map.remove(keyHash, e.position());
                        assert (res);
                        this.file(e.position()).decrementLiveSize(e.size());
                    }
                }
                pos = scan.position();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        f.fileSize = pos;
        f.writeCh.truncate(pos);
        f.writeCh.position(pos);
        f.liveSize.set(liveSize);
    }

    public int size() {
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IgniteCheckedException {
        Lock l;
        block7: {
            l = this.filesLock.writeLock();
            try {
                this.acquireLock(l, true);
            }
            catch (InterruptedException ignore) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)"Should never happen when ignoreInterrupts=true.");
            }
        }
        try {
            U.cancel((GridWorker)this.writer);
            U.cancel((GridWorker)this.compactor);
            CacheFileLocalStoreFileManager.join(this.writer);
            CacheFileLocalStoreFileManager.join(this.compactor);
            assert (this.flushMux.availablePermits() != 0);
            for (int i = 0; i < this.files.length; ++i) {
                StoreFile f = this.files[i];
                if (f == null) continue;
                U.close((AutoCloseable)f, (IgniteLogger)this.log);
                this.files[i] = null;
            }
            this.curFile = null;
            this.map.close();
            U.close((AutoCloseable)this.dirLock, (IgniteLogger)this.log);
        }
        finally {
            l.unlock();
        }
    }

    private static void join(GridWorker w) {
        try {
            U.join((GridWorker)w);
        }
        catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
            // empty catch block
        }
    }

    private void acquireLock(Lock lock, boolean ignoreInterrupts) throws InterruptedException {
        boolean interrupted = false;
        while (true) {
            try {
                while (!lock.tryLock(100L, TimeUnit.MILLISECONDS)) {
                    Thread.yield();
                }
            }
            catch (InterruptedException e) {
                if (!ignoreInterrupts) {
                    throw e;
                }
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    int compact(StoreFile from, StoreFile to) throws IOException, IgniteCheckedException, InterruptedException {
        int read;
        if (this.log.isDebugEnabled()) {
            this.log.debug("CacheFileLocalStoreFileManager starts compaction [from=" + from + ", to=" + to + ']');
        }
        ByteBuffer buf = this.compactBuf;
        buf.clear();
        long fromFileSize = from.fileSize;
        long toFileSize = to.fileSize;
        ByteBuffer[] arr = new ByteBuffer[16];
        GridLongList oldNewPos = new GridLongList();
        int entryRemaining = 0;
        long skipped = 0L;
        int liveCnt = 0;
        GridLongList txs = new GridLongList();
        for (long readPos = 0L; readPos < fromFileSize; readPos += (long)read) {
            int off = buf.position();
            read = from.read(buf, readPos, false);
            assert (read > 0) : read;
            buf.flip();
            int idx = -1;
            if (entryRemaining >= buf.remaining()) {
                assert (off == 0);
                entryRemaining -= buf.remaining();
                while (buf.hasRemaining()) {
                    StoreFile storeFile = to;
                    storeFile.fileSize = storeFile.fileSize + (long)to.writeCh.write(buf);
                }
            } else if (entryRemaining != 0) {
                assert (off == 0);
                ByteBuffer remainingBuf = buf.asReadOnlyBuffer();
                remainingBuf.limit(entryRemaining);
                buf.position(entryRemaining);
                arr[++idx] = remainingBuf;
                entryRemaining = 0;
            }
            while (buf.remaining() >= 10) {
                boolean skip;
                int entrySize;
                int pos = buf.position();
                short magic = buf.getShort();
                long entryAddr = readPos - (long)off + (long)pos;
                long keyHash = Long.MAX_VALUE;
                if (magic == EntryType.COMMIT.magic) {
                    entrySize = 10;
                    long xid = buf.getLong();
                    skip = txs.removeValue(0, xid) == -1;
                } else if (magic == EntryType.PUT.magic) {
                    if (buf.remaining() + 2 < 26) {
                        buf.position(pos);
                        break;
                    }
                    int keySize = buf.getInt();
                    int valSize = buf.getInt();
                    keyHash = buf.getInt();
                    buf.getInt();
                    long xid = buf.getLong();
                    if (xid != 0L && !txs.contains(xid)) {
                        txs.add(xid);
                    }
                    entrySize = keySize + valSize + 26;
                    skip = !this.map.contains((int)keyHash, from.withFileId(entryAddr));
                } else if (magic == EntryType.REMOVE.magic) {
                    if (buf.remaining() + 2 < 34) {
                        buf.position(pos);
                        break;
                    }
                    int keySize = buf.getInt();
                    keyHash = buf.getInt();
                    long xid = buf.getLong();
                    long fileIdx = buf.getLong();
                    long compactIdx = buf.getLong();
                    entrySize = keySize + 34;
                    if (xid != 0L && !txs.contains(xid)) {
                        txs.add(xid);
                    }
                    skip = true;
                    for (StoreFile f : this.files) {
                        if (f == null || (f.fileIdx >= fileIdx || f.compactIdx != 0L) && (f.fileIdx != 0L || f.compactIdx > compactIdx)) continue;
                        skip = false;
                        break;
                    }
                } else {
                    throw new IgniteCheckedException("Failed to read entry: [addr=" + entryAddr + ", magic=" + Integer.toHexString(magic) + "]");
                }
                if (skip) {
                    skipped += (long)entrySize;
                } else if (keyHash != Long.MAX_VALUE) {
                    ++liveCnt;
                    oldNewPos.add(keyHash);
                    oldNewPos.add(from.withFileId(entryAddr));
                    oldNewPos.add(to.withFileId(toFileSize + entryAddr - skipped));
                }
                buf.position(pos);
                ByteBuffer entryBuf = null;
                if (buf.remaining() >= entrySize) {
                    if (!skip) {
                        entryBuf = buf.asReadOnlyBuffer();
                        assert (entryBuf.position() == pos);
                        entryBuf.limit(pos + entrySize);
                    }
                    buf.position(pos + entrySize);
                } else {
                    if (skip) {
                        read += entrySize - buf.remaining();
                    } else {
                        entryBuf = buf.asReadOnlyBuffer();
                        assert (entryBuf.position() == pos);
                        entryRemaining = entrySize - entryBuf.remaining();
                    }
                    buf.position(buf.limit());
                }
                if (entryBuf == null) continue;
                if (idx < 0 || arr[idx].limit() != entryBuf.position()) {
                    if (arr.length == ++idx) {
                        arr = Arrays.copyOf(arr, arr.length * 2);
                    }
                    arr[idx] = entryBuf;
                    continue;
                }
                arr[idx].limit(entryBuf.limit());
            }
            if (idx != -1) {
                while (arr[idx].hasRemaining()) {
                    StoreFile pos = to;
                    pos.fileSize = pos.fileSize + to.writeCh.write(arr, 0, idx + 1);
                }
            }
            if (!oldNewPos.isEmpty()) {
                int len;
                int n = len = entryRemaining != 0 ? oldNewPos.size() - 3 : oldNewPos.size();
                for (int i = 0; i < len; i += 3) {
                    int keyHash = (int)oldNewPos.get(i);
                    long oldAddr = oldNewPos.get(i + 1);
                    long newAddr = oldNewPos.get(i + 2);
                    this.map.replace(keyHash, oldAddr, newAddr);
                }
                if (entryRemaining != 0) {
                    oldNewPos.truncate(3, false);
                } else {
                    oldNewPos.truncate(0, true);
                }
            }
            buf.compact();
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        }
        assert (to.fileSize == to.writeCh.size());
        if (this.log.isDebugEnabled()) {
            this.log.debug("CacheFileLocalStoreFileManager finished compaction [from=" + from + ", to=" + to + ", liveEntries" + liveCnt + ']');
        }
        return liveCnt;
    }

    private int slotForNewFile() {
        for (int i = 0; i < this.files.length; ++i) {
            if (this.files[i] != null) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    private int fileWithBiggestWaste() {
        long maxWaste = 0L;
        int maxWasteIdx = -1;
        for (int i = 0; i < this.files.length; ++i) {
            long waste;
            StoreFile f = this.files[i];
            if (f == null || !f.needCompact() || (waste = f.waste()) <= maxWaste) continue;
            maxWaste = waste;
            maxWasteIdx = i;
        }
        return maxWasteIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Map<K, IgniteBiTuple<V, ?>> loadAll(Collection<? extends K> keys, Map<K, Cache.Entry<? extends K, ? extends IgniteBiTuple<V, ?>>> delta) throws IgniteCheckedException {
        int len = keys.size();
        int[] hashes = new int[len];
        byte[][] keysBytes = new byte[len][];
        byte[][] valBytes = new byte[len][];
        int i = 0;
        for (K k : keys) {
            hashes[i] = k.hashCode();
            keysBytes[i++] = U.marshal((Marshaller)this.marsh, k);
        }
        Lock l = this.filesLock.readLock();
        l.lock();
        try {
            for (i = 0; i < hashes.length; ++i) {
                DataEntry e = this.findEntry(hashes[i], keysBytes[i]);
                if (e == null) continue;
                valBytes[i] = e.value();
            }
        }
        finally {
            l.unlock();
        }
        i = 0;
        HashMap loaded = U.newHashMap((int)keys.size());
        for (K k : keys) {
            IgniteBiTuple val0 = null;
            if (delta != null && delta.containsKey(k)) {
                val0 = (IgniteBiTuple)delta.get(k).getValue();
            }
            if (val0 == null) {
                byte[] val = valBytes[i];
                IgniteBiTuple igniteBiTuple = val0 = val == null ? null : (IgniteBiTuple)U.unmarshal((Marshaller)this.marsh, (byte[])val, (ClassLoader)LOADER);
            }
            if (val0 != null) {
                loaded.put(k, val0);
            }
            ++i;
        }
        return loaded;
    }

    public <K, V> void loadAll(final IgniteBiInClosure<K, V> clo) throws IgniteCheckedException {
        Lock l = this.filesLock.readLock();
        l.lock();
        try {
            this.map.iterate(new CacheFileLocalStoreMap.Closure(){

                @Override
                public void apply(long addr) throws IgniteCheckedException {
                    DataEntry e = CacheFileLocalStoreFileManager.this.file(addr).read(addr, true);
                    if (e == null) {
                        throw new IgniteCheckedException("Failed to find entry. Store is corrupted.");
                    }
                    assert (e.position() == addr) : e;
                    Object k = U.unmarshal((Marshaller)CacheFileLocalStoreFileManager.this.marsh, (byte[])e.key(), (ClassLoader)LOADER);
                    Object v = U.unmarshal((Marshaller)CacheFileLocalStoreFileManager.this.marsh, (byte[])e.value(), (ClassLoader)LOADER);
                    clo.apply(k, v);
                }
            });
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <K, V> V load(K key) throws IgniteCheckedException {
        int hash = key.hashCode();
        byte[] keyBytes = U.marshal((Marshaller)this.marsh, key);
        byte[] val = null;
        Lock l = this.filesLock.readLock();
        l.lock();
        try {
            DataEntry e = this.findEntry(hash, keyBytes);
            if (e == null) {
                V v = null;
                return v;
            }
            val = e.value();
        }
        finally {
            l.unlock();
        }
        return (V)U.unmarshal((Marshaller)this.marsh, (byte[])val, (ClassLoader)LOADER);
    }

    @Nullable
    private DataEntry findEntry(int keyHash, byte[] keyBytes) throws IgniteCheckedException {
        GridLongList res = this.map.get(keyHash);
        if (res == null) {
            return null;
        }
        int len = res.size();
        for (int i = 0; i < len; ++i) {
            long addr = res.get(i);
            DataEntry e = this.file(addr).read(addr, false);
            if (e == null) {
                throw new IgniteCheckedException("Failed to find entry. Store is corrupted.");
            }
            assert (e.position() == addr) : e;
            if (!e.keyEquals(keyBytes, keyHash)) continue;
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void updateAll(Collection<Cache.Entry<? extends K, ? extends V>> delta, @Nullable IgniteUuid xid) throws IgniteCheckedException {
        int deltaSize = delta.size();
        assert (deltaSize > 0);
        if (deltaSize == 1) {
            for (Cache.Entry<K, V> entry : delta) {
                this.update(entry.getKey(), entry.getValue());
            }
            return;
        }
        long xid0 = xid == null ? 0L : this.xids.incrementAndGet();
        Lock l = this.filesLock.readLock();
        l.lock();
        try {
            CompoundEntry entry = new CompoundEntry(xid0 == 0L ? deltaSize : deltaSize + 1);
            StoreFile file = this.curFile;
            Object[] vals = new Object[deltaSize];
            DataEntry[] olds = new DataEntry[deltaSize];
            int[] hashes = new int[deltaSize];
            byte[][] keys = new byte[deltaSize][];
            int c = 0;
            for (Cache.Entry<K, V> entry2 : delta) {
                byte[] keyBytes;
                Object key = entry2.getKey();
                Object val = entry2.getValue();
                int keyHash = key.hashCode();
                DataEntry old = this.findEntry(keyHash, keyBytes = U.marshal((Marshaller)this.marsh, (Object)key));
                if (old == null && val == null) continue;
                olds[c] = old;
                keys[c] = keyBytes;
                hashes[c] = keyHash;
                vals[c] = val;
                ++c;
                if (val == null) {
                    entry.add(new RmvEntry(xid0, keyBytes, keyHash, file.fileIdx, this.maxCompactIdx));
                    continue;
                }
                entry.add(new PutEntry(keyBytes, keyHash, U.marshal((Marshaller)this.marsh, (Object)val), xid0, this.store.isChecksum()));
            }
            if (xid0 != 0L) {
                entry.add(new CommitEntry(xid0));
            }
            if (entry.isEmpty()) {
                return;
            }
            long addr = file.write(entry);
            for (int i = 0; i < c; ++i) {
                this.updateMap(vals[i], olds[i], hashes[i], keys[i], addr);
                addr += (long)((AbstractFileEntry)((CompoundEntry)entry).entries.get((int)i)).len;
            }
        }
        finally {
            l.unlock();
        }
    }

    private void updateMap(@Nullable Object val, @Nullable DataEntry old, int keyHash, byte[] keyBytes, long addr) throws IgniteCheckedException {
        assert (val != null || old != null);
        while (true) {
            if (val == null) {
                if (old == null) break;
                if (this.map.remove(keyHash, old.position())) {
                    this.file(old.position()).decrementLiveSize(old.size());
                    break;
                }
            } else {
                if (old == null) {
                    this.map.add(keyHash, addr);
                    break;
                }
                if (this.map.replace(keyHash, old.position(), addr)) {
                    this.file(old.position()).decrementLiveSize(old.size());
                    break;
                }
            }
            old = this.findEntry(keyHash, keyBytes);
        }
    }

    public <K, V> void removeAll(final Collection<? extends K> keys) throws IgniteCheckedException {
        if (keys.size() == 1) {
            this.update(keys.iterator().next(), null);
            return;
        }
        this.updateAll(new AbstractCollection<Cache.Entry<? extends K, ? extends V>>(){

            @Override
            @NotNull
            public Iterator<Cache.Entry<? extends K, ? extends V>> iterator() {
                final Iterator i = keys.iterator();
                return new Iterator<Cache.Entry<? extends K, ? extends V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Cache.Entry<K, V> next() {
                        final Object k = i.next();
                        return new Cache.Entry<K, V>(){

                            public K getKey() {
                                return k;
                            }

                            public V getValue() {
                                return null;
                            }

                            public <T> T unwrap(Class<T> clazz) {
                                throw new UnsupportedOperationException();
                            }

                            public boolean equals(Object o) {
                                throw new UnsupportedOperationException();
                            }

                            public int hashCode() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return keys.size();
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object key, @Nullable Object val) throws IgniteCheckedException {
        int keyHash = key.hashCode();
        byte[] keyBytes = U.marshal((Marshaller)this.marsh, (Object)key);
        Lock l = this.filesLock.readLock();
        l.lock();
        try {
            DataEntry old = this.findEntry(keyHash, keyBytes);
            if (old == null && val == null) {
                return;
            }
            StoreFile file = this.curFile;
            AbstractFileEntry entry = val == null ? new RmvEntry(0L, keyBytes, keyHash, file.fileIdx, this.maxCompactIdx) : new PutEntry(keyBytes, keyHash, U.marshal((Marshaller)this.marsh, (Object)val), 0L, this.store.isChecksum());
            long addr = file.write(entry);
            this.updateMap(val, old, keyHash, keyBytes, addr);
        }
        finally {
            l.unlock();
        }
    }

    StoreFile file(long addr) {
        StoreFile res = this.files[(int)(addr >>> 46)];
        assert (res != null) : Long.toBinaryString(addr) + " " + Integer.toBinaryString((int)(addr >>> 46));
        return res;
    }

    private static class EntriesBuffer {
        private final AtomicInteger remaining = new AtomicInteger();
        private final AtomicReference<AbstractFileEntry> head = new AtomicReference();
        private final long bufPos;
        private final int cap;
        private final long created = U.microTime();
        private final CountDownLatch flushed = new CountDownLatch(1);
        private boolean flushSucceeded;

        EntriesBuffer(long bufPos, int cap) {
            assert (cap > 0);
            this.bufPos = bufPos;
            this.cap = cap;
            this.remaining.set(cap + 1);
        }

        public String toString() {
            return S.toString(EntriesBuffer.class, (Object)this);
        }

        void markFlushed(boolean success) {
            assert (this.flushed.getCount() == 1L);
            this.flushSucceeded = success;
            this.flushed.countDown();
        }

        private void checkNotFailedFlush() throws IOException {
            if (this.flushed.getCount() == 0L) {
                this.checkFlushSucceeded();
            }
        }

        private void checkFlushSucceeded() throws IOException {
            if (!this.flushSucceeded) {
                throw new IOException("Flush failed in another thread.");
            }
        }

        void awaitFlushed() throws IOException, IgniteInterruptedCheckedException {
            U.await((CountDownLatch)this.flushed);
            this.checkFlushSucceeded();
        }

        boolean awaitFlushed(long micros) throws IgniteInterruptedCheckedException, IOException {
            boolean res = U.await((CountDownLatch)this.flushed, (long)micros, (TimeUnit)TimeUnit.MICROSECONDS);
            if (!res) {
                return false;
            }
            this.checkFlushSucceeded();
            return true;
        }

        int size() {
            return this.cap - this.remaining();
        }

        int remaining() {
            return Math.abs(this.remaining.get()) - 1;
        }

        private boolean tryAcquire(int len) {
            int r;
            do {
                if ((r = this.remaining.get()) > len) continue;
                return false;
            } while (!this.remaining.compareAndSet(r, r - len));
            return true;
        }

        @Nullable
        AbstractFileEntry find(long pos) {
            AbstractFileEntry e = this.head.get();
            while (e != null) {
                if (e.type() == EntryType.COMPOUND) {
                    AbstractFileEntry e0 = ((CompoundEntry)e).find(pos);
                    if (e0 != null) {
                        return e0;
                    }
                } else if (e.pos == pos) {
                    return e;
                }
                if (e.pos < pos) break;
                e = e.prev;
            }
            return null;
        }

        boolean add(AbstractFileEntry e) {
            AbstractFileEntry prev;
            if (!this.tryAcquire(e.len)) {
                return false;
            }
            do {
                e.position((prev = this.head.get()) == null ? this.bufPos : prev.pos + (long)prev.len);
                e.prev = prev;
            } while (!this.head.compareAndSet(prev, e));
            return true;
        }

        boolean isEmpty() {
            return this.remaining() == this.cap;
        }

        boolean flip() {
            int r;
            do {
                r = this.remaining.get();
                assert (r != 0);
                if (r >= 0) continue;
                return false;
            } while (!this.remaining.compareAndSet(r, -r));
            return true;
        }

        public void serializeTo(ByteBuffer buf) {
            assert (buf.position() == 0);
            AbstractFileEntry e = this.head.get();
            if (e == null) {
                return;
            }
            int pos = -1;
            do {
                buf.position((int)(e.pos - this.bufPos));
                e.serializeTo(buf);
                if (pos != -1) continue;
                pos = buf.position();
            } while ((e = e.prev) != null);
            buf.position(pos);
        }

        public int liveSize() {
            int res = 0;
            AbstractFileEntry e = this.head.get();
            while (e != null) {
                switch (e.type()) {
                    case REMOVE: {
                        break;
                    }
                    case COMPOUND: {
                        res += ((CompoundEntry)e).liveSize;
                        break;
                    }
                    default: {
                        res += e.len;
                    }
                }
                e = e.prev;
            }
            return res;
        }

        public void awaitAllArrived() {
            AbstractFileEntry e;
            if (this.isEmpty()) {
                return;
            }
            int r = this.remaining();
            while ((e = this.head.get()) == null || e.pos - this.bufPos + (long)e.len != (long)(this.cap - r)) {
            }
        }
    }

    static class RmvEntry
    extends AbstractFileEntry {
        static final int HEADER_SIZE = 34;
        private final long xid;
        private final byte[] key;
        private final int keyHash;
        private final long fileIdx;
        private final long compactIdx;

        protected RmvEntry(long xid, byte[] key, int keyHash, long fileIdx, long compactIdx) {
            super(34 + key.length);
            this.xid = xid;
            this.key = key;
            this.keyHash = keyHash;
            this.fileIdx = fileIdx;
            this.compactIdx = compactIdx;
        }

        public String toString() {
            return S.toString(RmvEntry.class, (Object)this);
        }

        private void writeHeader(ByteBuffer buf) {
            buf.putShort(this.type().magic);
            buf.putInt(this.key.length);
            buf.putInt(this.keyHash);
            buf.putLong(this.xid);
            buf.putLong(this.fileIdx);
            buf.putLong(this.compactIdx);
        }

        @Override
        public void serializeTo(ByteBuffer buf) {
            int pos = buf.position();
            this.writeHeader(buf);
            buf.put(this.key);
            assert (buf.position() - pos == this.len);
        }

        @Override
        EntryType type() {
            return EntryType.REMOVE;
        }

        @Override
        int serializeTo(ByteBuffer buf, int off) {
            int remainingKey;
            assert (off == 0 || off >= 34);
            if (off == 0) {
                if (buf.remaining() < 34) {
                    return 0;
                }
                this.writeHeader(buf);
                if (buf.remaining() == 0) {
                    return 34;
                }
            } else {
                off -= 34;
            }
            if ((remainingKey = this.key.length - off) < buf.remaining()) {
                buf.put(this.key, off, remainingKey);
                return this.len;
            }
            int r = buf.remaining();
            buf.put(this.key, off, r);
            return off + 34 + r;
        }
    }

    static class PutEntry
    extends AbstractFileEntry
    implements DataEntry {
        static final int HEADER_SIZE = 26;
        private final long xid;
        private final byte[] key;
        private final byte[] val;
        private final int keyHash;
        private final int valHash;

        PutEntry(byte[] key, int keyHash, byte[] val, long xid, boolean checksum) {
            super(26 + key.length + val.length);
            this.xid = xid;
            this.key = key;
            this.val = val;
            this.keyHash = keyHash;
            this.valHash = checksum ? Arrays.hashCode(val) : 0;
        }

        @Override
        public int keyHash() {
            return this.keyHash;
        }

        private void writeHeader(ByteBuffer buf) {
            buf.putShort(this.type().magic);
            buf.putInt(this.key.length);
            buf.putInt(this.val.length);
            buf.putInt(this.keyHash);
            buf.putInt(this.valHash);
            buf.putLong(this.xid);
        }

        @Override
        public void serializeTo(ByteBuffer buf) {
            int pos = buf.position();
            this.writeHeader(buf);
            buf.put(this.key);
            buf.put(this.val);
            assert (buf.position() - pos == this.len);
        }

        @Override
        EntryType type() {
            return EntryType.PUT;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int serializeTo(ByteBuffer buf, int off) {
            assert (off == 0 || off >= 26) : off;
            if (off == 0) {
                if (buf.remaining() < 26) {
                    return 0;
                }
                this.writeHeader(buf);
                if (buf.remaining() == 0) {
                    return 26;
                }
            } else {
                off -= 26;
            }
            if (off < this.key.length) {
                int remainingKey = this.key.length - off;
                if (remainingKey >= buf.remaining()) {
                    int r = buf.remaining();
                    buf.put(this.key, off, r);
                    return off + 26 + r;
                }
                buf.put(this.key, off, remainingKey);
                off = 0;
            } else {
                off -= this.key.length;
            }
            if (this.val == null) {
                return this.len;
            }
            assert (off <= this.val.length && off >= 0) : off + " " + this.val.length;
            int remainingVal = this.val.length - off;
            if (remainingVal < buf.remaining()) {
                buf.put(this.val, off, remainingVal);
                return this.len;
            }
            int r = buf.remaining();
            buf.put(this.val, off, r);
            return off + 26 + this.key.length + r;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public byte[] key() {
            return this.key;
        }

        @Override
        @Nullable
        public byte[] value() {
            return this.val;
        }

        @Override
        public boolean keyEquals(byte[] key, int kHash) {
            return this.keyHash == kHash && Arrays.equals(this.key, key);
        }

        @Override
        public int size() {
            return this.len;
        }

        public String toString() {
            return S.toString(PutEntry.class, (Object)this, (String)"pos", (Object)this.position());
        }
    }

    private static class CommitEntry
    extends AbstractFileEntry {
        private final long xid;

        private CommitEntry(long xid) {
            super(10);
            this.xid = xid;
        }

        @Override
        void serializeTo(ByteBuffer buf) {
            buf.putShort(this.type().magic);
            buf.putLong(this.xid);
        }

        @Override
        EntryType type() {
            return EntryType.COMMIT;
        }

        @Override
        int serializeTo(ByteBuffer buf, int off) {
            assert (off == 0) : off;
            if (buf.remaining() < this.len) {
                return 0;
            }
            this.serializeTo(buf);
            return this.len;
        }

        public String toString() {
            return S.toString(CommitEntry.class, (Object)this);
        }
    }

    private static class CompoundEntry
    extends AbstractFileEntry {
        private final List<AbstractFileEntry> entries;
        private int liveSize;

        CompoundEntry(int cap) {
            assert (cap > 0) : cap;
            this.entries = new ArrayList<AbstractFileEntry>(cap);
        }

        boolean isEmpty() {
            return this.entries.isEmpty();
        }

        @Override
        void position(long pos) {
            super.position(pos);
            assert (!this.isEmpty());
            AbstractFileEntry prev = this.entries.get(0);
            prev.position(pos);
            int len = this.entries.size();
            for (int i = 1; i < len; ++i) {
                AbstractFileEntry next = this.entries.get(i);
                next.position(prev.pos + (long)prev.len);
                prev = next;
            }
        }

        void add(AbstractFileEntry e) {
            assert (e.type() != EntryType.COMPOUND);
            if (e.type() != EntryType.REMOVE) {
                this.liveSize += e.len;
            }
            this.len += e.len;
            this.entries.add(e);
        }

        AbstractFileEntry find(long pos) {
            long pos0 = this.pos;
            int size = this.entries.size();
            for (int i = 0; i < size; ++i) {
                AbstractFileEntry e = this.entries.get(i);
                if (pos0 == pos) {
                    assert (e.type() == EntryType.PUT && e.pos == pos) : e;
                    return e;
                }
                if (pos0 > pos) {
                    return null;
                }
                pos0 += (long)e.len;
            }
            return null;
        }

        @Override
        void serializeTo(ByteBuffer buf) {
            int size = this.entries.size();
            for (int i = 0; i < size; ++i) {
                this.entries.get(i).serializeTo(buf);
            }
        }

        @Override
        EntryType type() {
            return EntryType.COMPOUND;
        }

        @Override
        int serializeTo(ByteBuffer buf, int off) {
            int off0 = off;
            int size = this.entries.size();
            for (int i = 0; i < size; ++i) {
                AbstractFileEntry e = this.entries.get(i);
                if (off0 > e.len) {
                    off0 -= e.len;
                    continue;
                }
                if (off0 == 0 && buf.remaining() >= e.len) {
                    e.serializeTo(buf);
                    off += e.len;
                    continue;
                }
                int off1 = e.serializeTo(buf, off0);
                off += off1 - off0;
                if (off1 != e.len) break;
                off0 = 0;
            }
            return off;
        }
    }

    private static abstract class AbstractFileEntry {
        protected long pos;
        protected int len;
        protected AbstractFileEntry prev;

        protected AbstractFileEntry(int len) {
            this.len = len;
        }

        protected AbstractFileEntry() {
        }

        void position(long pos) {
            this.pos = pos;
        }

        abstract void serializeTo(ByteBuffer var1);

        abstract EntryType type();

        abstract int serializeTo(ByteBuffer var1, int var2);
    }

    private static enum EntryType {
        PUT(-21302),
        REMOVE(1638),
        COMMIT(-1330),
        COMPOUND(-1286);

        private final short magic;

        private EntryType(short magic) {
            this.magic = magic;
        }
    }

    static interface DataEntry {
        public byte[] key() throws IgniteCheckedException;

        public int keyHash();

        @Nullable
        public byte[] value() throws IgniteCheckedException;

        public boolean keyEquals(byte[] var1, int var2) throws IgniteCheckedException;

        public long position();

        public int size();
    }

    class StoreFile
    implements Closeable,
    Comparable<StoreFile> {
        private final FileChannel writeCh;
        private volatile long fileSize;
        private final AtomicLong liveSize;
        private final FileChannel syncReadCh;
        private final AsynchronousFileChannel asyncReadCh;
        private volatile EntriesBuffer curBuf;
        private volatile EntriesBuffer flippedBuf;
        private final int idx;
        private final long fileIdx;
        private final long compactIdx;
        private final Path path;

        StoreFile(int idx, long fileIdx) throws IOException {
            this(idx, fileIdx, 0L);
            this.initEntriesBuffer();
        }

        void initEntriesBuffer() {
            assert (this.curBuf == null);
            this.curBuf = new EntriesBuffer(this.withFileId(this.fileSize), CacheFileLocalStoreFileManager.this.store.getWriteBufferSize());
        }

        StoreFile(int idx, long fileIdx, long compactIdx) throws IOException {
            this.idx = idx;
            this.fileIdx = fileIdx;
            this.compactIdx = compactIdx;
            this.path = CacheFileLocalStoreFileManager.this.dir.resolve(String.valueOf(fileIdx + "_" + compactIdx));
            if (CacheFileLocalStoreFileManager.this.log.isDebugEnabled()) {
                CacheFileLocalStoreFileManager.this.log.debug("CacheFileLocalStoreFileManager creates new store file [path=" + this.path + ", idx=" + idx + ", fileIdx=" + fileIdx + ", compactIdx=" + compactIdx + "]");
            }
            EnumSet<StandardOpenOption> writeOptions = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.APPEND);
            if (CacheFileLocalStoreFileManager.this.fsyncDelay == 0L) {
                writeOptions.add(StandardOpenOption.DSYNC);
            }
            this.writeCh = FileChannel.open(this.path, writeOptions, new FileAttribute[0]);
            this.asyncReadCh = AsynchronousFileChannel.open(this.path, StandardOpenOption.READ);
            this.syncReadCh = FileChannel.open(this.path, StandardOpenOption.READ);
            this.liveSize = new AtomicLong();
        }

        StoreFile(int idx, StoreFile from) throws IOException {
            this(idx, from.fileIdx, from.compactIdx + 1L);
        }

        StoreFile(int idx, Path path) throws IOException {
            this.idx = idx;
            this.path = path;
            String name = path.getFileName().toString();
            String[] res = name.split("_");
            this.fileIdx = Long.parseLong(res[0]);
            this.compactIdx = Long.parseLong(res[1]);
            if (CacheFileLocalStoreFileManager.this.log.isDebugEnabled()) {
                CacheFileLocalStoreFileManager.this.log.debug("CacheFileLocalStoreFileManager creates new store file from path [path=" + path + ", idx=" + idx + ", fileIdx=" + this.fileIdx + ", compactIdx=" + this.compactIdx + "]");
            }
            EnumSet<StandardOpenOption> writeOptions = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.READ);
            if (CacheFileLocalStoreFileManager.this.fsyncDelay == 0L) {
                writeOptions.add(StandardOpenOption.DSYNC);
            }
            this.writeCh = FileChannel.open(path, writeOptions, new FileAttribute[0]);
            this.asyncReadCh = AsynchronousFileChannel.open(path, StandardOpenOption.READ);
            this.syncReadCh = FileChannel.open(path, StandardOpenOption.READ);
            this.fileSize = this.writeCh.size();
            this.writeCh.position(this.fileSize);
            this.liveSize = new AtomicLong();
        }

        @Override
        public int compareTo(StoreFile o) {
            int res = Long.compare(this.fileIdx, o.fileIdx);
            if (res == 0) {
                res = Long.compare(this.compactIdx, o.compactIdx);
            }
            return res;
        }

        public String toString() {
            return this.path.getFileName() + "-" + this.idx + "=" + this.fileSize + "<>" + this.path.toFile().length();
        }

        void stopWriting() throws IgniteInterruptedCheckedException, IOException {
            assert (CacheFileLocalStoreFileManager.this.flushMux.availablePermits() == 0) : "flushMux must be acquired";
            while (true) {
                EntriesBuffer buf;
                if ((buf = this.curBuf) == null) {
                    CacheFileLocalStoreFileManager.this.flushMux.release();
                    break;
                }
                if (this.flush(buf, null, true)) break;
                try {
                    buf.awaitFlushed();
                }
                catch (IgniteInterruptedCheckedException ex) {
                    CacheFileLocalStoreFileManager.this.flushMux.release();
                    throw ex;
                }
            }
        }

        void delete() throws IOException {
            this.close();
            Files.delete(this.path);
        }

        @Override
        public void close() throws IOException {
            CacheFileLocalStoreFileManager.this.flushMux.acquireUninterruptibly();
            try {
                this.stopWriting();
            }
            catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                // empty catch block
            }
            U.close((AutoCloseable)this.writeCh, (IgniteLogger)CacheFileLocalStoreFileManager.this.log);
            U.close((AutoCloseable)this.asyncReadCh, (IgniteLogger)CacheFileLocalStoreFileManager.this.log);
            U.close((AutoCloseable)this.syncReadCh, (IgniteLogger)CacheFileLocalStoreFileManager.this.log);
        }

        private int read(ByteBuffer buf, long addr, boolean sync) throws IgniteCheckedException {
            if (sync) {
                return this.readSync(buf, addr);
            }
            int res = (Integer)U.get(this.asyncReadCh.read(buf, addr));
            if (res == -1) {
                throw new IgniteCheckedException("Failed to read data from: " + addr);
            }
            return res;
        }

        private int readSync(ByteBuffer buf, long addr) throws IgniteCheckedException {
            try {
                int res = this.syncReadCh.read(buf, addr);
                if (res == -1) {
                    throw new IgniteCheckedException("Failed to read data from: " + addr);
                }
                return res;
            }
            catch (IOException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        }

        @Nullable
        private DataEntry findInBuffer(EntriesBuffer buf, long addr) {
            if (buf != null && addr >= buf.bufPos) {
                assert (addr < buf.bufPos + (long)CacheFileLocalStoreFileManager.this.store.getWriteBufferSize()) : Long.toBinaryString(addr) + " " + Long.toBinaryString(this.idx) + " " + Long.toBinaryString(EntriesBuffer.access$3200(buf));
                return (DataEntry)((Object)buf.find(addr));
            }
            return null;
        }

        @Nullable
        DataEntry read(final long addr, final boolean sync) throws IgniteCheckedException {
            DataEntry res = this.findInBuffer(this.curBuf, addr);
            if (res != null) {
                assert (res.position() == addr) : res;
                return res;
            }
            res = this.findInBuffer(this.flippedBuf, addr);
            if (res != null) {
                assert (res.position() == addr) : res;
                return res;
            }
            final long addr0 = addr & 0x3FFFFFFFFFFFL;
            if (this.fileSize < addr0 + 26L) {
                throw new IgniteCheckedException("Failed to read entry, missing size: " + (addr0 + 26L - this.fileSize) + " file " + this);
            }
            final ByteBuffer buf = ByteBuffer.allocate(CacheFileLocalStoreFileManager.this.store.getReadBufferSize());
            while (buf.position() < 26) {
                this.read(buf, addr0 + (long)buf.position(), sync);
            }
            buf.flip();
            short magic = buf.getShort();
            if (magic != EntryType.PUT.magic) {
                throw new IgniteCheckedException("Magic is wrong: [magic=" + Integer.toHexString(magic) + ", file=" + this + "]");
            }
            final int keySize = buf.getInt();
            final int valSize = buf.getInt();
            final int keyHash = buf.getInt();
            final int valHash = buf.getInt();
            int entrySize = 26 + keySize + valSize;
            if (this.fileSize < addr0 + (long)entrySize) {
                throw new IgniteCheckedException("Failed to read entry, missing size: " + (addr0 + (long)entrySize - this.fileSize));
            }
            return new DataEntry(){
                private byte[] key;
                private byte[] val;

                @Override
                public int keyHash() {
                    return keyHash;
                }

                @Override
                public byte[] key() throws IgniteCheckedException {
                    if (this.key != null) {
                        return this.key;
                    }
                    assert (valSize != 0);
                    byte[] k = new byte[keySize];
                    buf.position(26);
                    int availKeyData = buf.limit() - 26;
                    if (availKeyData > keySize) {
                        availKeyData = keySize;
                    }
                    if (availKeyData > 0) {
                        buf.get(k, 0, availKeyData);
                    }
                    if (availKeyData < keySize) {
                        ByteBuffer keyBuf = ByteBuffer.wrap(k);
                        if (availKeyData > 0) {
                            keyBuf.position(availKeyData);
                        }
                        long keyOff = addr0 + 26L;
                        while (keyBuf.hasRemaining()) {
                            StoreFile.this.read(keyBuf, keyOff + (long)keyBuf.position(), sync);
                        }
                    }
                    this.key = k;
                    return k;
                }

                @Override
                @Nullable
                public byte[] value() throws IgniteCheckedException {
                    if (valSize == 0) {
                        return null;
                    }
                    if (this.val != null) {
                        return this.val;
                    }
                    byte[] v = new byte[valSize];
                    int availValData = buf.limit() - keySize - 26;
                    if (availValData > valSize) {
                        availValData = valSize;
                    }
                    if (availValData > 0) {
                        buf.position(26 + keySize);
                        buf.get(v, 0, availValData);
                    }
                    if (availValData < valSize) {
                        ByteBuffer valBuf = ByteBuffer.wrap(v);
                        if (availValData > 0) {
                            valBuf.position(availValData);
                        }
                        long valOff = addr0 + 26L + (long)keySize;
                        while (valBuf.hasRemaining()) {
                            StoreFile.this.read(valBuf, valOff + (long)valBuf.position(), sync);
                        }
                    }
                    if (CacheFileLocalStoreFileManager.this.store.isChecksum() && valHash != Arrays.hashCode(v)) {
                        throw new IgniteCheckedException("Value checksum mismatch.");
                    }
                    this.val = v;
                    return v;
                }

                @Override
                public boolean keyEquals(byte[] key, int kHash) throws IgniteCheckedException {
                    int i;
                    if (key.length != keySize || keyHash != kHash) {
                        return false;
                    }
                    if (this.key != null) {
                        return Arrays.equals(this.key, key);
                    }
                    int len = Math.min(buf.limit() - 26, key.length);
                    byte[] bytes = buf.array();
                    for (i = 0; i < len; ++i) {
                        if (bytes[i + 26] == key[i]) continue;
                        return false;
                    }
                    if (len < keySize) {
                        bytes = this.key();
                        for (i = len; i < keySize; ++i) {
                            if (bytes[i] == key[i]) continue;
                            return false;
                        }
                    }
                    return true;
                }

                @Override
                public long position() {
                    return addr;
                }

                @Override
                public int size() {
                    return 26 + keySize + valSize;
                }
            };
        }

        boolean needCompact() {
            long size = this.fileSize;
            return size >= CacheFileLocalStoreFileManager.this.store.getMinCompactSize() && (double)(size - this.liveSize.get()) / (double)size >= (double)CacheFileLocalStoreFileManager.this.store.getMaxSparsity();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean flush(EntriesBuffer buf, AbstractFileEntry extra, boolean stop) throws IOException {
            if (!buf.flip()) {
                return false;
            }
            int size = buf.size();
            int liveSize = 0;
            long newPos = buf.bufPos + (long)size;
            if (extra != null) {
                extra.position(newPos);
                newPos += (long)extra.len;
                size += extra.len;
                if (extra.type() != EntryType.REMOVE) {
                    liveSize += extra.len;
                }
            }
            boolean success = false;
            if (!stop) {
                CacheFileLocalStoreFileManager.this.flushMux.acquireUninterruptibly();
            }
            assert (CacheFileLocalStoreFileManager.this.flushMux.availablePermits() == 0) : stop;
            try {
                assert (this.fileSize == this.writeCh.size()) : this.fileSize + " " + this.writeCh.size();
                this.flippedBuf = buf;
                EntriesBuffer entriesBuffer = this.curBuf = stop ? null : new EntriesBuffer(newPos, CacheFileLocalStoreFileManager.this.store.getWriteBufferSize());
                if (size > 0) {
                    buf.awaitAllArrived();
                    this.liveSize.addAndGet(liveSize += buf.liveSize());
                    this.fileSize += (long)size;
                    CacheFileLocalStoreFileManager.this.writeBuf.clear();
                    buf.serializeTo(CacheFileLocalStoreFileManager.this.writeBuf);
                    assert (CacheFileLocalStoreFileManager.this.writeBuf.position() == buf.size()) : CacheFileLocalStoreFileManager.access$3300(CacheFileLocalStoreFileManager.this) + " " + buf;
                    int off = 0;
                    if (extra != null) {
                        off = extra.serializeTo(CacheFileLocalStoreFileManager.this.writeBuf, off);
                    }
                    int done = 0;
                    CacheFileLocalStoreFileManager.this.writeBuf.flip();
                    done += this.writeCh.write(CacheFileLocalStoreFileManager.this.writeBuf);
                    if (extra != null) {
                        while (off != extra.len) {
                            CacheFileLocalStoreFileManager.this.writeBuf.compact();
                            off = extra.serializeTo(CacheFileLocalStoreFileManager.this.writeBuf, off);
                            CacheFileLocalStoreFileManager.this.writeBuf.flip();
                            done += this.writeCh.write(CacheFileLocalStoreFileManager.this.writeBuf);
                        }
                    }
                    while (CacheFileLocalStoreFileManager.this.writeBuf.remaining() != 0) {
                        done += this.writeCh.write(CacheFileLocalStoreFileManager.this.writeBuf);
                    }
                    assert (done == size) : done + " " + size;
                }
                assert (this.fileSize == this.writeCh.size()) : this.fileSize + " " + this.writeCh.size();
                success = true;
            }
            finally {
                CacheFileLocalStoreFileManager.this.flushMux.release();
                buf.markFlushed(success);
                this.flippedBuf = null;
            }
            return true;
        }

        private boolean needFlush(EntriesBuffer buf) throws IgniteInterruptedCheckedException, IOException {
            return CacheFileLocalStoreFileManager.this.store.getWriteMode() == CacheFileLocalStoreWriteMode.SYNC || CacheFileLocalStoreFileManager.this.store.getWriteMode() == CacheFileLocalStoreWriteMode.SYNC_BUFFERED && !buf.awaitFlushed(CacheFileLocalStoreFileManager.this.store.getWriteDelay());
        }

        long write(AbstractFileEntry e) throws IgniteCheckedException {
            try {
                while (true) {
                    EntriesBuffer buf;
                    if ((buf = this.curBuf) == null) {
                        throw new IgniteCheckedException("Failed to write to closed file.");
                    }
                    buf.checkNotFailedFlush();
                    if (buf.add(e)) {
                        if (this.needFlush(buf) && !this.flush(buf, null, false)) {
                            buf.awaitFlushed();
                        }
                        return e.pos;
                    }
                    if (e.len >= CacheFileLocalStoreFileManager.this.store.getWriteBufferSize()) {
                        if (!this.flush(buf, e, false)) continue;
                        return e.pos;
                    }
                    this.flush(buf, null, false);
                }
            }
            catch (IOException ex) {
                throw new IgniteCheckedException((Throwable)ex);
            }
        }

        private long withFileId(long addr) {
            assert (addr >>> 46 == 0L);
            return (long)this.idx << 46 | addr;
        }

        public long tryFlush() {
            EntriesBuffer buf = this.curBuf;
            if (buf == null) {
                return 0L;
            }
            try {
                if (buf.isEmpty() || this.flush(buf, null, false)) {
                    return CacheFileLocalStoreFileManager.this.store.getWriteDelay();
                }
            }
            catch (IOException e) {
                throw new IgniteException((Throwable)e);
            }
            long t = U.microTime();
            return Math.max(buf.created + CacheFileLocalStoreFileManager.this.store.getWriteDelay() - t, 0L);
        }

        void fsync() {
            try {
                this.writeCh.force(false);
            }
            catch (IOException e) {
                CacheFileLocalStoreFileManager.this.log.error("Failed to fsync.", (Throwable)e);
            }
        }

        public long tryFsync(long lastFsync) {
            EntriesBuffer buf = this.curBuf;
            if (buf == null) {
                return 0L;
            }
            if (buf.created <= lastFsync) {
                return CacheFileLocalStoreFileManager.this.fsyncDelay;
            }
            long awaitToFsync = lastFsync + CacheFileLocalStoreFileManager.this.fsyncDelay - U.microTime();
            if (awaitToFsync <= 0L) {
                this.fsync();
                awaitToFsync = CacheFileLocalStoreFileManager.this.fsyncDelay;
            }
            return awaitToFsync;
        }

        public void decrementLiveSize(int size) {
            this.liveSize.addAndGet(-size);
        }

        public long waste() {
            return this.fileSize - this.liveSize.get();
        }
    }

    private static class Op {
        private DataEntry old;
        private boolean rmv;
        private int keyHash;
        private long addr;
        private int size;

        private Op() {
        }
    }
}

