/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist.distributed;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.cache.dr.CacheDrPauseReason;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrStateTransferKey;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrControlTask;
import org.gridgain.grid.internal.processors.cache.dr.ist.StateTransferFuture;
import org.gridgain.grid.internal.processors.cache.dr.ist.StateTransferInfo;
import org.gridgain.grid.internal.processors.cache.dr.ist.distributed.DistributedDrStateManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.distributed.DistributedStateTransferManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IgniteExperimental
public class MetastoreDrStateManager
implements DistributedStateTransferManager,
DistributedDrStateManager {
    public static final String STATE_TRANSFER_KEY_PREFIX = "DR-FST-";
    public static final String DR_STATE_KEY_PREFIX = "DR-STATE-";
    public final String cacheStateTransferKey;
    public final String cacheDrStateKey;
    private final GridCacheContext cctx;
    private final IgniteLogger log;
    private final Consumer<DrControlTask> ctrlTaskExec;
    private final Executor exec;
    private final DistributedMetaStorage metaStore;
    private final ConcurrentMap<IgniteUuid, StateTransferFuture> stateTransferFuts = new ConcurrentHashMap<IgniteUuid, StateTransferFuture>();
    private DistributedDrStateManager.DrStateListener stateLsnr;
    private DistributedStateTransferManager.StateTransferListener stateTransferLsnr;
    private volatile boolean stopping;

    public MetastoreDrStateManager(GridCacheContext cctx, Consumer<DrControlTask> ctrlTaskExec, Executor exec) {
        this.cctx = cctx;
        this.ctrlTaskExec = ctrlTaskExec;
        this.exec = exec;
        this.metaStore = cctx.kernalContext().distributedMetastorage();
        this.log = cctx.logger(MetastoreDrStateManager.class);
        int cacheId = cctx.cacheId();
        this.cacheStateTransferKey = this.stateTransferMetaKey(cacheId);
        this.cacheDrStateKey = MetastoreDrStateManager.cacheDrStateMetaKey(cacheId);
    }

    @NotNull
    public String stateTransferMetaKey(int cacheId) {
        return STATE_TRANSFER_KEY_PREFIX + U.hexInt((int)cacheId);
    }

    @NotNull
    public static String cacheDrStateMetaKey(int cacheId) {
        return DR_STATE_KEY_PREFIX + U.hexInt((int)cacheId);
    }

    @Override
    public void listen(DistributedDrStateManager.DrStateListener evtLsnr) {
        this.stateLsnr = evtLsnr;
    }

    @Override
    public void listen(DistributedStateTransferManager.StateTransferListener evtLsnr) {
        this.stateTransferLsnr = evtLsnr;
    }

    @Override
    public void start() {
        this.metaStore.listen(s -> s.startsWith(this.cacheDrStateKey), this::onDrStatusReceived);
        this.metaStore.listen(s -> s.startsWith(this.cacheStateTransferKey), this::onStateTransferInfoReceived);
    }

    @Override
    public void stop() {
        this.stopping = true;
        this.stateTransferFuts.values().forEach(f -> f.onDone((Throwable)new CacheStoppedException("Cache has been stopped on node.")));
    }

    @Override
    public boolean init() throws IgniteCheckedException {
        return true;
    }

    private void onStateTransferInfoReceived(String key, @Nullable Serializable oldVal, @Nullable Serializable newVal) {
        StateTransferInfo newInfo = (StateTransferInfo)newVal;
        StateTransferInfo oldInfo = (StateTransferInfo)oldVal;
        if (this.log.isTraceEnabled()) {
            this.log.trace("DR state transfer state changed: cache=" + this.cctx.name() + ", oldInfo=" + oldInfo + ", newInfo=" + newInfo);
        }
        if (this.stateTransferLsnr != null) {
            this.executeOrdered(new StateTransferInfoChangedTask(oldInfo, newInfo, this.oldestNode()));
        }
        if (newInfo == null) {
            this.finishFuture(oldInfo, oldInfo.isFinished() ? null : CacheDrPauseReason.USER_REQUEST);
        }
    }

    private void onDrStatusReceived(String key, @Nullable Serializable oldVal, @Nullable Serializable newVal) {
        CacheDrPauseReason newInfo = (CacheDrPauseReason)((Object)newVal);
        if (this.log.isInfoEnabled()) {
            this.log.info("DR global state changed: cache=" + this.cctx.name() + ", state=" + newVal);
        }
        if (this.stateLsnr != null) {
            this.executeOrdered(() -> this.stateLsnr.onGlobalDrStatusChanged(newInfo));
        }
    }

    public IgniteInternalFuture<StateTransferFuture> startStateTransfer(Collection<Byte> targetDCs) throws IgniteCheckedException {
        GridFutureAdapter fut = new GridFutureAdapter();
        StateTransferInfo info = new StateTransferInfo(new CacheDrStateTransferKey(this.cctx.name(), IgniteUuid.fromUuid((UUID)this.cctx.localNodeId()), targetDCs), this.cctx.cacheId(), this.cctx.topology().partitions(), System.currentTimeMillis(), null);
        info.pendingParts().set(0, this.cctx.topology().partitions());
        this.executeOrdered(new StartStateTransferTask(fut, info));
        return fut;
    }

    @Override
    public IgniteInternalFuture<? extends IgniteInternalFuture<?>> incrementalStateTransfer(long snapshotId, Collection<Byte> targetDCs) throws IgniteCheckedException {
        throw new UnsupportedOperationException("Incremental state transfer is not supported.");
    }

    @Override
    public IgniteInternalFuture<?> stopStateTransfer(CacheDrStateTransferKey fstKey, @Nullable String failureReason) throws IgniteCheckedException {
        StateTransferInfo info = (StateTransferInfo)this.metaStore.read(this.cacheStateTransferKey);
        if (info == null) {
            return new GridFinishedFuture();
        }
        GridFutureAdapter fut = new GridFutureAdapter();
        this.executeOrdered(new StopStateTransferTask(fut, info));
        return fut;
    }

    @Override
    public void destroyState(String cacheName) {
        if (this.oldestNode()) {
            try {
                ArrayList keys = new ArrayList();
                this.metaStore.iterate(this.cacheStateTransferKey, (k, val) -> keys.add(k));
                this.metaStore.iterate(this.cacheDrStateKey, (k, val) -> keys.add(k));
                for (String k2 : keys) {
                    this.metaStore.remove(k2);
                }
            }
            catch (Exception ex) {
                this.log.error("Failed to remove stale state transfer info from metastore: cacheId=" + this.cctx.cacheId());
            }
        }
    }

    @Override
    public List<StateTransferInfo> activeStateTransfers() {
        try {
            ArrayList<StateTransferInfo> res = new ArrayList<StateTransferInfo>();
            this.metaStore.iterate(this.cacheStateTransferKey, (k, v) -> {
                StateTransferInfo fstInfo = (StateTransferInfo)v;
                if (!fstInfo.isFinished()) {
                    res.add(fstInfo);
                }
            });
            return res;
        }
        catch (IgniteCheckedException ex) {
            this.log.error("Failed to read list of active state transfer: cache=" + this.cctx.cacheId());
            throw new IgniteException((Throwable)ex);
        }
    }

    @Override
    public void markPartitionTransferred(CacheDrStateTransferKey fstKey, int part) {
        try {
            StateTransferInfo fstInfo = (StateTransferInfo)this.metaStore.read(this.cacheStateTransferKey);
            if (fstInfo == null) {
                return;
            }
            this.executeAsync(new MarkPartitionTransferred(fstInfo, part));
        }
        catch (IgniteCheckedException ex) {
            this.log.error("Failed to update state transfer info in metastore: cache=" + this.cctx.cacheId() + ", fstId=" + fstKey.id());
        }
    }

    @Override
    public IgniteInternalFuture<?> changeState(CacheDrPauseReason drState) {
        GridFutureAdapter fut = new GridFutureAdapter();
        this.executeOrdered(new DrStatusChangeTask((GridFutureAdapter<StateTransferFuture>)fut, drState));
        return fut;
    }

    private void finishFuture(StateTransferInfo info, CacheDrPauseReason reason) {
        GridFutureAdapter fut = (GridFutureAdapter)this.stateTransferFuts.remove(info.fstId());
        if (fut != null) {
            assert (info != null);
            if (info.isFinished()) {
                fut.onDone();
            } else {
                fut.onDone((Throwable)new IgniteFutureCancelledCheckedException("State transfer cancelled: reason=" + (Object)((Object)reason) + '.'));
            }
        }
    }

    private boolean oldestNode() {
        Collection cacheNodes = CU.affinityNodes((GridCacheContext)this.cctx, (AffinityTopologyVersion)AffinityTopologyVersion.NONE);
        return F.eq((Object)this.cctx.localNode(), (Object)CU.oldest((Collection)cacheNodes));
    }

    private void executeOrdered(DrControlTask task) {
        this.ctrlTaskExec.accept(task);
    }

    private void executeAsync(Runnable task) {
        this.exec.execute(task);
    }

    private class DrStatusChangeTask
    implements DrControlTask {
        private final GridFutureAdapter<StateTransferFuture> resFut;
        private final String metaKey;
        private final CacheDrPauseReason reason;

        public DrStatusChangeTask(GridFutureAdapter<StateTransferFuture> resFut, CacheDrPauseReason reason) {
            this.resFut = resFut;
            this.metaKey = MetastoreDrStateManager.this.cacheDrStateKey;
            this.reason = reason;
        }

        @Override
        public void run() throws Exception {
            try {
                if (this.reason == null) {
                    MetastoreDrStateManager.this.metaStore.remove(this.metaKey);
                } else {
                    MetastoreDrStateManager.this.metaStore.write(this.metaKey, (Serializable)((Object)this.reason));
                }
                this.resFut.onDone();
            }
            catch (IgniteCheckedException ex) {
                this.resFut.onDone((Throwable)ex);
                throw new IgniteException((Throwable)ex);
            }
        }

        @Override
        public void onError(@Nullable Throwable err) {
            this.resFut.onDone(err);
            if (MetastoreDrStateManager.this.stopping) {
                return;
            }
            if (this.reason == null) {
                MetastoreDrStateManager.this.log.error("Failed to start incremental DR.", err);
            } else {
                MetastoreDrStateManager.this.log.error("Failed to stop incremental DR: reason=" + (Object)((Object)this.reason), err);
            }
        }
    }

    private class StateTransferInfoChangedTask
    implements DrControlTask {
        private final StateTransferInfo oldInfo;
        private final StateTransferInfo newInfo;
        private final String metaKey;
        private final boolean isCrd;

        public StateTransferInfoChangedTask(StateTransferInfo oldInfo, StateTransferInfo newInfo, boolean isCrd) {
            this.oldInfo = oldInfo;
            this.newInfo = newInfo;
            this.isCrd = isCrd;
            this.metaKey = MetastoreDrStateManager.this.cacheStateTransferKey;
        }

        @Override
        public void run() throws Exception {
            if (this.oldInfo == null && this.newInfo == null) {
                return;
            }
            MetastoreDrStateManager.this.stateTransferLsnr.onStateTransferInfoChanged(this.oldInfo, this.newInfo);
            if (this.newInfo.isFinished() && this.isCrd) {
                StateTransferInfo val;
                do {
                    if ((val = (StateTransferInfo)MetastoreDrStateManager.this.metaStore.read(this.metaKey)) != null && val.fstId().equals((Object)this.newInfo.fstId())) continue;
                    return;
                } while (!MetastoreDrStateManager.this.metaStore.compareAndRemove(this.metaKey, (Serializable)val));
                return;
            }
        }

        @Override
        public void onError(@Nullable Throwable err) {
            if (!MetastoreDrStateManager.this.stopping) {
                MetastoreDrStateManager.this.log.warning("Failed to process state transfer update: oldInfo=" + this.oldInfo + ", newInfo=" + this.newInfo, err);
            }
        }
    }

    class StopStateTransferTask
    implements DrControlTask {
        private final GridFutureAdapter<Void> resFut;
        private final String metaKey;
        private final IgniteUuid fstId;

        private StopStateTransferTask(GridFutureAdapter<Void> fut, StateTransferInfo info) {
            this.resFut = fut;
            this.metaKey = MetastoreDrStateManager.this.cacheStateTransferKey;
            this.fstId = info.fstId();
        }

        @Override
        public void run() throws Exception {
            StateTransferInfo val = (StateTransferInfo)MetastoreDrStateManager.this.metaStore.read(this.metaKey);
            if (val == null || !val.fstId().equals((Object)this.fstId)) {
                this.resFut.onDone();
                return;
            }
            if (!MetastoreDrStateManager.this.metaStore.compareAndRemove(this.metaKey, (Serializable)val)) {
                if (MetastoreDrStateManager.this.log.isDebugEnabled()) {
                    MetastoreDrStateManager.this.log.debug("Failed to stop state transfer, will retry: cache=" + MetastoreDrStateManager.this.cctx.cacheId() + ", fstId=" + this.fstId);
                }
                MetastoreDrStateManager.this.executeOrdered(this);
            } else if (this.resFut.onDone()) {
                MetastoreDrStateManager.this.log.info("State transfer has been cancelled: cache=" + MetastoreDrStateManager.this.cctx.cacheId() + ", info=" + val);
            }
        }

        @Override
        public void onError(@Nullable Throwable err) {
            this.resFut.onDone(err);
            MetastoreDrStateManager.this.log.warning("Failed to clear stale state transfer state: cache=" + MetastoreDrStateManager.this.cctx.cacheId() + ", fstId=" + this.fstId + ", stopping=" + MetastoreDrStateManager.this.stopping);
        }
    }

    class StartStateTransferTask
    implements DrControlTask {
        private final GridFutureAdapter<StateTransferFuture> resFut;
        private final String metaKey;
        private final StateTransferInfo info;

        private StartStateTransferTask(GridFutureAdapter<StateTransferFuture> fut, StateTransferInfo info) {
            this.resFut = fut;
            this.metaKey = MetastoreDrStateManager.this.cacheStateTransferKey;
            this.info = info;
        }

        @Override
        @Nullable
        public void run() throws Exception {
            CacheDrPauseReason stopReason = (CacheDrPauseReason)((Object)MetastoreDrStateManager.this.metaStore.read(MetastoreDrStateManager.this.cacheDrStateKey));
            if (stopReason != null) {
                throw new IllegalStateException("State transfer was not started due to date center replication is stopped: cache=" + MetastoreDrStateManager.this.cctx.name() + ", reason=" + (Object)((Object)stopReason) + '.');
            }
            StateTransferInfo oldVal = (StateTransferInfo)MetastoreDrStateManager.this.metaStore.read(this.metaKey);
            if (oldVal != null) {
                if (!Arrays.equals(oldVal.targetDcBits(), this.info.targetDcBits())) {
                    this.resFut.onDone((Throwable)new IllegalStateException("Multiple state transfers are not supported."));
                }
                if (MetastoreDrStateManager.this.log.isInfoEnabled()) {
                    MetastoreDrStateManager.this.log.info("State transfer future attached to task: cache=" + MetastoreDrStateManager.this.cctx.cacheId() + ", fstId=" + oldVal.fstId() + '.');
                }
                this.onDone(oldVal.fstId());
                return;
            }
            GridFutureAdapter casFut = MetastoreDrStateManager.this.metaStore.compareAndSetAsync(this.metaKey, null, (Serializable)this.info);
            casFut.listen((IgniteInClosure & Serializable)fut -> {
                try {
                    if (((Boolean)fut.get()).booleanValue()) {
                        if (MetastoreDrStateManager.this.stateTransferLsnr != null && MetastoreDrStateManager.this.log.isInfoEnabled()) {
                            MetastoreDrStateManager.this.log.info("Started new state transfer: initiator=" + MetastoreDrStateManager.this.cctx.localNodeId() + ", info=" + this.info);
                        }
                        this.onDone(this.info.fstId());
                    } else {
                        if (MetastoreDrStateManager.this.log.isDebugEnabled()) {
                            MetastoreDrStateManager.this.log.debug("State transfer start failed, will retry: info=" + this.info);
                        }
                        MetastoreDrStateManager.this.executeOrdered(this);
                    }
                }
                catch (Throwable ex) {
                    this.onError(ex);
                }
            });
        }

        private void onDone(IgniteUuid fstId) {
            StateTransferFuture transferFut = MetastoreDrStateManager.this.stateTransferFuts.computeIfAbsent(fstId, k -> new StateTransferFuture((IgniteUuid)k));
            this.resFut.onDone((Object)transferFut);
        }

        @Override
        public void onError(@Nullable Throwable err) {
            if (this.resFut.onDone(err) && !MetastoreDrStateManager.this.stopping) {
                MetastoreDrStateManager.this.log.warning("Failed to start state transfer: cache=" + MetastoreDrStateManager.this.cctx.cacheId() + ", info=" + this.info);
            }
        }
    }

    class MarkPartitionTransferred
    implements Runnable {
        private final String metaKey;
        private final IgniteUuid fstId;
        final int part;

        public MarkPartitionTransferred(StateTransferInfo info, int part) {
            this.part = part;
            this.metaKey = MetastoreDrStateManager.this.cacheStateTransferKey;
            this.fstId = info.fstId();
        }

        @Override
        public void run() {
            try {
                StateTransferInfo info = (StateTransferInfo)MetastoreDrStateManager.this.metaStore.read(this.metaKey);
                if (info == null || !info.fstId().equals((Object)this.fstId) || !info.needToSend(this.part)) {
                    return;
                }
                StateTransferInfo newInfo = new StateTransferInfo(info);
                newInfo.markDelivered(this.part);
                if (MetastoreDrStateManager.this.log.isTraceEnabled()) {
                    MetastoreDrStateManager.this.log.debug("Marking partition as delivered: fstID=" + this.fstId + ", part=" + this.part);
                }
                GridFutureAdapter casFut = MetastoreDrStateManager.this.metaStore.compareAndSetAsync(this.metaKey, (Serializable)info, (Serializable)newInfo);
                casFut.listen((IgniteInClosure & Serializable)fut -> {
                    try {
                        if (((Boolean)fut.get()).booleanValue()) {
                            if (MetastoreDrStateManager.this.log.isInfoEnabled()) {
                                MetastoreDrStateManager.this.log.info("Partition transferred: fstID=" + this.fstId + ", part=" + this.part);
                            }
                            return;
                        }
                        if (MetastoreDrStateManager.this.log.isDebugEnabled()) {
                            MetastoreDrStateManager.this.log.debug("Failed to update state transfer status, will retry: cache=" + MetastoreDrStateManager.this.cctx.cacheId() + ", " + info.toString());
                        }
                        MetastoreDrStateManager.this.executeAsync(this);
                    }
                    catch (Throwable ex) {
                        this.onError(ex);
                    }
                });
            }
            catch (Throwable ex) {
                this.onError(ex);
            }
        }

        private void onError(@Nullable Throwable err) {
            MetastoreDrStateManager.this.log.error("Failed to update state transfer status: fstId=" + this.fstId + ", cacheId=" + MetastoreDrStateManager.this.cctx.cacheId(), err);
        }
    }
}

