/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.GridGainCacheIncrementalDrManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.PartitionCounterInfo;
import org.gridgain.grid.internal.processors.dr.DrUtils;

public class DrCollectDrLwmCountersJob
implements IgniteCallable<Collection<PartitionCounterInfo>> {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    private IgniteEx ignite;
    private String cacheName;

    public DrCollectDrLwmCountersJob(String cacheName) {
        this.cacheName = cacheName;
    }

    public Collection<PartitionCounterInfo> call() throws Exception {
        assert (DrUtils.isIncrementalDrEnabled());
        GridKernalContext ctx = this.ignite.context();
        GridCacheProcessor cacheProc = ctx.cache();
        IgniteInternalCache cache = this.ignite.cachex(this.cacheName);
        assert (cache != null);
        CacheGroupContext grpCtx = cache.context().group();
        assert (grpCtx != null);
        CacheDrManager drManager = DrUtils.dr(ctx, cacheProc, this.cacheName);
        assert (drManager instanceof GridGainCacheIncrementalDrManager);
        GridGainCacheIncrementalDrManager drMgr = (GridGainCacheIncrementalDrManager)drManager;
        List locParts = grpCtx.topology().localPartitions();
        return locParts.stream().filter(part -> part.state() == GridDhtPartitionState.OWNING).map(part -> new PartitionCounterInfo(part.id(), drMgr.lwmOrDefault(part.id(), Long.MIN_VALUE))).filter(part -> part.counter() != Long.MIN_VALUE).collect(Collectors.toList());
    }
}

