/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.jetbrains.annotations.Nullable;

class MissingReadOnlySnapshotPath
implements SnapshotPath {
    private final SnapshotPath parent;
    private final String name;

    MissingReadOnlySnapshotPath(SnapshotPath parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException("delete");
    }

    @Override
    public void deleteIfEmpty() throws IOException {
        throw new UnsupportedOperationException("deleteIfEmpty");
    }

    @Override
    public void createNewFile() throws IOException {
        throw new UnsupportedOperationException("createNewFile");
    }

    @Override
    public SnapshotPath getParent() {
        return this.parent;
    }

    @Override
    public boolean createDirectories() {
        throw new UnsupportedOperationException("createDirectories");
    }

    @Override
    public SnapshotPath resolve(String name) {
        return new MissingReadOnlySnapshotPath(this, name);
    }

    @Override
    @Nullable
    public SnapshotPath resolveRegularOrCompressed(String name) {
        return null;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isEmptyDirectory() {
        return false;
    }

    @Override
    public SnapshotPath resolveSibling(String fileName) {
        return this.parent.resolve(fileName);
    }

    @Override
    public OutputStream outputStream() throws FileNotFoundException {
        throw new FileNotFoundException(this.getAbsolutePath());
    }

    @Override
    public InputStream inputStream() throws FileNotFoundException {
        throw new FileNotFoundException(this.getAbsolutePath());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAbsolutePath() {
        String parentAbsolutePath = this.parent.getAbsolutePath();
        if (!parentAbsolutePath.endsWith("/")) {
            parentAbsolutePath = parentAbsolutePath + "/";
        }
        return parentAbsolutePath + this.name;
    }

    @Override
    public Collection<SnapshotPath> getEntries() {
        return Collections.emptyList();
    }

    @Override
    public void sync() {
    }

    @Override
    public void copyFrom(Path file) throws IOException {
        throw new IOException(this.getAbsolutePath() + " does not exist");
    }
}

