/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.gridgain.grid.persistentstore.SnapshotOperationType;

public class SnapshotOperationInfoImpl
implements SnapshotOperationInfo {
    private static final long serialVersionUID = 0L;
    private final GridSnapshotOperationEx snapshotOperation;
    private IgniteUuid operationId;
    private final UUID initiatorNode;
    private final AffinityTopologyVersion topVer;
    private final Collection<ClusterNode> clusterNodes;
    private final Map<Object, Map<String, String>> snapshotAttrs;

    public SnapshotOperationInfoImpl(IgniteUuid operationId, GridSnapshotOperationEx snapshotOperation, UUID initiatorNode, AffinityTopologyVersion topVer, Collection<ClusterNode> nodes) {
        this(operationId, snapshotOperation, initiatorNode, topVer, nodes, null);
    }

    public SnapshotOperationInfoImpl(IgniteUuid operationId, GridSnapshotOperationEx snapshotOperation, UUID initiatorNode, AffinityTopologyVersion topVer, Collection<ClusterNode> nodes, Map<Object, Map<String, String>> snapshotAttrs) {
        this.operationId = operationId;
        this.snapshotOperation = snapshotOperation;
        this.initiatorNode = initiatorNode;
        this.topVer = topVer;
        this.clusterNodes = nodes;
        this.snapshotAttrs = snapshotAttrs;
    }

    @Override
    public IgniteUuid operationId() {
        return this.operationId;
    }

    @Override
    public SnapshotOperationType operationType() {
        return this.snapshotOperation.type();
    }

    @Override
    public long snapshotId() {
        return this.snapshotOperation.snapshotId();
    }

    @Override
    public String message() {
        return this.snapshotOperation.message();
    }

    @Override
    public Set<String> cacheNames() {
        return this.snapshotOperation.cacheNames();
    }

    @Override
    public UUID initiatorNodeId() {
        return this.initiatorNode;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public Collection<ClusterNode> clusterNodes() {
        return this.clusterNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotOperationInfoImpl info = (SnapshotOperationInfoImpl)o;
        return this.snapshotOperation.snapshotId() == info.snapshotOperation.snapshotId();
    }

    @Override
    public Map<Object, Map<String, String>> snapshotAttributes() {
        return this.snapshotAttrs;
    }

    public GridSnapshotOperationEx snapshotOperation() {
        return this.snapshotOperation;
    }

    public int hashCode() {
        return (int)(this.snapshotOperation.snapshotId() ^ this.snapshotOperation.snapshotId() >>> 32);
    }

    public String toString() {
        return S.toString(SnapshotOperationInfoImpl.class, (Object)this);
    }
}

