/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.LatestSnapshotMismatchHandlingPolicy;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.jetbrains.annotations.Nullable;

public class SnapshotCreateParameters
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final int DEFAULT_WRITE_THROTTLING_THRESHOLD = 0;
    private CompressionOption compressionOption = CompressionOption.NONE;
    private int compressionLevel = -1;
    private int writeThrottlingThreshold = 0;
    private boolean exchangelessSnapshot;
    private String snapshotLabel;
    private boolean allCaches;
    private String encryptionMasterKeyName;
    private LatestSnapshotMismatchHandlingPolicy mismatchHandlingPlc = LatestSnapshotMismatchHandlingPolicy.DEFAULT;

    public SnapshotCreateParameters() {
        this.exchangelessSnapshot = IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true);
    }

    public SnapshotCreateParameters(CompressionOption compressionOption, int compressionLevel) {
        this(compressionOption, compressionLevel, 0);
    }

    public SnapshotCreateParameters(CompressionOption compressionOption, int compressionLevel, int writeThrottlingThreshold) {
        this(compressionOption, compressionLevel, writeThrottlingThreshold, IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true), null);
    }

    public SnapshotCreateParameters(CompressionOption compressionOption, int compressionLevel, int writeThrottlingThreshold, boolean exchangelessSnapshot) {
        this(compressionOption, compressionLevel, writeThrottlingThreshold, exchangelessSnapshot, null);
    }

    public SnapshotCreateParameters(CompressionOption compressionOption, int compressionLevel, int writeThrottlingThreshold, boolean exchangelessSnapshot, String snapshotLabel) {
        this(compressionOption, compressionLevel, writeThrottlingThreshold, exchangelessSnapshot, snapshotLabel, null);
    }

    public SnapshotCreateParameters(CompressionOption compressionOption, int compressionLevel, int writeThrottlingThreshold, boolean exchangelessSnapshot, String snapshotLabel, String encryptionMasterKeyName) {
        this(compressionOption, compressionLevel, writeThrottlingThreshold, exchangelessSnapshot, snapshotLabel, encryptionMasterKeyName, LatestSnapshotMismatchHandlingPolicy.DEFAULT);
    }

    public SnapshotCreateParameters(CompressionOption compressionOption, int compressionLevel, int writeThrottlingThreshold, boolean exchangelessSnapshot, String snapshotLabel, String encryptionMasterKeyName, LatestSnapshotMismatchHandlingPolicy mismatchHandlingPlc) {
        this.compressionOption = compressionOption;
        this.compressionLevel = compressionLevel;
        this.writeThrottlingThreshold = writeThrottlingThreshold;
        this.exchangelessSnapshot = exchangelessSnapshot;
        this.snapshotLabel = snapshotLabel;
        this.encryptionMasterKeyName = encryptionMasterKeyName;
        this.mismatchHandlingPlc = mismatchHandlingPlc;
    }

    public byte getProtocolVersion() {
        return 8;
    }

    public CompressionOption getCompressionOption() {
        return this.compressionOption;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getWriteThrottlingThreshold() {
        return this.writeThrottlingThreshold;
    }

    public boolean exchangelessSnapshot() {
        return this.exchangelessSnapshot;
    }

    public String getSnapshotLabel() {
        return this.snapshotLabel;
    }

    public boolean allCaches() {
        return this.allCaches;
    }

    public String encryptionMasterKeyName() {
        return this.encryptionMasterKeyName;
    }

    public LatestSnapshotMismatchHandlingPolicy getMismatchHandlingPlc() {
        return this.mismatchHandlingPlc;
    }

    public void exchangelessSnapshot(boolean exchangelessSnapshot) {
        this.exchangelessSnapshot = exchangelessSnapshot;
    }

    public void allCaches(boolean allCaches) {
        this.allCaches = allCaches;
    }

    @Nullable
    public static SnapshotCreateParameters convertSnapshotCreateParams(@Nullable SnapshotCreateParams snapshotCreateParams) {
        return snapshotCreateParams == null ? null : new SnapshotCreateParameters(snapshotCreateParams.snapshotCompressionOption(), snapshotCreateParams.compressionLevel(), snapshotCreateParams.writeThrottlingThreshold(), snapshotCreateParams.exchangelessSnapshot(), snapshotCreateParams.getSnapshotLabel(), snapshotCreateParams.tdeMasterKeyName(), LatestSnapshotMismatchHandlingPolicy.DEFAULT);
    }

    @Nullable
    public static SnapshotCreateParams convertSnapshotCreateParameters(@Nullable SnapshotCreateParameters snapshotCreateParameters) {
        return snapshotCreateParameters == null ? null : new SnapshotCreateParams(snapshotCreateParameters.getCompressionOption(), snapshotCreateParameters.getCompressionLevel(), snapshotCreateParameters.getWriteThrottlingThreshold(), snapshotCreateParameters.exchangelessSnapshot(), snapshotCreateParameters.getSnapshotLabel(), snapshotCreateParameters.encryptionMasterKeyName());
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum((DataOutput)out, (Enum)this.compressionOption);
        out.writeByte(this.compressionLevel);
        out.writeInt(this.writeThrottlingThreshold);
        out.writeBoolean(this.exchangelessSnapshot);
        out.writeObject(this.snapshotLabel);
        out.writeBoolean(this.allCaches);
        U.writeString((DataOutput)out, (String)this.encryptionMasterKeyName);
        U.writeEnum((DataOutput)out, (Enum)this.mismatchHandlingPlc);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.compressionOption = CompressionOption.fromOrdinal(in.readByte());
        if (protoVer > 1) {
            this.compressionLevel = in.readByte();
        }
        if (protoVer > 2) {
            this.writeThrottlingThreshold = in.readInt();
        }
        boolean bl = this.exchangelessSnapshot = protoVer > 3 && in.readBoolean();
        if (protoVer > 4) {
            this.snapshotLabel = (String)in.readObject();
        }
        if (protoVer > 5) {
            this.allCaches = in.readBoolean();
        }
        if (protoVer > 6) {
            this.encryptionMasterKeyName = U.readString((DataInput)in);
        }
        if (protoVer > 7) {
            this.mismatchHandlingPlc = (LatestSnapshotMismatchHandlingPolicy)U.readEnum((DataInput)in, LatestSnapshotMismatchHandlingPolicy.class);
        }
    }

    public String toString() {
        return S.toString(SnapshotCreateParameters.class, (Object)((Object)this));
    }
}

