/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;

public class FutureTaskQueue<T> {
    private static final long AWAIT_QUEUE_TIMEOUT = 500L;
    private final Queue<T> taskQueue = new ConcurrentLinkedQueue<T>();
    private final Queue<Future<?>> futureQueue = new ConcurrentLinkedQueue();
    private final ExecutorService executorService;
    private final IgniteLogger logger;
    private volatile Function<T, Runnable> taskProcessor;

    public FutureTaskQueue(ExecutorService executorService, IgniteLogger logger) {
        this.executorService = executorService;
        this.logger = logger;
    }

    public void setTaskProcessor(Function<T, Runnable> taskProcessor) {
        this.taskProcessor = taskProcessor;
    }

    public void addPendingTask(T t) {
        this.taskQueue.add(t);
    }

    public void submitTask(T t) {
        Runnable runnable = this.taskProcessor.apply(t);
        if (runnable != null) {
            this.futureQueue.add(this.executorService.submit(runnable));
        }
    }

    public int size() {
        return this.futureQueue.size();
    }

    public void submitPendingTasks() {
        T task;
        while ((task = this.taskQueue.poll()) != null) {
            Runnable runnable = this.taskProcessor.apply(task);
            if (runnable == null) continue;
            this.futureQueue.add(this.executorService.submit(runnable));
        }
    }

    public void submit(Runnable run) {
        this.futureQueue.add(this.executorService.submit(run));
    }

    public void awaitCompletionWithShutdown(SnapshotOperationContext snapshotOperationContext, boolean needToTrack) throws IgniteCheckedException {
        this.executorService.shutdown();
        int totalSize = this.futureQueue.size();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Await completion of all pending futures, size=" + totalSize);
        }
        try {
            while (!this.executorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                int completed = 0;
                if (snapshotOperationContext.isCancelled()) {
                    throw new IgniteCheckedException("Snapshot operation has been cancelled");
                }
                if (!needToTrack) continue;
                for (Future future : this.futureQueue) {
                    if (!future.isDone()) continue;
                    ++completed;
                }
                snapshotOperationContext.reportWork(completed);
            }
        }
        catch (InterruptedException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        for (Future future : this.futureQueue) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new IgniteCheckedException((Throwable)exception);
            }
        }
    }

    public void awaitCompletion(SnapshotOperationContext snapshotOperationContext) throws IgniteCheckedException {
        Future<?> future;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Await completion of all pending futures, size=" + this.futureQueue.size());
        }
        while ((future = this.futureQueue.poll()) != null) {
            while (!future.isDone()) {
                if (snapshotOperationContext.isCancelled()) {
                    throw new IgniteCheckedException("Snapshot operation has been cancelled");
                }
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(500L));
            }
            try {
                future.get();
            }
            catch (Exception e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        }
    }
}

