/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import org.jetbrains.annotations.Nullable;

public enum CompressionOption {
    NONE(0, 0, 0, ""),
    ZIP(1, 9, 1, ".zip"),
    ZSTD(1, 22, 1, ".zst"),
    LZ4(0, 17, 0, ".lz4"),
    SNAPPY(0, 0, 0, ".snappy");

    private final int minCompressionLevel;
    private final int maxCompressionLevel;
    private final int defaultCompressionLevel;
    private final String fileExtension;
    private static final CompressionOption[] VALUES;

    private CompressionOption(int minCompressionLevel, int maxCompressionLevel, int defaultCompressionLevel, String fileExtension) {
        this.minCompressionLevel = minCompressionLevel;
        this.maxCompressionLevel = maxCompressionLevel;
        this.defaultCompressionLevel = defaultCompressionLevel;
        this.fileExtension = fileExtension;
    }

    public boolean isCompressed() {
        return this != NONE;
    }

    public int minCompressionLevel() {
        return this.minCompressionLevel;
    }

    public int maxCompressionLevel() {
        return this.maxCompressionLevel;
    }

    public int defaultCompressionLevel() {
        return this.defaultCompressionLevel;
    }

    public String fileExtension() {
        return this.fileExtension;
    }

    public boolean isCompressionLvlValid(int level) {
        return level >= this.minCompressionLevel() && level <= this.maxCompressionLevel();
    }

    @Nullable
    public static CompressionOption fromOrdinal(int ord) {
        return ord >= 0 && ord < VALUES.length ? VALUES[ord] : null;
    }

    static {
        VALUES = CompressionOption.values();
    }
}

