/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueDouble
extends Value {
    public static final int PRECISION = 17;
    public static final int DISPLAY_SIZE = 24;
    public static final long ZERO_BITS = 0L;
    public static final ValueDouble ZERO = new ValueDouble(0.0);
    public static final ValueDouble ONE = new ValueDouble(1.0);
    private static final ValueDouble NAN = new ValueDouble(Double.NaN);
    private final double value;

    private ValueDouble(double value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueDouble v2 = (ValueDouble)v;
        return ValueDouble.get(this.value + v2.value);
    }

    @Override
    public Value subtract(Value v) {
        ValueDouble v2 = (ValueDouble)v;
        return ValueDouble.get(this.value - v2.value);
    }

    @Override
    public Value negate() {
        return ValueDouble.get(-this.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueDouble v2 = (ValueDouble)v;
        return ValueDouble.get(this.value * v2.value);
    }

    @Override
    public Value divide(Value v) {
        ValueDouble v2 = (ValueDouble)v;
        if (v2.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueDouble.get(this.value / v2.value);
    }

    @Override
    public ValueDouble modulus(Value v) {
        ValueDouble other = (ValueDouble)v;
        if (other.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueDouble.get(this.value % other.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        if (this.value == Double.POSITIVE_INFINITY) {
            builder.append("POWER(0, -1)");
        } else if (this.value == Double.NEGATIVE_INFINITY) {
            builder.append("(-POWER(0, -1))");
        } else if (Double.isNaN(this.value)) {
            builder.append("SQRT(-1)");
        } else {
            builder.append(this.value);
        }
        return builder;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_DOUBLE;
    }

    @Override
    public int getValueType() {
        return 7;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        return Double.compare(this.value, ((ValueDouble)o).value);
    }

    @Override
    public int getSignum() {
        return this.value == 0.0 ? 0 : (this.value < 0.0 ? -1 : 1);
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (Math.abs(this.value) <= Double.MAX_VALUE) {
            return BigDecimal.valueOf(this.value);
        }
        throw DbException.get(22018, Double.toString(this.value));
    }

    @Override
    public String getString() {
        return Double.toString(this.value);
    }

    @Override
    public int hashCode() {
        long hash = Double.doubleToRawLongBits(this.value);
        return (int)(hash ^ hash >>> 32);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setDouble(parameterIndex, this.value);
    }

    public static ValueDouble get(double d) {
        if (d == 1.0) {
            return ONE;
        }
        if (d == 0.0) {
            return ZERO;
        }
        if (Double.isNaN(d)) {
            return NAN;
        }
        return (ValueDouble)ValueDouble.cache(new ValueDouble(d));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueDouble)) {
            return false;
        }
        return this.compareTypeSafe((ValueDouble)other, null) == 0;
    }
}

