/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

public class ParserUtil {
    public static final int KEYWORD = 1;
    public static final int IDENTIFIER = 2;
    public static final int ALL = 3;
    public static final int ARRAY = 4;
    public static final int CASE = 5;
    public static final int CHECK = 6;
    public static final int CONSTRAINT = 7;
    public static final int CROSS = 8;
    public static final int CURRENT_DATE = 9;
    public static final int CURRENT_TIME = 10;
    public static final int CURRENT_TIMESTAMP = 11;
    public static final int CURRENT_USER = 12;
    public static final int DISTINCT = 13;
    public static final int EXCEPT = 14;
    public static final int EXISTS = 15;
    public static final int FALSE = 16;
    public static final int FETCH = 17;
    public static final int FOR = 18;
    public static final int FOREIGN = 19;
    public static final int FROM = 20;
    public static final int FULL = 21;
    public static final int GROUP = 22;
    public static final int HAVING = 23;
    public static final int IF = 24;
    public static final int INNER = 25;
    public static final int INTERSECT = 26;
    public static final int INTERSECTS = 27;
    public static final int INTERVAL = 28;
    public static final int IS = 29;
    public static final int JOIN = 30;
    public static final int LIKE = 31;
    public static final int LIMIT = 32;
    public static final int LOCALTIME = 33;
    public static final int LOCALTIMESTAMP = 34;
    public static final int MINUS = 35;
    public static final int NATURAL = 36;
    public static final int NOT = 37;
    public static final int NULL = 38;
    public static final int OFFSET = 39;
    public static final int ON = 40;
    public static final int ORDER = 41;
    public static final int PRIMARY = 42;
    public static final int QUALIFY = 43;
    public static final int ROW = 44;
    public static final int _ROWID_ = 45;
    public static final int ROWNUM = 46;
    public static final int SELECT = 47;
    public static final int TABLE = 48;
    public static final int TRUE = 49;
    public static final int UNION = 50;
    public static final int UNIQUE = 51;
    public static final int VALUES = 52;
    public static final int WHERE = 53;
    public static final int WINDOW = 54;
    public static final int WITH = 55;
    private static final int UPPER_OR_OTHER_LETTER = 50;
    private static final int UPPER_OR_OTHER_LETTER_OR_DIGIT = 562;
    private static final int LOWER_OR_OTHER_LETTER = 52;
    private static final int LOWER_OR_OTHER_LETTER_OR_DIGIT = 564;
    private static final int LETTER = 62;
    private static final int LETTER_OR_DIGIT = 574;

    private ParserUtil() {
    }

    public static boolean isKeyword(String s, boolean ignoreCase) {
        int length = s.length();
        if (length == 0) {
            return false;
        }
        return ParserUtil.getSaveTokenType(s, ignoreCase, 0, length, false) != 2;
    }

    public static boolean isSimpleIdentifier(String s, boolean databaseToUpper, boolean databaseToLower) {
        int partFlags;
        int startFlags;
        int length = s.length();
        if (length == 0) {
            return false;
        }
        if (databaseToUpper) {
            if (databaseToLower) {
                throw new IllegalArgumentException("databaseToUpper && databaseToLower");
            }
            startFlags = 50;
            partFlags = 562;
        } else if (databaseToLower) {
            startFlags = 52;
            partFlags = 564;
        } else {
            startFlags = 62;
            partFlags = 574;
        }
        char c = s.charAt(0);
        if ((startFlags >>> Character.getType(c) & 1) == 0 && c != '_') {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            c = s.charAt(i);
            if ((partFlags >>> Character.getType(c) & 1) != 0 || c == '_') continue;
            return false;
        }
        return ParserUtil.getSaveTokenType(s, !databaseToUpper, 0, length, true) == 2;
    }

    public static int getSaveTokenType(String s, boolean ignoreCase, int start, int end, boolean additionalKeywords) {
        char c = s.charAt(start);
        if (ignoreCase) {
            c = (char)(c & 0xFFDF);
        }
        switch (c) {
            case 'A': {
                if (ParserUtil.eq("ALL", s, ignoreCase, start, end)) {
                    return 3;
                }
                if (ParserUtil.eq("ARRAY", s, ignoreCase, start, end)) {
                    return 4;
                }
                if (additionalKeywords && (ParserUtil.eq("AND", s, ignoreCase, start, end) || ParserUtil.eq("AS", s, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'B': {
                if (additionalKeywords && (ParserUtil.eq("BETWEEN", s, ignoreCase, start, end) || ParserUtil.eq("BOTH", s, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'C': {
                if (ParserUtil.eq("CASE", s, ignoreCase, start, end)) {
                    return 5;
                }
                if (ParserUtil.eq("CHECK", s, ignoreCase, start, end)) {
                    return 6;
                }
                if (ParserUtil.eq("CONSTRAINT", s, ignoreCase, start, end)) {
                    return 7;
                }
                if (ParserUtil.eq("CROSS", s, ignoreCase, start, end)) {
                    return 8;
                }
                if (ParserUtil.eq("CURRENT_DATE", s, ignoreCase, start, end)) {
                    return 9;
                }
                if (ParserUtil.eq("CURRENT_TIME", s, ignoreCase, start, end)) {
                    return 10;
                }
                if (ParserUtil.eq("CURRENT_TIMESTAMP", s, ignoreCase, start, end)) {
                    return 11;
                }
                if (ParserUtil.eq("CURRENT_USER", s, ignoreCase, start, end)) {
                    return 12;
                }
                return 2;
            }
            case 'D': {
                if (ParserUtil.eq("DISTINCT", s, ignoreCase, start, end)) {
                    return 13;
                }
                return 2;
            }
            case 'E': {
                if (ParserUtil.eq("EXCEPT", s, ignoreCase, start, end)) {
                    return 14;
                }
                if (ParserUtil.eq("EXISTS", s, ignoreCase, start, end)) {
                    return 15;
                }
                return 2;
            }
            case 'F': {
                if (ParserUtil.eq("FETCH", s, ignoreCase, start, end)) {
                    return 17;
                }
                if (ParserUtil.eq("FROM", s, ignoreCase, start, end)) {
                    return 20;
                }
                if (ParserUtil.eq("FOR", s, ignoreCase, start, end)) {
                    return 18;
                }
                if (ParserUtil.eq("FOREIGN", s, ignoreCase, start, end)) {
                    return 19;
                }
                if (ParserUtil.eq("FULL", s, ignoreCase, start, end)) {
                    return 21;
                }
                if (ParserUtil.eq("FALSE", s, ignoreCase, start, end)) {
                    return 16;
                }
                if (additionalKeywords && ParserUtil.eq("FILTER", s, ignoreCase, start, end)) {
                    return 1;
                }
                return 2;
            }
            case 'G': {
                if (ParserUtil.eq("GROUP", s, ignoreCase, start, end)) {
                    return 22;
                }
                if (additionalKeywords && ParserUtil.eq("GROUPS", s, ignoreCase, start, end)) {
                    return 1;
                }
                return 2;
            }
            case 'H': {
                if (ParserUtil.eq("HAVING", s, ignoreCase, start, end)) {
                    return 23;
                }
                return 2;
            }
            case 'I': {
                if (ParserUtil.eq("IF", s, ignoreCase, start, end)) {
                    return 24;
                }
                if (ParserUtil.eq("INNER", s, ignoreCase, start, end)) {
                    return 25;
                }
                if (ParserUtil.eq("INTERSECT", s, ignoreCase, start, end)) {
                    return 26;
                }
                if (ParserUtil.eq("INTERSECTS", s, ignoreCase, start, end)) {
                    return 27;
                }
                if (ParserUtil.eq("INTERVAL", s, ignoreCase, start, end)) {
                    return 28;
                }
                if (ParserUtil.eq("IS", s, ignoreCase, start, end)) {
                    return 29;
                }
                if (additionalKeywords && (ParserUtil.eq("ILIKE", s, ignoreCase, start, end) || ParserUtil.eq("IN", s, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'J': {
                if (ParserUtil.eq("JOIN", s, ignoreCase, start, end)) {
                    return 30;
                }
                return 2;
            }
            case 'L': {
                if (ParserUtil.eq("LIMIT", s, ignoreCase, start, end)) {
                    return 32;
                }
                if (ParserUtil.eq("LIKE", s, ignoreCase, start, end)) {
                    return 31;
                }
                if (ParserUtil.eq("LOCALTIME", s, ignoreCase, start, end)) {
                    return 33;
                }
                if (ParserUtil.eq("LOCALTIMESTAMP", s, ignoreCase, start, end)) {
                    return 34;
                }
                if (additionalKeywords && (ParserUtil.eq("LEADING", s, ignoreCase, start, end) || ParserUtil.eq("LEFT", s, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'M': {
                if (ParserUtil.eq("MINUS", s, ignoreCase, start, end)) {
                    return 35;
                }
                return 2;
            }
            case 'N': {
                if (ParserUtil.eq("NOT", s, ignoreCase, start, end)) {
                    return 37;
                }
                if (ParserUtil.eq("NATURAL", s, ignoreCase, start, end)) {
                    return 36;
                }
                if (ParserUtil.eq("NULL", s, ignoreCase, start, end)) {
                    return 38;
                }
                return 2;
            }
            case 'O': {
                if (ParserUtil.eq("OFFSET", s, ignoreCase, start, end)) {
                    return 39;
                }
                if (ParserUtil.eq("ON", s, ignoreCase, start, end)) {
                    return 40;
                }
                if (ParserUtil.eq("ORDER", s, ignoreCase, start, end)) {
                    return 41;
                }
                if (additionalKeywords && (ParserUtil.eq("OR", s, ignoreCase, start, end) || ParserUtil.eq("OVER", s, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'P': {
                if (ParserUtil.eq("PRIMARY", s, ignoreCase, start, end)) {
                    return 42;
                }
                if (additionalKeywords && ParserUtil.eq("PARTITION", s, ignoreCase, start, end)) {
                    return 1;
                }
                return 2;
            }
            case 'Q': {
                if (ParserUtil.eq("QUALIFY", s, ignoreCase, start, end)) {
                    return 43;
                }
                return 2;
            }
            case 'R': {
                if (ParserUtil.eq("ROW", s, ignoreCase, start, end)) {
                    return 44;
                }
                if (ParserUtil.eq("ROWNUM", s, ignoreCase, start, end)) {
                    return 46;
                }
                if (additionalKeywords && (ParserUtil.eq("RANGE", s, ignoreCase, start, end) || ParserUtil.eq("REGEXP", s, ignoreCase, start, end) || ParserUtil.eq("ROWS", s, ignoreCase, start, end) || ParserUtil.eq("RIGHT", s, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'S': {
                if (ParserUtil.eq("SELECT", s, ignoreCase, start, end)) {
                    return 47;
                }
                if (additionalKeywords && (ParserUtil.eq("SYSDATE", s, ignoreCase, start, end) || ParserUtil.eq("SYSTIME", s, ignoreCase, start, end) || ParserUtil.eq("SYSTIMESTAMP", s, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'T': {
                if (ParserUtil.eq("TABLE", s, ignoreCase, start, end)) {
                    return 48;
                }
                if (ParserUtil.eq("TRUE", s, ignoreCase, start, end)) {
                    return 49;
                }
                if (additionalKeywords && (ParserUtil.eq("TODAY", s, ignoreCase, start, end) || ParserUtil.eq("TOP", s, ignoreCase, start, end) || ParserUtil.eq("TRAILING", s, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'U': {
                if (ParserUtil.eq("UNIQUE", s, ignoreCase, start, end)) {
                    return 51;
                }
                if (ParserUtil.eq("UNION", s, ignoreCase, start, end)) {
                    return 50;
                }
                return 2;
            }
            case 'V': {
                if (ParserUtil.eq("VALUES", s, ignoreCase, start, end)) {
                    return 52;
                }
                return 2;
            }
            case 'W': {
                if (ParserUtil.eq("WHERE", s, ignoreCase, start, end)) {
                    return 53;
                }
                if (ParserUtil.eq("WINDOW", s, ignoreCase, start, end)) {
                    return 54;
                }
                if (ParserUtil.eq("WITH", s, ignoreCase, start, end)) {
                    return 55;
                }
                return 2;
            }
            case '_': {
                if (end - start != 7 || !"_ROWID_".regionMatches(ignoreCase, 0, s, start, 7)) break;
                return 45;
            }
        }
        return 2;
    }

    private static boolean eq(String expected, String s, boolean ignoreCase, int start, int end) {
        int len = expected.length();
        return end - start == len && expected.regionMatches(ignoreCase, 1, s, start + 1, len - 1);
    }
}

