/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.security.auth;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gridgain.internal.h2.security.auth.H2AuthConfig;
import org.gridgain.internal.h2.security.auth.HasConfigProperties;
import org.gridgain.internal.h2.security.auth.PropertyConfig;
import org.gridgain.internal.h2.security.auth.RealmConfig;
import org.gridgain.internal.h2.security.auth.UserToRolesMapperConfig;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class H2AuthConfigXml
extends DefaultHandler {
    private H2AuthConfig result;
    private HasConfigProperties lastConfigProperties;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (qName) {
            case "h2Auth": {
                this.result = new H2AuthConfig();
                this.result.setAllowUserRegistration("true".equals(H2AuthConfigXml.getAttributeValueOr("allowUserRegistration", attributes, "false")));
                this.result.setCreateMissingRoles("true".equals(H2AuthConfigXml.getAttributeValueOr("createMissingRoles", attributes, "true")));
                break;
            }
            case "realm": {
                RealmConfig realmConfig = new RealmConfig();
                realmConfig.setName(H2AuthConfigXml.getMandatoryAttributeValue("name", attributes));
                realmConfig.setValidatorClass(H2AuthConfigXml.getMandatoryAttributeValue("validatorClass", attributes));
                this.result.getRealms().add(realmConfig);
                this.lastConfigProperties = realmConfig;
                break;
            }
            case "userToRolesMapper": {
                UserToRolesMapperConfig userToRolesMapperConfig = new UserToRolesMapperConfig();
                userToRolesMapperConfig.setClassName(H2AuthConfigXml.getMandatoryAttributeValue("className", attributes));
                this.result.getUserToRolesMappers().add(userToRolesMapperConfig);
                this.lastConfigProperties = userToRolesMapperConfig;
                break;
            }
            case "property": {
                if (this.lastConfigProperties == null) {
                    throw new SAXException("property element in the wrong place");
                }
                this.lastConfigProperties.getProperties().add(new PropertyConfig(H2AuthConfigXml.getMandatoryAttributeValue("name", attributes), H2AuthConfigXml.getMandatoryAttributeValue("value", attributes)));
                break;
            }
            default: {
                throw new SAXException("unexpected element " + qName);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.lastConfigProperties != null && !"property".equals(qName)) {
            this.lastConfigProperties = null;
        }
    }

    private static String getMandatoryAttributeValue(String attributeName, Attributes attributes) throws SAXException {
        String attributeValue = attributes.getValue(attributeName);
        if (attributeValue == null || attributeValue.trim().equals("")) {
            throw new SAXException("missing attribute " + attributeName);
        }
        return attributeValue;
    }

    private static String getAttributeValueOr(String attributeName, Attributes attributes, String defaultValue) {
        String attributeValue = attributes.getValue(attributeName);
        if (attributeValue == null || attributeValue.trim().equals("")) {
            return defaultValue;
        }
        return attributeValue;
    }

    public H2AuthConfig getResult() {
        return this.result;
    }

    public static H2AuthConfig parseFrom(URL url) throws SAXException, IOException, ParserConfigurationException {
        try (InputStream inputStream = url.openStream();){
            H2AuthConfig h2AuthConfig = H2AuthConfigXml.parseFrom(inputStream);
            return h2AuthConfig;
        }
    }

    public static H2AuthConfig parseFrom(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        H2AuthConfigXml xmlHandler = new H2AuthConfigXml();
        saxParser.parse(inputStream, (DefaultHandler)xmlHandler);
        return xmlHandler.getResult();
    }
}

