/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.result;

import java.util.ArrayList;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.store.Data;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.store.FileStore;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;

public class RowList
implements AutoCloseable {
    private final Session session;
    private final ArrayList<Row> list = Utils.newSmallArrayList();
    private int size;
    private int index;
    private int listIndex;
    private FileStore file;
    private Data rowBuff;
    private ArrayList<Value> lobs;
    private final int maxMemory;
    private int memory;
    private boolean written;

    public RowList(Session session) {
        this.session = session;
        this.maxMemory = session.getDatabase().isPersistent() ? session.getDatabase().getMaxOperationMemory() : 0;
    }

    private void writeRow(Data buff, Row r) {
        buff.checkCapacity(22);
        buff.writeByte((byte)1);
        buff.writeInt(r.getMemory());
        int columnCount = r.getColumnCount();
        buff.writeInt(columnCount);
        buff.writeLong(r.getKey());
        buff.writeByte(r.isDeleted() ? (byte)1 : 0);
        for (int i = 0; i < columnCount; ++i) {
            Value v = r.getValue(i);
            buff.checkCapacity(1);
            if (v == null) {
                buff.writeByte((byte)0);
                continue;
            }
            buff.writeByte((byte)1);
            if (DataType.isLargeObject(v.getValueType()) && v.getSmall() == null && v.getTableId() == 0) {
                if (this.lobs == null) {
                    this.lobs = Utils.newSmallArrayList();
                }
                v = v.copyToTemp();
                this.lobs.add(v);
            }
            buff.checkCapacity(buff.getValueLen(v));
            buff.writeValue(v);
        }
    }

    private void writeAllRows() {
        if (this.file == null) {
            Database db = this.session.getDatabase();
            String fileName = db.createTempFile();
            this.file = db.openFile(fileName, "rw", false);
            this.file.setCheckedWriting(false);
            this.file.seek(48L);
            this.rowBuff = Data.create((DataHandler)db, 4096, true);
            this.file.seek(48L);
        }
        Data buff = this.rowBuff;
        RowList.initBuffer(buff);
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0 && buff.length() > 4096) {
                this.flushBuffer(buff);
                RowList.initBuffer(buff);
            }
            Row r = this.list.get(i);
            this.writeRow(buff, r);
        }
        this.flushBuffer(buff);
        this.list.clear();
        this.memory = 0;
    }

    private static void initBuffer(Data buff) {
        buff.reset();
        buff.writeInt(0);
    }

    private void flushBuffer(Data buff) {
        buff.checkCapacity(1);
        buff.writeByte((byte)0);
        buff.fillAligned();
        buff.setInt(0, buff.length() / 16);
        this.file.write(buff.getBytes(), 0, buff.length());
    }

    public void add(Row r) {
        this.list.add(r);
        this.memory += r.getMemory() + 8;
        if (this.maxMemory > 0 && this.memory > this.maxMemory) {
            this.writeAllRows();
        }
        ++this.size;
    }

    public void reset() {
        this.index = 0;
        if (this.file != null) {
            this.listIndex = 0;
            if (!this.written) {
                this.writeAllRows();
                this.written = true;
            }
            this.list.clear();
            this.file.seek(48L);
        }
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    private Row readRow(Data buff) {
        if (buff.readByte() == 0) {
            return null;
        }
        int mem = buff.readInt();
        int columnCount = buff.readInt();
        long key = buff.readLong();
        boolean deleted = buff.readByte() != 0;
        Value[] values = new Value[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Value v;
            if (buff.readByte() == 0) {
                v = null;
            } else {
                v = (Value)buff.readValue();
                if (v.isLinkedToTable() && v.getTableId() == 0) {
                    this.session.removeAtCommit(v);
                }
            }
            values[i] = v;
        }
        Row row = this.session.createRow(values, mem);
        row.setKey(key);
        row.setDeleted(deleted);
        return row;
    }

    public Row next() {
        Row r;
        if (this.file == null) {
            r = this.list.get(this.index++);
        } else {
            if (this.listIndex >= this.list.size()) {
                this.list.clear();
                this.listIndex = 0;
                Data buff = this.rowBuff;
                buff.reset();
                int min = 16;
                this.file.readFully(buff.getBytes(), 0, min);
                int len = buff.readInt() * 16;
                buff.checkCapacity(len);
                if (len - min > 0) {
                    this.file.readFully(buff.getBytes(), min, len - min);
                }
                while ((r = this.readRow(buff)) != null) {
                    this.list.add(r);
                }
            }
            ++this.index;
            r = this.list.get(this.listIndex++);
        }
        return r;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void close() {
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }
}

