/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.BinaryOperation;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.analysis.Window;
import org.gridgain.internal.h2.expression.analysis.WindowFrameBound;
import org.gridgain.internal.h2.expression.analysis.WindowFrameBoundType;
import org.gridgain.internal.h2.expression.analysis.WindowFrameExclusion;
import org.gridgain.internal.h2.expression.analysis.WindowFrameUnits;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public final class WindowFrame {
    private final WindowFrameUnits units;
    private final WindowFrameBound starting;
    private final WindowFrameBound following;
    private final WindowFrameExclusion exclusion;

    public static Iterator<Value[]> iterator(Window over, Session session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow, boolean reverse) {
        WindowFrame frame = over.getWindowFrame();
        if (frame != null) {
            return frame.iterator(session, orderedRows, sortOrder, currentRow, reverse);
        }
        int endIndex = orderedRows.size() - 1;
        return WindowFrame.plainIterator(orderedRows, 0, over.getOrderBy() == null ? endIndex : WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, endIndex), reverse);
    }

    public static int getEndIndex(Window over, Session session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow) {
        WindowFrame frame = over.getWindowFrame();
        if (frame != null) {
            return frame.getEndIndex(session, orderedRows, sortOrder, currentRow);
        }
        int endIndex = orderedRows.size() - 1;
        return over.getOrderBy() == null ? endIndex : WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, endIndex);
    }

    private static Iterator<Value[]> plainIterator(ArrayList<Value[]> orderedRows, int startIndex, int endIndex, boolean reverse) {
        if (endIndex < startIndex) {
            return Collections.emptyIterator();
        }
        return reverse ? new PlainReverseItr(orderedRows, startIndex, endIndex) : new PlainItr(orderedRows, startIndex, endIndex);
    }

    private static Iterator<Value[]> biIterator(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2, boolean reverse) {
        return reverse ? new BiReverseItr(orderedRows, startIndex1, endIndex1, startIndex2, endIndex2) : new BiItr(orderedRows, startIndex1, endIndex1, startIndex2, endIndex2);
    }

    private static Iterator<Value[]> triIterator(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2, int startIndex3, int endIndex3, boolean reverse) {
        return reverse ? new TriReverseItr(orderedRows, startIndex1, endIndex1, startIndex2, endIndex2, startIndex3, endIndex3) : new TriItr(orderedRows, startIndex1, endIndex1, startIndex2, endIndex2, startIndex3, endIndex3);
    }

    private static int toGroupStart(ArrayList<Value[]> orderedRows, SortOrder sortOrder, int offset, int minOffset) {
        Value[] row = orderedRows.get(offset);
        while (offset > minOffset && sortOrder.compare(row, orderedRows.get(offset - 1)) == 0) {
            --offset;
        }
        return offset;
    }

    private static int toGroupEnd(ArrayList<Value[]> orderedRows, SortOrder sortOrder, int offset, int maxOffset) {
        Value[] row = orderedRows.get(offset);
        while (offset < maxOffset && sortOrder.compare(row, orderedRows.get(offset + 1)) == 0) {
            ++offset;
        }
        return offset;
    }

    private static int getIntOffset(WindowFrameBound bound, Value[] values, Session session) {
        Value v = bound.isVariable() ? values[bound.getExpressionIndex()] : bound.getValue().getValue(session);
        int value = v.getInt();
        if (v == ValueNull.INSTANCE || value < 0) {
            throw DbException.get(22013, v.getTraceSQL());
        }
        return value;
    }

    private static Value[] getCompareRow(Session session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow, WindowFrameBound bound, boolean add) {
        Value newValue;
        int sortIndex = sortOrder.getQueryColumnIndexes()[0];
        Value[] row = orderedRows.get(currentRow);
        Value currentValue = row[sortIndex];
        int type = currentValue.getValueType();
        Value range = WindowFrame.getValueOffset(bound, orderedRows.get(currentRow), session);
        switch (type) {
            case 0: {
                newValue = ValueNull.INSTANCE;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                BinaryOperation.OpType opType = add ^ (sortOrder.getSortTypes()[0] & 1) != 0 ? BinaryOperation.OpType.PLUS : BinaryOperation.OpType.MINUS;
                try {
                    newValue = new BinaryOperation(opType, ValueExpression.get(currentValue), ValueExpression.get(range)).optimize(session).getValue(session).convertTo(type);
                    break;
                }
                catch (DbException ex) {
                    switch (ex.getErrorCode()) {
                        case 22003: 
                        case 22004: {
                            return null;
                        }
                    }
                    throw ex;
                }
            }
            default: {
                throw DbException.getInvalidValueException("unsupported type of sort key for RANGE units", currentValue.getTraceSQL());
            }
        }
        Value[] newRow = (Value[])row.clone();
        newRow[sortIndex] = newValue;
        return newRow;
    }

    private static Value getValueOffset(WindowFrameBound bound, Value[] values, Session session) {
        Value value;
        Value value2 = value = bound.isVariable() ? values[bound.getExpressionIndex()] : bound.getValue().getValue(session);
        if (value == ValueNull.INSTANCE || value.getSignum() < 0) {
            throw DbException.get(22013, value.getTraceSQL());
        }
        return value;
    }

    public WindowFrame(WindowFrameUnits units, WindowFrameBound starting, WindowFrameBound following, WindowFrameExclusion exclusion) {
        this.units = units;
        this.starting = starting;
        if (following != null && following.getType() == WindowFrameBoundType.CURRENT_ROW) {
            following = null;
        }
        this.following = following;
        this.exclusion = exclusion;
    }

    public WindowFrameUnits getUnits() {
        return this.units;
    }

    public WindowFrameBound getStarting() {
        return this.starting;
    }

    public WindowFrameBound getFollowing() {
        return this.following;
    }

    public WindowFrameExclusion getExclusion() {
        return this.exclusion;
    }

    public boolean isValid() {
        WindowFrameBoundType s = this.starting.getType();
        WindowFrameBoundType f = this.following != null ? this.following.getType() : WindowFrameBoundType.CURRENT_ROW;
        return s != WindowFrameBoundType.UNBOUNDED_FOLLOWING && f != WindowFrameBoundType.UNBOUNDED_PRECEDING && s.compareTo(f) <= 0;
    }

    public boolean isVariableBounds() {
        if (this.starting.isVariable()) {
            return true;
        }
        return this.following != null && this.following.isVariable();
    }

    void mapColumns(ColumnResolver resolver, int level, int state) {
        this.starting.mapColumns(resolver, level, state);
        if (this.following != null) {
            this.following.mapColumns(resolver, level, state);
        }
    }

    void optimize(Session session) {
        this.starting.optimize(session);
        if (this.following != null) {
            this.following.optimize(session);
        }
    }

    void updateAggregate(Session session, int stage) {
        this.starting.updateAggregate(session, stage);
        if (this.following != null) {
            this.following.updateAggregate(session, stage);
        }
    }

    public Iterator<Value[]> iterator(Session session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow, boolean reverse) {
        int endIndex;
        int startIndex = this.getIndex(session, orderedRows, sortOrder, currentRow, this.starting, false);
        int n = this.following != null ? this.getIndex(session, orderedRows, sortOrder, currentRow, this.following, true) : (endIndex = this.units == WindowFrameUnits.ROWS ? currentRow : WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, orderedRows.size() - 1));
        if (endIndex < startIndex) {
            return Collections.emptyIterator();
        }
        int size = orderedRows.size();
        if (startIndex >= size || endIndex < 0) {
            return Collections.emptyIterator();
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= size) {
            endIndex = size - 1;
        }
        return this.exclusion != WindowFrameExclusion.EXCLUDE_NO_OTHERS ? this.complexIterator(orderedRows, sortOrder, currentRow, startIndex, endIndex, reverse) : WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
    }

    public int getStartIndex(Session session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow) {
        if (this.exclusion != WindowFrameExclusion.EXCLUDE_NO_OTHERS) {
            throw new UnsupportedOperationException();
        }
        int startIndex = this.getIndex(session, orderedRows, sortOrder, currentRow, this.starting, false);
        if (startIndex < 0) {
            startIndex = 0;
        }
        return startIndex;
    }

    private int getEndIndex(Session session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow) {
        int size;
        if (this.exclusion != WindowFrameExclusion.EXCLUDE_NO_OTHERS) {
            throw new UnsupportedOperationException();
        }
        int endIndex = this.following != null ? this.getIndex(session, orderedRows, sortOrder, currentRow, this.following, true) : (this.units == WindowFrameUnits.ROWS ? currentRow : WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, orderedRows.size() - 1));
        if (endIndex >= (size = orderedRows.size())) {
            endIndex = size - 1;
        }
        return endIndex;
    }

    private int getIndex(Session session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow, WindowFrameBound bound, boolean forFollowing) {
        int index;
        int size = orderedRows.size();
        int last = size - 1;
        block0 : switch (bound.getType()) {
            case UNBOUNDED_PRECEDING: {
                index = -1;
                break;
            }
            case PRECEDING: {
                switch (this.units) {
                    case ROWS: {
                        int value = WindowFrame.getIntOffset(bound, orderedRows.get(currentRow), session);
                        index = value > currentRow ? -1 : currentRow - value;
                        break block0;
                    }
                    case GROUPS: {
                        int value;
                        if (!forFollowing) {
                            index = WindowFrame.toGroupStart(orderedRows, sortOrder, currentRow, 0);
                            for (value = WindowFrame.getIntOffset(bound, orderedRows.get(currentRow), session); value > 0 && index > 0; --value) {
                                index = WindowFrame.toGroupStart(orderedRows, sortOrder, index - 1, 0);
                            }
                            if (value <= 0) break block0;
                            index = -1;
                            break block0;
                        }
                        if (value == 0) {
                            index = WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, last);
                            break block0;
                        }
                        index = currentRow;
                        while (value > 0 && index >= 0) {
                            --value;
                            index = WindowFrame.toGroupStart(orderedRows, sortOrder, index, 0) - 1;
                        }
                        break block0;
                    }
                    case RANGE: {
                        index = currentRow;
                        Value[] row = WindowFrame.getCompareRow(session, orderedRows, sortOrder, index, bound, false);
                        if (row != null) {
                            index = Collections.binarySearch(orderedRows, row, sortOrder);
                            if (index >= 0) {
                                if (!forFollowing) {
                                    while (index > 0 && sortOrder.compare(row, orderedRows.get(index - 1)) == 0) {
                                        --index;
                                    }
                                } else {
                                    while (index < last && sortOrder.compare(row, orderedRows.get(index + 1)) == 0) {
                                        ++index;
                                    }
                                }
                                break block0;
                            }
                            index ^= 0xFFFFFFFF;
                            if (!forFollowing) {
                                if (index != 0) break block0;
                                index = -1;
                                break block0;
                            }
                            --index;
                            break block0;
                        }
                        index = -1;
                        break block0;
                    }
                    default: {
                        throw DbException.getUnsupportedException("units=" + (Object)((Object)this.units));
                    }
                }
            }
            case CURRENT_ROW: {
                switch (this.units) {
                    case ROWS: {
                        index = currentRow;
                        break block0;
                    }
                    case GROUPS: 
                    case RANGE: {
                        index = forFollowing ? WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, last) : WindowFrame.toGroupStart(orderedRows, sortOrder, currentRow, 0);
                        break block0;
                    }
                }
                throw DbException.getUnsupportedException("units=" + (Object)((Object)this.units));
            }
            case FOLLOWING: {
                switch (this.units) {
                    case ROWS: {
                        int value = WindowFrame.getIntOffset(bound, orderedRows.get(currentRow), session);
                        int rem = last - currentRow;
                        index = value > rem ? size : currentRow + value;
                        break block0;
                    }
                    case GROUPS: {
                        int value;
                        if (forFollowing) {
                            index = WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, last);
                            for (value = WindowFrame.getIntOffset(bound, orderedRows.get(currentRow), session); value > 0 && index < last; --value) {
                                index = WindowFrame.toGroupEnd(orderedRows, sortOrder, index + 1, last);
                            }
                            if (value <= 0) break block0;
                            index = size;
                            break block0;
                        }
                        if (value == 0) {
                            index = WindowFrame.toGroupStart(orderedRows, sortOrder, currentRow, 0);
                            break block0;
                        }
                        index = currentRow;
                        while (value > 0 && index <= last) {
                            --value;
                            index = WindowFrame.toGroupEnd(orderedRows, sortOrder, index, last) + 1;
                        }
                        break block0;
                    }
                    case RANGE: {
                        index = currentRow;
                        Value[] row = WindowFrame.getCompareRow(session, orderedRows, sortOrder, index, bound, true);
                        if (row != null) {
                            index = Collections.binarySearch(orderedRows, row, sortOrder);
                            if (index >= 0) {
                                if (forFollowing) {
                                    while (index < last && sortOrder.compare(row, orderedRows.get(index + 1)) == 0) {
                                        ++index;
                                    }
                                } else {
                                    while (index > 0 && sortOrder.compare(row, orderedRows.get(index - 1)) == 0) {
                                        --index;
                                    }
                                }
                                break block0;
                            }
                            if (!forFollowing || (index ^= 0xFFFFFFFF) == size) break block0;
                            --index;
                            break block0;
                        }
                        index = size;
                        break block0;
                    }
                    default: {
                        throw DbException.getUnsupportedException("units=" + (Object)((Object)this.units));
                    }
                }
            }
            case UNBOUNDED_FOLLOWING: {
                index = size;
                break;
            }
            default: {
                throw DbException.getUnsupportedException("window frame bound type=" + (Object)((Object)bound.getType()));
            }
        }
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Iterator<Value[]> complexIterator(ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow, int startIndex, int endIndex, boolean reverse) {
        if (this.exclusion == WindowFrameExclusion.EXCLUDE_CURRENT_ROW) {
            if (currentRow < startIndex || currentRow > endIndex) return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
            if (currentRow == startIndex) {
                ++startIndex;
                return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
            } else {
                if (currentRow != endIndex) return WindowFrame.biIterator(orderedRows, startIndex, currentRow - 1, currentRow + 1, endIndex, reverse);
                --endIndex;
            }
            return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
        } else {
            boolean includeCurrentRow;
            int exStart = WindowFrame.toGroupStart(orderedRows, sortOrder, currentRow, startIndex);
            int exEnd = WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, endIndex);
            boolean bl = includeCurrentRow = this.exclusion == WindowFrameExclusion.EXCLUDE_TIES;
            if (includeCurrentRow) {
                if (currentRow == exStart) {
                    ++exStart;
                    includeCurrentRow = false;
                } else if (currentRow == exEnd) {
                    --exEnd;
                    includeCurrentRow = false;
                }
            }
            if (exStart > exEnd || exEnd < startIndex || exStart > endIndex) return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
            if (includeCurrentRow) {
                if (startIndex == exStart) {
                    if (endIndex != exEnd) return WindowFrame.biIterator(orderedRows, currentRow, currentRow, exEnd + 1, endIndex, reverse);
                    return Collections.singleton(orderedRows.get(currentRow)).iterator();
                }
                if (endIndex != exEnd) return WindowFrame.triIterator(orderedRows, startIndex, exStart - 1, currentRow, currentRow, exEnd + 1, endIndex, reverse);
                return WindowFrame.biIterator(orderedRows, startIndex, exStart - 1, currentRow, currentRow, reverse);
            }
            if (startIndex >= exStart) {
                startIndex = exEnd + 1;
                return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
            } else {
                if (endIndex > exEnd) return WindowFrame.biIterator(orderedRows, startIndex, exStart - 1, exEnd + 1, endIndex, reverse);
                endIndex = exStart - 1;
            }
        }
        return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
    }

    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append(this.units.getSQL());
        if (this.following == null) {
            builder.append(' ');
            this.starting.getSQL(builder, false, alwaysQuote);
        } else {
            builder.append(" BETWEEN ");
            this.starting.getSQL(builder, false, alwaysQuote).append(" AND ");
            this.following.getSQL(builder, true, alwaysQuote);
        }
        if (this.exclusion != WindowFrameExclusion.EXCLUDE_NO_OTHERS) {
            builder.append(' ').append(this.exclusion.getSQL());
        }
        return builder;
    }

    private static final class TriReverseItr
    extends BiReverseItr {
        private final int end2;
        private final int start2;

        TriReverseItr(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2, int startIndex3, int endIndex3) {
            super(orderedRows, startIndex1, endIndex1, startIndex2, endIndex3);
            this.end2 = endIndex2;
            this.start2 = startIndex3;
        }

        @Override
        public Value[] next() {
            if (this.cursor < this.startIndex) {
                throw new NoSuchElementException();
            }
            Value[] r = (Value[])this.orderedRows.get(this.cursor);
            this.cursor = this.cursor != this.start1 ? (this.cursor != this.start2 ? this.cursor - 1 : this.end2) : this.end1;
            return r;
        }
    }

    private static final class TriItr
    extends BiItr {
        private final int end2;
        private final int start2;

        TriItr(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2, int startIndex3, int endIndex3) {
            super(orderedRows, startIndex1, endIndex1, startIndex2, endIndex3);
            this.end2 = endIndex2;
            this.start2 = startIndex3;
        }

        @Override
        public Value[] next() {
            if (this.cursor > this.endIndex) {
                throw new NoSuchElementException();
            }
            Value[] r = (Value[])this.orderedRows.get(this.cursor);
            this.cursor = this.cursor != this.end1 ? (this.cursor != this.end2 ? this.cursor + 1 : this.start2) : this.start1;
            return r;
        }
    }

    private static class BiReverseItr
    extends PlainReverseItr {
        final int end1;
        final int start1;

        BiReverseItr(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2) {
            super(orderedRows, startIndex1, endIndex2);
            this.end1 = endIndex1;
            this.start1 = startIndex2;
        }

        @Override
        public Value[] next() {
            if (this.cursor < this.startIndex) {
                throw new NoSuchElementException();
            }
            Value[] r = (Value[])this.orderedRows.get(this.cursor);
            this.cursor = this.cursor != this.start1 ? this.cursor - 1 : this.end1;
            return r;
        }
    }

    private static class BiItr
    extends PlainItr {
        final int end1;
        final int start1;

        BiItr(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2) {
            super(orderedRows, startIndex1, endIndex2);
            this.end1 = endIndex1;
            this.start1 = startIndex2;
        }

        @Override
        public Value[] next() {
            if (this.cursor > this.endIndex) {
                throw new NoSuchElementException();
            }
            Value[] r = (Value[])this.orderedRows.get(this.cursor);
            this.cursor = this.cursor != this.end1 ? this.cursor + 1 : this.start1;
            return r;
        }
    }

    private static class PlainReverseItr
    extends Itr {
        final int startIndex;

        PlainReverseItr(ArrayList<Value[]> orderedRows, int startIndex, int endIndex) {
            super(orderedRows);
            this.startIndex = startIndex;
            this.cursor = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.cursor >= this.startIndex;
        }

        @Override
        public Value[] next() {
            if (this.cursor < this.startIndex) {
                throw new NoSuchElementException();
            }
            return (Value[])this.orderedRows.get(this.cursor--);
        }
    }

    private static class PlainItr
    extends Itr {
        final int endIndex;

        PlainItr(ArrayList<Value[]> orderedRows, int startIndex, int endIndex) {
            super(orderedRows);
            this.endIndex = endIndex;
            this.cursor = startIndex;
        }

        @Override
        public boolean hasNext() {
            return this.cursor <= this.endIndex;
        }

        @Override
        public Value[] next() {
            if (this.cursor > this.endIndex) {
                throw new NoSuchElementException();
            }
            return (Value[])this.orderedRows.get(this.cursor++);
        }
    }

    private static abstract class Itr
    implements Iterator<Value[]> {
        final ArrayList<Value[]> orderedRows;
        int cursor;

        Itr(ArrayList<Value[]> orderedRows) {
            this.orderedRows = orderedRows;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

