/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.command.dml.Select;
import org.gridgain.internal.h2.command.dml.SelectGroups;
import org.gridgain.internal.h2.command.dml.SelectListColumnResolver;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.condition.Comparison;
import org.gridgain.internal.h2.index.IndexCondition;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Constant;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.ExtTypeInfo;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueNull;

public class ExpressionColumn
extends Expression {
    private final Database database;
    private final String schemaName;
    private final String tableAlias;
    private final String columnName;
    private final boolean rowId;
    private ColumnResolver columnResolver;
    private int queryLevel;
    private Column column;
    private String derivedName;

    public ExpressionColumn(Database database, Column column) {
        this.database = database;
        this.column = column;
        this.schemaName = null;
        this.tableAlias = null;
        this.columnName = null;
        this.rowId = column.isRowId();
    }

    public ExpressionColumn(Database database, String schemaName, String tableAlias, String columnName, boolean rowId) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableAlias = tableAlias;
        this.columnName = columnName;
        this.rowId = rowId;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        if (this.schemaName != null) {
            Parser.quoteIdentifier(builder, this.schemaName, alwaysQuote).append('.');
        }
        if (this.tableAlias != null) {
            Parser.quoteIdentifier(builder, this.tableAlias, alwaysQuote).append('.');
        }
        if (this.column != null) {
            if (this.derivedName != null) {
                Parser.quoteIdentifier(builder, this.derivedName, alwaysQuote);
            } else {
                this.column.getSQL(builder, alwaysQuote);
            }
        } else if (this.rowId) {
            builder.append(this.columnName);
        } else {
            Parser.quoteIdentifier(builder, this.columnName, alwaysQuote);
        }
        return builder;
    }

    public TableFilter getTableFilter() {
        return this.columnResolver == null ? null : this.columnResolver.getTableFilter();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        if (this.tableAlias != null && !this.database.equalsIdentifiers(this.tableAlias, resolver.getTableAlias())) {
            return;
        }
        if (this.schemaName != null && !this.database.equalsIdentifiers(this.schemaName, resolver.getSchemaName())) {
            return;
        }
        if (this.rowId) {
            Column col = resolver.getRowIdColumn();
            if (col != null) {
                this.mapColumn(resolver, col, level);
            }
            return;
        }
        for (Column col : resolver.getColumns()) {
            boolean derived;
            String n = resolver.getDerivedColumnName(col);
            if (n == null) {
                n = col.getName();
                derived = false;
            } else {
                derived = true;
            }
            if (!this.database.equalsIdentifiers(this.columnName, n)) continue;
            this.mapColumn(resolver, col, level);
            if (derived) {
                this.derivedName = n;
            }
            return;
        }
        Column[] columns = resolver.getSystemColumns();
        for (int i = 0; columns != null && i < columns.length; ++i) {
            Column col = columns[i];
            if (!this.database.equalsIdentifiers(this.columnName, col.getName())) continue;
            this.mapColumn(resolver, col, level);
            return;
        }
    }

    private void mapColumn(ColumnResolver resolver, Column col, int level) {
        if (this.columnResolver == null) {
            this.queryLevel = level;
            this.column = col;
            this.columnResolver = resolver;
        } else if (this.queryLevel == level && this.columnResolver != resolver && !(resolver instanceof SelectListColumnResolver)) {
            throw DbException.get(90059, this.columnName);
        }
    }

    @Override
    public Expression optimize(Session session) {
        if (this.columnResolver == null) {
            Constant constant;
            Schema schema = session.getDatabase().findSchema(this.tableAlias == null ? session.getCurrentSchemaName() : this.tableAlias);
            if (schema != null && (constant = schema.findConstant(this.columnName)) != null) {
                return constant.getValue();
            }
            throw this.getColumnException(42122);
        }
        return this.columnResolver.optimize(this, this.column);
    }

    public DbException getColumnException(int code) {
        String name = this.columnName;
        if (this.tableAlias != null) {
            name = this.tableAlias + '.' + name;
            if (this.schemaName != null) {
                name = this.schemaName + '.' + name;
            }
        }
        return DbException.get(code, name);
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        Select select = this.columnResolver.getSelect();
        if (select == null) {
            throw DbException.get(90016, this.getSQL(false));
        }
        if (stage == 0) {
            return;
        }
        SelectGroups groupData = select.getGroupDataIfCurrent(false);
        if (groupData == null) {
            return;
        }
        Value v = (Value)groupData.getCurrentGroupExprData(this);
        if (v == null) {
            groupData.setCurrentGroupExprData(this, this.columnResolver.getValue(this.column));
        } else if (!select.isGroupWindowStage2() && !this.database.areEqual(this.columnResolver.getValue(this.column), v)) {
            throw DbException.get(90016, this.getSQL(false));
        }
    }

    @Override
    public Value getValue(Session session) {
        ExtTypeInfo extTypeInfo;
        Value value;
        SelectGroups groupData;
        Select select = this.columnResolver.getSelect();
        if (select != null && (groupData = select.getGroupDataIfCurrent(false)) != null) {
            Value v = (Value)groupData.getCurrentGroupExprData(this);
            if (v != null) {
                return v;
            }
            if (select.isGroupWindowStage2()) {
                throw DbException.get(90016, this.getSQL(false));
            }
        }
        if ((value = this.columnResolver.getValue(this.column)) == null) {
            if (select == null) {
                throw DbException.get(23502, this.getSQL(false));
            }
            throw DbException.get(90016, this.getSQL(false));
        }
        if (value != ValueNull.INSTANCE && (extTypeInfo = this.column.getType().getExtTypeInfo()) != null) {
            return extTypeInfo.cast(value);
        }
        return value;
    }

    @Override
    public TypeInfo getType() {
        return this.column == null ? TypeInfo.TYPE_UNKNOWN : this.column.getType();
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
    }

    public Column getColumn() {
        return this.column;
    }

    public String getOriginalColumnName() {
        return this.columnName;
    }

    public String getOriginalTableAliasName() {
        return this.tableAlias;
    }

    @Override
    public String getColumnName() {
        return this.columnName != null ? this.columnName : this.column.getName();
    }

    @Override
    public String getSchemaName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getSchema().getName();
    }

    @Override
    public String getTableName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getName();
    }

    @Override
    public String getAlias() {
        if (this.column != null) {
            String name;
            if (this.columnResolver != null && (name = this.columnResolver.getDerivedColumnName(this.column)) != null) {
                return name;
            }
            return this.column.getName();
        }
        if (this.tableAlias != null) {
            return this.tableAlias + "." + this.columnName;
        }
        return this.columnName;
    }

    @Override
    public boolean isAutoIncrement() {
        return this.column.getSequence() != null;
    }

    @Override
    public int getNullable() {
        return this.column.isNullable() ? 1 : 0;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 1: {
                return false;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                return true;
            }
            case 0: {
                return this.queryLevel < visitor.getQueryLevel();
            }
            case 3: {
                if (visitor.getQueryLevel() < this.queryLevel) {
                    return true;
                }
                if (this.getTableFilter() == null) {
                    return false;
                }
                return this.getTableFilter().isEvaluatable();
            }
            case 4: {
                visitor.addDataModificationId(this.column.getTable().getMaxDataModificationId());
                return true;
            }
            case 6: {
                return this.columnResolver != visitor.getResolver();
            }
            case 7: {
                if (this.column != null) {
                    visitor.addDependency(this.column.getTable());
                }
                return true;
            }
            case 9: {
                if (this.column == null) {
                    throw DbException.get(42122, this.getSQL(false));
                }
                visitor.addColumn1(this.column);
                return true;
            }
            case 10: {
                if (this.column == null) {
                    throw DbException.get(42122, this.getSQL(false));
                }
                visitor.addColumn2(this.column);
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + visitor.getType());
    }

    @Override
    public int getCost() {
        return 2;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter filter) {
        TableFilter tf = this.getTableFilter();
        if (filter == tf && this.column.getType().getValueType() == 1) {
            IndexCondition cond = IndexCondition.get(0, this, ValueExpression.get(ValueBoolean.TRUE));
            filter.addIndexCondition(cond);
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.FALSE));
    }
}

