/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.compress.EntryCompressionStrategy;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.spi.IgniteSpiException;
import org.gridgain.grid.cache.compress.DictionaryCompressionMetrics;
import org.gridgain.grid.cache.compress.GzipCompressionConfiguration;

@IgniteExperimental
public class GzipCompressionStrategy
implements EntryCompressionStrategy {
    public static final int MIN_DELTA_BYTES = 8;
    private DictionaryCompressionMetrics metrics;
    private IgniteLogger log;

    public GzipCompressionStrategy(GzipCompressionConfiguration cfg) {
    }

    public byte[] tryCompress(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (GZIPOutputStream gz = new GZIPOutputStream((OutputStream)out, bytes.length);){
                gz.write(bytes);
            }
            catch (IOException ex) {
                this.log.warning("Failed to compress input", (Throwable)ex);
            }
            if (bytes.length - out.size() >= 8) {
                if (this.metrics != null) {
                    this.metrics.onTryCompress(true, bytes.length, out.size());
                }
                return out.toByteArray();
            }
        }
        if (this.metrics != null) {
            this.metrics.onTryCompress(false, bytes == null ? 0 : bytes.length, 0);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decompress(byte[] bytes) {
        if (this.metrics != null) {
            this.metrics.onDecompress(bytes.length);
        }
        try {
            byte[] uncompressed = new byte[bytes.length * 2];
            try (GZIPInputStream gz = new GZIPInputStream((InputStream)new ByteArrayInputStream(bytes), bytes.length);){
                int len = gz.read(uncompressed);
                if (len < uncompressed.length) {
                    byte[] byArray = Arrays.copyOf(uncompressed, len);
                    return byArray;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                do {
                    out.write(uncompressed, 0, len);
                } while ((len = gz.read(uncompressed)) > 0);
                byte[] byArray = out.toByteArray();
                return byArray;
            }
        }
        catch (IOException ex) {
            throw new IgniteSpiException("Failed to decompress input", (Throwable)ex);
        }
    }

    public boolean compressKeys() {
        return false;
    }

    public boolean stateless() {
        return true;
    }

    public void start(GridKernalContext ctx, CacheConfiguration ccfg) {
        this.log = ctx.log(GzipCompressionConfiguration.class);
        this.metrics = new DictionaryCompressionMetrics(ctx, GzipCompressionConfiguration.class.getName(), this.stateless(), ccfg.getName());
    }

    public void close() {
        if (this.metrics != null) {
            this.metrics.close();
        }
    }
}

