/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.CacheStoreAdapter;
import org.apache.ignite.cache.store.CacheStoreSession;
import org.apache.ignite.cache.store.hibernate.CacheHibernateBlobStoreEntry;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.CacheStoreSessionResource;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.transactions.Transaction;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.jetbrains.annotations.Nullable;

public class CacheHibernateBlobStore<K, V>
extends CacheStoreAdapter<K, V> {
    public static final String DFLT_CONN_URL = "jdbc:gg-h2:mem:hibernateCacheStore;DB_CLOSE_DELAY=-1;DEFAULT_LOCK_TIMEOUT=5000";
    public static final String DFLT_SHOW_SQL = "true";
    public static final String DFLT_HBM2DDL_AUTO = "update";
    public static final String DFLT_CONN_POOL_SIZE = "64";
    private static final String ATTR_SES = "HIBERNATE_STORE_SESSION";
    private static final String MAPPING_RESOURCE = "org/apache/ignite/cache/store/hibernate/CacheHibernateBlobStoreEntry.hbm.xml";
    private static final Marshaller marsh = new JdkMarshaller();
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final CountDownLatch initLatch = new CountDownLatch(1);
    @GridToStringExclude
    private Properties hibernateProps;
    @GridToStringExclude
    private SessionFactory sesFactory;
    private String hibernateCfgPath;
    @LoggerResource
    private IgniteLogger log;
    @CacheStoreSessionResource
    private CacheStoreSession ses;
    @IgniteInstanceResource
    private Ignite ignite;

    public V load(K key) {
        this.init();
        Transaction tx = this.transaction();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Store load [key=" + key + ", tx=" + tx + ']');
        }
        Session ses = this.session(tx);
        try {
            CacheHibernateBlobStoreEntry entry = (CacheHibernateBlobStoreEntry)ses.get(CacheHibernateBlobStoreEntry.class, (Serializable)this.toBytes(key));
            if (entry == null) {
                V v = null;
                return v;
            }
            Object x = this.fromBytes(entry.getValue());
            return (V)x;
        }
        catch (IgniteCheckedException | HibernateException e) {
            this.rollback((SharedSessionContract)ses, tx);
            throw new CacheLoaderException("Failed to load value from cache store with key: " + key, e);
        }
        finally {
            this.end(ses, tx);
        }
    }

    public void write(Cache.Entry<? extends K, ? extends V> entry) {
        this.init();
        Transaction tx = this.transaction();
        Object key = entry.getKey();
        Object val = entry.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Store put [key=" + key + ", val=" + val + ", tx=" + tx + ']');
        }
        if (val == null) {
            this.delete(key);
            return;
        }
        Session ses = this.session(tx);
        try {
            CacheHibernateBlobStoreEntry entry0 = new CacheHibernateBlobStoreEntry(this.toBytes(key), this.toBytes(val));
            ses.saveOrUpdate((Object)entry0);
        }
        catch (IgniteCheckedException | HibernateException e) {
            this.rollback((SharedSessionContract)ses, tx);
            throw new CacheWriterException("Failed to put value to cache store [key=" + key + ", val" + val + "]", e);
        }
        finally {
            this.end(ses, tx);
        }
    }

    public void delete(Object key) {
        this.init();
        Transaction tx = this.transaction();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Store remove [key=" + key + ", tx=" + tx + ']');
        }
        Session ses = this.session(tx);
        try {
            Object obj = ses.get(CacheHibernateBlobStoreEntry.class, (Serializable)this.toBytes(key));
            if (obj != null) {
                ses.delete(obj);
            }
        }
        catch (IgniteCheckedException | HibernateException e) {
            this.rollback((SharedSessionContract)ses, tx);
            throw new CacheWriterException("Failed to remove value from cache store with key: " + key, e);
        }
        finally {
            this.end(ses, tx);
        }
    }

    private void rollback(SharedSessionContract ses, Transaction tx) {
        org.hibernate.Transaction hTx;
        if (tx == null && (hTx = ses.getTransaction()) != null && hTx.getStatus().canRollback()) {
            hTx.rollback();
        }
    }

    private void end(Session ses, Transaction tx) {
        if (tx == null) {
            org.hibernate.Transaction hTx = ses.getTransaction();
            if (hTx != null && hTx.getStatus() == TransactionStatus.ACTIVE) {
                hTx.commit();
            }
            ses.close();
        }
    }

    public void sessionEnd(boolean commit) {
        org.hibernate.Transaction hTx;
        this.init();
        Transaction tx = this.transaction();
        Map props = this.session().properties();
        Session ses = (Session)props.remove(ATTR_SES);
        if (ses != null && (hTx = ses.getTransaction()) != null) {
            try {
                if (commit) {
                    ses.flush();
                    hTx.commit();
                } else {
                    hTx.rollback();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Transaction ended [xid=" + tx.xid() + ", commit=" + commit + ']');
                }
            }
            catch (HibernateException e) {
                throw new CacheWriterException("Failed to end transaction [xid=" + tx.xid() + ", commit=" + commit + ']', (Throwable)e);
            }
            finally {
                ses.close();
            }
        }
    }

    Session session(@Nullable Transaction tx) {
        Session ses;
        if (tx != null) {
            Map props = this.session().properties();
            ses = (Session)props.get(ATTR_SES);
            if (ses == null) {
                ses = this.sesFactory.openSession();
                ses.beginTransaction();
                props.put(ATTR_SES, ses);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Hibernate session open [ses=" + ses + ", tx=" + tx.xid() + "]");
                }
            }
        } else {
            ses = this.sesFactory.openSession();
            ses.beginTransaction();
        }
        return ses;
    }

    public void setSessionFactory(SessionFactory sesFactory) {
        this.sesFactory = sesFactory;
    }

    public void setHibernateConfigurationPath(String hibernateCfgPath) {
        this.hibernateCfgPath = hibernateCfgPath;
    }

    public void setHibernateProperties(Properties hibernateProps) {
        this.hibernateProps = hibernateProps;
    }

    /*
     * Exception decompiling
     */
    private void init() throws IgniteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resourceAvailable(String name) {
        InputStream cfgStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        if (cfgStream == null) {
            this.log.error("Classpath resource not found: " + name);
            return false;
        }
        try {
            cfgStream.read();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.log.error("Failed to read classpath resource: " + name, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            U.close((AutoCloseable)cfgStream, (IgniteLogger)this.log);
        }
    }

    public String toString() {
        return S.toString(CacheHibernateBlobStore.class, (Object)((Object)this));
    }

    protected byte[] toBytes(Object obj) throws IgniteCheckedException {
        return U.marshal((Marshaller)marsh, (Object)obj);
    }

    protected <X> X fromBytes(byte[] bytes) throws IgniteCheckedException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return (X)U.unmarshal((Marshaller)marsh, (byte[])bytes, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    @Nullable
    private Transaction transaction() {
        CacheStoreSession ses = this.session();
        return ses != null ? ses.transaction() : null;
    }

    private CacheStoreSession session() {
        return this.ses;
    }
}

