/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyAdapter;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.IgniteCachedDomainDataAccess;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class IgniteNaturalIdDataAccess
extends IgniteCachedDomainDataAccess
implements NaturalIdDataAccess {
    private final AccessType accessType;

    public IgniteNaturalIdDataAccess(HibernateAccessStrategyAdapter stgy, AccessType accessType, RegionFactory regionFactory, DomainDataRegion domainDataRegion, Ignite ignite, HibernateCacheProxy cache) {
        super(stgy, regionFactory, domainDataRegion, ignite, cache);
        this.accessType = accessType;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SharedSessionContractImplementor ses) {
        return DefaultCacheKeysFactory.staticCreateNaturalIdKey((Object[])naturalIdValues, (EntityPersister)persister, (SharedSessionContractImplementor)ses);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.staticGetNaturalIdValues((Object)cacheKey);
    }

    public boolean insert(SharedSessionContractImplementor ses, Object key, Object val) throws CacheException {
        return this.stgy.insert(key, val);
    }

    public boolean afterInsert(SharedSessionContractImplementor ses, Object key, Object val) throws CacheException {
        return this.stgy.afterInsert(key, val);
    }

    public boolean update(SharedSessionContractImplementor ses, Object key, Object val) throws CacheException {
        return this.stgy.update(key, val);
    }

    public boolean afterUpdate(SharedSessionContractImplementor ses, Object key, Object val, SoftLock lock) throws CacheException {
        return this.stgy.afterUpdate(key, val);
    }
}

