/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.HibernateRegion;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.DirectAccessRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.jetbrains.annotations.Nullable;

public class IgniteGeneralDataRegion
extends HibernateRegion
implements DirectAccessRegion {
    private final IgniteLogger log;

    IgniteGeneralDataRegion(RegionFactory factory, String name, Ignite ignite, HibernateCacheProxy cache) {
        super(factory, name, ignite, cache);
        this.log = ignite.log().getLogger(((Object)((Object)this)).getClass());
    }

    @Nullable
    public Object getFromCache(Object key, SharedSessionContractImplementor ses) throws CacheException {
        try {
            Object val = this.cache.get(key);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Get [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ']');
            }
            return val;
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void putIntoCache(Object key, Object val, SharedSessionContractImplementor ses) throws CacheException {
        try {
            this.cache.put(key, val);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Put [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ']');
            }
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void clear() {
        try {
            this.cache.clear();
        }
        catch (IgniteCheckedException e) {
            throw new CacheException("Problem clearing cache [name=" + this.cache.name() + "]", (Throwable)e);
        }
    }
}

