/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyAdapter;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyFactory;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.IgniteCollectionDataAccess;
import org.apache.ignite.cache.hibernate.IgniteEntityDataAccess;
import org.apache.ignite.cache.hibernate.IgniteNaturalIdDataAccess;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.CollectionDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.cfg.spi.EntityDataCachingConfig;
import org.hibernate.cache.cfg.spi.NaturalIdDataCachingConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.ExtendedStatisticsSupport;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.support.AbstractDomainDataRegion;

public class IgniteDomainDataRegion
extends AbstractDomainDataRegion
implements ExtendedStatisticsSupport {
    private final HibernateCacheProxy cache;
    private HibernateAccessStrategyFactory stgyFactory;

    public IgniteDomainDataRegion(DomainDataRegionConfig regionCfg, RegionFactory regionFactory, CacheKeysFactory defKeysFactory, DomainDataRegionBuildingContext buildingCtx, HibernateAccessStrategyFactory stgyFactory) {
        super(regionCfg, regionFactory, defKeysFactory, buildingCtx);
        this.stgyFactory = stgyFactory;
        this.cache = stgyFactory.regionCache(this.getName());
        this.completeInstantiation(regionCfg, buildingCtx);
    }

    protected EntityDataAccess generateEntityAccess(EntityDataCachingConfig entityAccessCfg) {
        AccessType accessType = entityAccessCfg.getAccessType();
        Ignite ignite = this.stgyFactory.node();
        switch (accessType) {
            case READ_ONLY: {
                HibernateAccessStrategyAdapter readOnlyStgy = this.stgyFactory.createReadOnlyStrategy(this.cache);
                return new IgniteEntityDataAccess(readOnlyStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, this.cache);
            }
            case NONSTRICT_READ_WRITE: {
                HibernateAccessStrategyAdapter nonStrictReadWriteStgy = this.stgyFactory.createNonStrictReadWriteStrategy(this.cache);
                return new IgniteEntityDataAccess(nonStrictReadWriteStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, this.cache);
            }
            case READ_WRITE: {
                HibernateAccessStrategyAdapter readWriteStgy = this.stgyFactory.createReadWriteStrategy(this.cache);
                return new IgniteEntityDataAccess(readWriteStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, this.cache);
            }
            case TRANSACTIONAL: {
                HibernateAccessStrategyAdapter transactionalStgy = this.stgyFactory.createTransactionalStrategy(this.cache);
                return new IgniteEntityDataAccess(transactionalStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, this.cache);
            }
        }
        throw new IllegalArgumentException("Unknown Hibernate access type: " + accessType);
    }

    protected CollectionDataAccess generateCollectionAccess(CollectionDataCachingConfig cachingCfg) {
        HibernateCacheProxy cache = this.stgyFactory.regionCache(this.getName());
        AccessType accessType = cachingCfg.getAccessType();
        Ignite ignite = this.stgyFactory.node();
        switch (accessType) {
            case READ_ONLY: {
                HibernateAccessStrategyAdapter readOnlyStgy = this.stgyFactory.createReadOnlyStrategy(cache);
                return new IgniteCollectionDataAccess(readOnlyStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, cache);
            }
            case NONSTRICT_READ_WRITE: {
                HibernateAccessStrategyAdapter nonStrictReadWriteStgy = this.stgyFactory.createNonStrictReadWriteStrategy(cache);
                return new IgniteCollectionDataAccess(nonStrictReadWriteStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, cache);
            }
            case READ_WRITE: {
                HibernateAccessStrategyAdapter readWriteStgy = this.stgyFactory.createReadWriteStrategy(cache);
                return new IgniteCollectionDataAccess(readWriteStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, cache);
            }
            case TRANSACTIONAL: {
                HibernateAccessStrategyAdapter transactionalStgy = this.stgyFactory.createTransactionalStrategy(cache);
                return new IgniteCollectionDataAccess(transactionalStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, cache);
            }
        }
        throw new IllegalArgumentException("Unknown Hibernate access type: " + accessType);
    }

    protected NaturalIdDataAccess generateNaturalIdAccess(NaturalIdDataCachingConfig naturalIdAccessCfg) {
        HibernateCacheProxy cache = this.stgyFactory.regionCache(this.getName());
        AccessType accessType = naturalIdAccessCfg.getAccessType();
        Ignite ignite = this.stgyFactory.node();
        switch (accessType) {
            case READ_ONLY: {
                HibernateAccessStrategyAdapter readOnlyStgy = this.stgyFactory.createReadOnlyStrategy(cache);
                return new IgniteNaturalIdDataAccess(readOnlyStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, cache);
            }
            case NONSTRICT_READ_WRITE: {
                HibernateAccessStrategyAdapter nonStrictReadWriteStgy = this.stgyFactory.createNonStrictReadWriteStrategy(cache);
                return new IgniteNaturalIdDataAccess(nonStrictReadWriteStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, cache);
            }
            case READ_WRITE: {
                HibernateAccessStrategyAdapter readWriteStgy = this.stgyFactory.createReadWriteStrategy(cache);
                return new IgniteNaturalIdDataAccess(readWriteStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, cache);
            }
            case TRANSACTIONAL: {
                HibernateAccessStrategyAdapter transactionalStgy = this.stgyFactory.createTransactionalStrategy(cache);
                return new IgniteNaturalIdDataAccess(transactionalStgy, accessType, this.getRegionFactory(), (DomainDataRegion)this, ignite, cache);
            }
        }
        throw new IllegalArgumentException("Unknown Hibernate access type: " + accessType);
    }

    public void destroy() throws CacheException {
    }

    public long getElementCountInMemory() {
        return this.cache.offHeapEntriesCount();
    }

    public long getElementCountOnDisk() {
        return this.cache.sizeLong();
    }

    public long getSizeInMemory() {
        return this.cache.offHeapAllocatedSize();
    }
}

