/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyAdapter;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.HibernateRegion;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.jetbrains.annotations.Nullable;

public abstract class IgniteCachedDomainDataAccess
extends HibernateRegion
implements CachedDomainDataAccess {
    protected final HibernateAccessStrategyAdapter stgy;
    private DomainDataRegion domainDataRegion;

    protected IgniteCachedDomainDataAccess(HibernateAccessStrategyAdapter stgy, RegionFactory regionFactory, DomainDataRegion domainDataRegion, Ignite ignite, HibernateCacheProxy cache) {
        super(regionFactory, cache.name(), ignite, cache);
        this.stgy = stgy;
        this.domainDataRegion = domainDataRegion;
    }

    public DomainDataRegion getRegion() {
        return this.domainDataRegion;
    }

    public Object get(SharedSessionContractImplementor ses, Object key) throws CacheException {
        return this.stgy.get(key);
    }

    public boolean putFromLoad(SharedSessionContractImplementor ses, Object key, Object value, Object version) throws CacheException {
        this.stgy.putFromLoad(key, value);
        return true;
    }

    public boolean putFromLoad(SharedSessionContractImplementor ses, Object key, Object value, Object version, boolean minimalPutOverride) throws CacheException {
        this.stgy.putFromLoad(key, value);
        return true;
    }

    public SoftLock lockItem(SharedSessionContractImplementor ses, Object key, Object version) throws CacheException {
        this.stgy.lock(key);
        return null;
    }

    public void unlockItem(SharedSessionContractImplementor ses, Object key, SoftLock lock) throws CacheException {
        this.stgy.unlock(key);
    }

    public void remove(SharedSessionContractImplementor ses, Object key) throws CacheException {
        this.stgy.remove(key);
    }

    @Nullable
    public SoftLock lockRegion() throws CacheException {
        this.stgy.lockRegion();
        return null;
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
        this.stgy.unlockRegion();
    }

    public void removeAll(SharedSessionContractImplementor ses) throws CacheException {
        this.stgy.removeAll();
    }

    public void evict(Object key) throws CacheException {
        this.stgy.evict(key);
    }

    public void evictAll() throws CacheException {
        this.stgy.evictAll();
    }

    public boolean contains(Object key) {
        return this.stgy.get(key) != null;
    }
}

