/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import java.time.Instant;
import java.util.Map;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyFactory;
import org.apache.ignite.cache.hibernate.HibernateExceptionConverter;
import org.apache.ignite.cache.hibernate.HibernateKeyTransformer;
import org.apache.ignite.cache.hibernate.IgniteDomainDataRegion;
import org.apache.ignite.cache.hibernate.IgniteQueryResultsRegion;
import org.apache.ignite.cache.hibernate.IgniteTimestampsRegion;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class HibernateRegionFactory
implements RegionFactory {
    private static final long serialVersionUID = 0L;
    static final HibernateExceptionConverter EXCEPTION_CONVERTER = new HibernateExceptionConverter(){

        public RuntimeException convert(Exception e) {
            return new CacheException((Throwable)e);
        }
    };
    private AccessType dfltAccessType;
    private final HibernateKeyTransformer hibernate4transformer = new HibernateKeyTransformer(){

        public Object transform(Object key) {
            return key;
        }
    };
    private final HibernateAccessStrategyFactory accessStgyFactory = new HibernateAccessStrategyFactory(this.hibernate4transformer, EXCEPTION_CONVERTER);
    private SessionFactoryOptions options;

    public void start(SessionFactoryOptions options, Map cfgValues) throws CacheException {
        this.options = options;
        String accessType = cfgValues.getOrDefault("org.apache.ignite.hibernate.default_access_type", AccessType.NONSTRICT_READ_WRITE.name()).toString();
        this.dfltAccessType = AccessType.valueOf((String)accessType);
        this.accessStgyFactory.start(cfgValues);
    }

    HibernateAccessStrategyFactory accessStrategyFactory() {
        return this.accessStgyFactory;
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public AccessType getDefaultAccessType() {
        return this.dfltAccessType;
    }

    public long nextTimestamp() {
        return Instant.now().toEpochMilli();
    }

    public String qualify(String regionName) {
        return RegionNameQualifier.INSTANCE.qualify(regionName, this.options);
    }

    public DomainDataRegion buildDomainDataRegion(DomainDataRegionConfig regionCfg, DomainDataRegionBuildingContext buildingCtx) {
        return new IgniteDomainDataRegion(regionCfg, this, null, buildingCtx, this.accessStgyFactory);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, SessionFactoryImplementor sessFactory) {
        return new IgniteQueryResultsRegion(this, regionName, this.accessStgyFactory.node(), this.accessStgyFactory.regionCache(regionName));
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, SessionFactoryImplementor sessFactory) {
        return new IgniteTimestampsRegion(this, regionName, this.accessStgyFactory.node(), this.accessStgyFactory.regionCache(regionName));
    }
}

