/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.ExtendedStatisticsSupport;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.support.AbstractRegion;

public abstract class HibernateRegion
extends AbstractRegion
implements ExtendedStatisticsSupport {
    protected final HibernateCacheProxy cache;
    protected Ignite ignite;

    protected HibernateRegion(RegionFactory factory, String name, Ignite ignite, HibernateCacheProxy cache) {
        super(name, factory);
        this.ignite = ignite;
        this.cache = cache;
    }

    public void clear() {
        try {
            this.cache.clear();
        }
        catch (IgniteCheckedException e) {
            throw new CacheException("Problem clearing cache [name=" + this.cache.name() + "]", (Throwable)e);
        }
    }

    public void destroy() throws CacheException {
    }

    public long getElementCountInMemory() {
        return this.cache.offHeapEntriesCount();
    }

    public long getElementCountOnDisk() {
        return this.cache.sizeLong();
    }

    public long getSizeInMemory() {
        return this.cache.offHeapAllocatedSize();
    }
}

